/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.documentapi.DocumentAccessProvider;
import com.yahoo.container.di.config.ApplicationBundlesConfig;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.handler.metrics.MetricsV2Handler;
import com.yahoo.container.handler.metrics.PrometheusV1Handler;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ConfigProducerGroup;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.xml.PlatformBundles;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ApplicationContainerCluster
extends ContainerCluster<ApplicationContainer>
implements ApplicationBundlesConfig.Producer,
QrStartConfig.Producer,
RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
OnnxModelsConfig.Producer,
RankingExpressionsConfig.Producer,
ServletPathsConfig.Producer,
ContainerMbusConfig.Producer,
MetricsProxyApiConfig.Producer,
ZookeeperServerConfig.Producer {
    public static final String METRICS_V2_HANDLER_CLASS = MetricsV2Handler.class.getName();
    public static final BindingPattern METRICS_V2_HANDLER_BINDING_1 = SystemBindingPattern.fromHttpPath("/metrics/v2");
    public static final BindingPattern METRICS_V2_HANDLER_BINDING_2 = SystemBindingPattern.fromHttpPath("/metrics/v2/*");
    public static final String PROMETHEUS_V1_HANDLER_CLASS = PrometheusV1Handler.class.getName();
    private static final BindingPattern PROMETHEUS_V1_HANDLER_BINDING_1 = SystemBindingPattern.fromHttpPath("/prometheus/v1");
    private static final BindingPattern PROMETHEUS_V1_HANDLER_BINDING_2 = SystemBindingPattern.fromHttpPath("/prometheus/v1/*");
    public static final int heapSizePercentageOfTotalNodeMemory = 70;
    public static final int heapSizePercentageOfTotalNodeMemoryWhenCombinedCluster = 18;
    private final Set<FileReference> applicationBundles = new LinkedHashSet<FileReference>();
    private final ConfigProducerGroup<Servlet> servletGroup;
    private final Set<String> previousHosts;
    private ContainerModelEvaluation modelEvaluation;
    private final Optional<String> tlsClientAuthority;
    private MbusParams mbusParams;
    private boolean messageBusEnabled = true;
    private Integer memoryPercentage = null;

    public ApplicationContainerCluster(AbstractConfigProducer<?> parent, String configSubId, String clusterId, DeployState deployState) {
        super(parent, configSubId, clusterId, deployState, true);
        this.tlsClientAuthority = deployState.tlsClientAuthority();
        this.servletGroup = new ConfigProducerGroup(this, "servlet");
        this.previousHosts = deployState.getPreviousModel().stream().map(Model::allocatedHosts).map(AllocatedHosts::getHosts).flatMap(Collection::stream).map(HostSpec::hostname).collect(Collectors.toUnmodifiableSet());
        this.addSimpleComponent("com.yahoo.language.provider.DefaultLinguisticsProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.SecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.DeprecatedSecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.CertificateStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.AthenzIdentityProviderProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.SystemInfoProvider");
        this.addSimpleComponent(DocumentAccessProvider.class.getName());
        this.addMetricsHandlers();
        this.addTestrunnerComponentsIfTester(deployState);
    }

    @Override
    protected void doPrepare(DeployState deployState) {
        this.addAndSendApplicationBundles(deployState);
        if (this.modelEvaluation != null) {
            this.modelEvaluation.prepare(this.containers);
        }
        this.sendUserConfiguredFiles(deployState);
    }

    private void addAndSendApplicationBundles(DeployState deployState) {
        for (ComponentInfo component : deployState.getApplicationPackage().getComponentsInfo(deployState.getVespaVersion())) {
            FileReference reference = deployState.getFileRegistry().addFile(component.getPathRelativeToAppDir());
            FileSender.send(reference, this.containers);
            this.applicationBundles.add(reference);
        }
    }

    private void sendUserConfiguredFiles(DeployState deployState) {
        FileSender fileSender = new FileSender(this.containers, deployState.getFileRegistry(), deployState.getDeployLogger());
        for (Component<?, ?> component : this.getAllComponents()) {
            fileSender.sendUserConfiguredFiles(component);
        }
    }

    private void addMetricsHandlers() {
        this.addMetricsHandler(METRICS_V2_HANDLER_CLASS, METRICS_V2_HANDLER_BINDING_1, METRICS_V2_HANDLER_BINDING_2);
        this.addMetricsHandler(PROMETHEUS_V1_HANDLER_CLASS, PROMETHEUS_V1_HANDLER_BINDING_1, PROMETHEUS_V1_HANDLER_BINDING_2);
    }

    private void addMetricsHandler(String handlerClass, BindingPattern rootBinding, BindingPattern innerBinding) {
        Handler handler = new Handler(new ComponentModel(handlerClass, null, null, null));
        handler.addServerBindings(rootBinding, innerBinding);
        this.addComponent(handler);
    }

    private void addTestrunnerComponentsIfTester(DeployState deployState) {
        if (deployState.isHosted() && deployState.getProperties().applicationId().instance().isTester()) {
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("vespa-testrunner-components"));
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("vespa-osgi-testrunner"));
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("tenant-cd-api"));
            if (deployState.zone().system().isPublic()) {
                this.addPlatformBundle(PlatformBundles.absoluteBundlePath("cloud-tenant-cd"));
            }
        }
    }

    public void setModelEvaluation(ContainerModelEvaluation modelEvaluation) {
        this.modelEvaluation = modelEvaluation;
    }

    public Map<ComponentId, Servlet> getServletMap() {
        return this.servletGroup.getComponentMap();
    }

    public final void addServlet(Servlet servlet) {
        this.servletGroup.addComponent(servlet.getGlobalComponentId(), servlet);
    }

    public Collection<Servlet> getAllServlets() {
        return this.allServlets().collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<Servlet> allServlets() {
        return this.servletGroup.getComponents().stream();
    }

    public void setMemoryPercentage(Integer memoryPercentage) {
        this.memoryPercentage = memoryPercentage;
    }

    public Optional<Integer> getMemoryPercentage() {
        return Optional.ofNullable(this.memoryPercentage);
    }

    public void getConfig(ApplicationBundlesConfig.Builder builder) {
        this.applicationBundles.stream().map(FileReference::value).forEach(arg_0 -> ((ApplicationBundlesConfig.Builder)builder).bundles(arg_0));
    }

    public void getConfig(ServletPathsConfig.Builder builder) {
        this.allServlets().forEach(servlet -> builder.servlets(servlet.getComponentId().stringValue(), servlet.toConfigBuilder()));
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        if (this.mbusParams != null) {
            if (this.mbusParams.maxConcurrentFactor != null) {
                builder.maxConcurrentFactor(this.mbusParams.maxConcurrentFactor.doubleValue());
            }
            if (this.mbusParams.documentExpansionFactor != null) {
                builder.documentExpansionFactor(this.mbusParams.documentExpansionFactor.doubleValue());
            }
            if (this.mbusParams.containerCoreMemory != null) {
                builder.containerCoreMemory(this.mbusParams.containerCoreMemory.intValue());
            }
        }
        if (this.getDocproc() != null) {
            this.getDocproc().getConfig(builder);
        }
    }

    public void getConfig(MetricsProxyApiConfig.Builder builder) {
        builder.metricsPort(19092).metricsApiPath("/applicationmetrics/v1/values").prometheusApiPath("/applicationmetrics/v1/prometheus");
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.verbosegc(true).availableProcessors(0).compressedClassSpaceSize(0).minHeapsize(1536).heapsize(1536);
        if (this.getMemoryPercentage().isPresent()) {
            builder.jvm.heapSizeAsPercentageOfPhysicalMemory(this.getMemoryPercentage().get().intValue());
        } else if (this.isHostedVespa()) {
            builder.jvm.heapSizeAsPercentageOfPhysicalMemory(this.getHostClusterId().isPresent() ? 18 : 70);
        }
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        if (this.getParent() instanceof ConfigserverCluster) {
            return;
        }
        for (Container container : this.getContainers()) {
            ZookeeperServerConfig.Server.Builder serverBuilder = new ZookeeperServerConfig.Server.Builder();
            serverBuilder.hostname(container.getHostName()).id(container.index()).joining(!this.previousHosts.isEmpty() && !this.previousHosts.contains(container.getHostName()));
            builder.server(serverBuilder);
            builder.dynamicReconfiguration(true);
        }
    }

    public Optional<String> getTlsClientAuthority() {
        return this.tlsClientAuthority;
    }

    public void setMbusParams(MbusParams mbusParams) {
        this.mbusParams = mbusParams;
    }

    public final void setMessageBusEnabled(boolean messageBusEnabled) {
        this.messageBusEnabled = messageBusEnabled;
    }

    @Override
    protected boolean messageBusEnabled() {
        return this.messageBusEnabled;
    }

    public void addMbusServer(ComponentId chainId) {
        ComponentId serviceId = chainId.nestInNamespace(ComponentId.fromString((String)"MbusServer"));
        this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(serviceId, ComponentSpecification.fromString((String)MbusServerProvider.class.getName()), null))));
    }

    public static class MbusParams {
        final Double maxConcurrentFactor;
        final Double documentExpansionFactor;
        final Integer containerCoreMemory;

        public MbusParams(Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory) {
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }
    }
}

