/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.CompressionConfig;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationTypeRegistry;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.FieldSets;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.TemporaryImportedFields;
import com.yahoo.searchdefinition.document.TemporarySDDocumentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SDDocumentType
implements Cloneable,
Serializable {
    public static final SDDocumentType VESPA_DOCUMENT = new SDDocumentType(VespaDocumentType.INSTANCE.getFullName().getName());
    private Map<DataTypeName, SDDocumentType> inheritedTypes = new HashMap<DataTypeName, SDDocumentType>();
    private Map<NewDocumentType.Name, SDDocumentType> ownedTypes = new HashMap<NewDocumentType.Name, SDDocumentType>();
    private AnnotationTypeRegistry annotationTypes = new AnnotationTypeRegistry();
    private DocumentType docType;
    private DataType structType;
    private FieldSets fieldSets;
    private Optional<DocumentReferences> documentReferences = Optional.empty();
    private TemporaryImportedFields temporaryImportedFields;

    public SDDocumentType clone() throws CloneNotSupportedException {
        SDDocumentType type = (SDDocumentType)super.clone();
        type.docType = this.docType.clone();
        type.inheritedTypes.putAll(this.inheritedTypes);
        type.structType = this.structType;
        return type;
    }

    public SDDocumentType addType(SDDocumentType dt) {
        NewDocumentType.Name name = new NewDocumentType.Name(dt.getName());
        if (this.getType(name) != null) {
            throw new IllegalArgumentException("Data type '" + name.toString() + "' has already been used.");
        }
        if (name.getName() == this.docType.getName()) {
            throw new IllegalArgumentException("Data type '" + name.toString() + "' can not have same name as its defining document.");
        }
        this.ownedTypes.put(name, dt);
        return this;
    }

    public final SDDocumentType getOwnedType(String name) {
        return this.getOwnedType(new NewDocumentType.Name(name));
    }

    public SDDocumentType getOwnedType(DataTypeName name) {
        return this.getOwnedType(name.getName());
    }

    public SDDocumentType getOwnedType(NewDocumentType.Name name) {
        return this.ownedTypes.get(name);
    }

    public final SDDocumentType getType(String name) {
        return this.getType(new NewDocumentType.Name(name));
    }

    public SDDocumentType getType(NewDocumentType.Name name) {
        SDDocumentType type = this.ownedTypes.get(name);
        if (type == null) {
            for (SDDocumentType inherited : this.inheritedTypes.values()) {
                type = inherited.getType(name);
                if (type == null) continue;
                return type;
            }
        }
        return type;
    }

    public SDDocumentType addAnnotation(AnnotationType annotation) {
        this.annotationTypes.register(annotation);
        return this;
    }

    public Collection<SDDocumentType> getTypes() {
        return this.ownedTypes.values();
    }

    public Collection<AnnotationType> getAnnotations() {
        return this.annotationTypes.getTypes().values();
    }

    public AnnotationType findAnnotation(String name) {
        return this.annotationTypes.getType(name);
    }

    public Collection<SDDocumentType> getAllTypes() {
        ArrayList<SDDocumentType> list = new ArrayList<SDDocumentType>();
        list.addAll(this.getTypes());
        for (SDDocumentType inherited : this.inheritedTypes.values()) {
            list.addAll(inherited.getAllTypes());
        }
        return list;
    }

    public SDDocumentType(String name) {
        this(name, null);
    }

    public SDDocumentType(DataTypeName name) {
        this(name.getName());
    }

    public SDDocumentType(String name, Search search) {
        this.docType = new DocumentType(name);
        this.docType.contentStruct().setCompressionConfig(new CompressionConfig());
        this.validateId(search);
        this.inherit(VESPA_DOCUMENT);
    }

    public boolean isStruct() {
        return this.getStruct() != null;
    }

    public DataType getStruct() {
        return this.structType;
    }

    public SDDocumentType setStruct(DataType structType) {
        if (structType != null) {
            this.structType = structType;
            this.inheritedTypes.clear();
        } else if (this.docType.contentStruct() != null) {
            this.structType = this.docType.contentStruct();
            this.inheritedTypes.clear();
        } else {
            throw new IllegalArgumentException("You can not set a null struct");
        }
        return this;
    }

    public String getName() {
        return this.docType.getName();
    }

    public DataTypeName getDocumentName() {
        return this.docType.getDataTypeName();
    }

    public DocumentType getDocumentType() {
        return this.docType;
    }

    public void inherit(DataTypeName name) {
        if (!this.inheritedTypes.containsKey(name)) {
            this.inheritedTypes.put(name, new TemporarySDDocumentType(name));
        }
    }

    public void inherit(SDDocumentType type) {
        if (type != null && (!this.inheritedTypes.containsKey(type.getDocumentName()) || this.inheritedTypes.get(type.getDocumentName()) instanceof TemporarySDDocumentType)) {
            this.inheritedTypes.put(type.getDocumentName(), type);
        }
    }

    public Collection<SDDocumentType> getInheritedTypes() {
        return this.inheritedTypes.values();
    }

    protected void validateId(Search search) {
        if (search == null) {
            return;
        }
        if (search.getDocument(this.getName()) == null) {
            return;
        }
        SDDocumentType doc = search.getDocument();
        throw new IllegalArgumentException("Failed creating document type '" + this.getName() + "', document type '" + doc.getName() + "' already uses ID '" + doc.getName() + "'");
    }

    public void setFieldId(SDField field, int id) {
        field.setId(id, this.docType);
    }

    public Field getField(String name) {
        Field f;
        if (name.contains(".")) {
            String superFieldName = name.substring(0, name.indexOf("."));
            String subFieldName = name.substring(name.indexOf(".") + 1);
            Field f2 = this.docType.getField(superFieldName);
            if (f2 != null) {
                if (f2 instanceof SDField) {
                    SDField superField = (SDField)f2;
                    return superField.getStructField(subFieldName);
                }
                throw new IllegalArgumentException("Field " + f2.getName() + " is not SDField");
            }
        }
        if ((f = this.docType.getField(name)) == null) {
            for (SDDocumentType parent : this.inheritedTypes.values()) {
                f = parent.getField(name);
                if (f == null) continue;
                return f;
            }
        }
        return f;
    }

    public void addField(Field field) {
        this.verifyInheritance(field);
        Iterator i = this.docType.fieldIteratorThisTypeOnly();
        while (i.hasNext()) {
            if (!field.getName().equalsIgnoreCase(((Field)i.next()).getName())) continue;
            throw new IllegalArgumentException("Duplicate (case insensitively) " + field + " in " + this);
        }
        this.docType.addField(field);
    }

    private void verifyInheritance(Field field) {
        for (SDDocumentType parent : this.inheritedTypes.values()) {
            for (Field pField : parent.fieldSet()) {
                if (!pField.getName().equals(field.getName()) || pField.getDataType().equals((Object)field.getDataType())) continue;
                throw new IllegalArgumentException("For search '" + this.getName() + "', field '" + field.getName() + "': datatype can't be different from that of same field in supertype '" + parent.getName() + "'.");
            }
        }
    }

    public SDField addField(String string, DataType dataType) {
        SDField field = new SDField(this, string, dataType);
        this.addField(field);
        return field;
    }

    public Field addField(String string, DataType dataType, boolean header, int code) {
        SDField field = new SDField(this, string, code, dataType, header);
        this.addField(field);
        return field;
    }

    private Map<String, Field> fieldsInherited() {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (SDDocumentType parent : this.inheritedTypes.values()) {
            for (Field field : parent.fieldSet()) {
                map.put(field.getName(), field);
            }
        }
        return map;
    }

    public Set<Field> fieldSet() {
        Map<String, Field> map = this.fieldsInherited();
        Iterator it = this.docType.fieldIteratorThisTypeOnly();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            map.put(field.getName(), field);
        }
        return new LinkedHashSet<Field>(map.values());
    }

    public Iterator<Field> fieldIterator() {
        return this.fieldSet().iterator();
    }

    public int getFieldCount() {
        return this.docType.getFieldCount();
    }

    public String toString() {
        return "SD document type '" + this.docType.getName() + "'";
    }

    private static SDDocumentType createSDDocumentType(StructDataType structType) {
        SDDocumentType docType = new SDDocumentType(structType.getName());
        for (Field field : structType.getFields()) {
            docType.addField(new SDField(docType, field.getName(), field.getDataType()));
        }
        docType.setStruct((DataType)structType);
        return docType;
    }

    public FieldSets getFieldSets() {
        return this.fieldSets;
    }

    public void setFieldSets(FieldSets fieldSets) {
        this.fieldSets = fieldSets;
    }

    public Optional<DocumentReferences> getDocumentReferences() {
        return this.documentReferences;
    }

    public void setDocumentReferences(DocumentReferences documentReferences) {
        this.documentReferences = Optional.of(documentReferences);
    }

    public TemporaryImportedFields getTemporaryImportedFields() {
        return this.temporaryImportedFields;
    }

    public void setTemporaryImportedFields(TemporaryImportedFields temporaryImportedFields) {
        this.temporaryImportedFields = temporaryImportedFields;
    }

    static {
        VESPA_DOCUMENT.addType(SDDocumentType.createSDDocumentType(PositionDataType.INSTANCE));
    }
}

