/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RankingConstants {
    private final Map<String, RankingConstant> constants = new HashMap<String, RankingConstant>();
    private final FileRegistry fileRegistry;

    public RankingConstants(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    public void add(RankingConstant constant) {
        constant.validate();
        constant.register(this.fileRegistry);
        String name = constant.getName();
        if (this.constants.containsKey(name)) {
            throw new IllegalArgumentException("Ranking constant '" + name + "' defined twice");
        }
        this.constants.put(name, constant);
    }

    public RankingConstant get(String name) {
        return this.constants.get(name);
    }

    public Map<String, RankingConstant> asMap() {
        return Collections.unmodifiableMap(this.constants);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.constants.values().forEach(constant -> constant.sendTo(services));
    }
}

