/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.collections.Pair;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.io.IOUtils;
import com.yahoo.log.InvalidLogFormatException;
import com.yahoo.log.LogMessage;
import com.yahoo.path.Path;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankExpressionBody;
import com.yahoo.system.ProcessExecuter;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.ImportedFieldsConfig;
import com.yahoo.vespa.config.search.IndexschemaConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RankSetupValidator
extends Validator {
    private static final Logger log = Logger.getLogger(RankSetupValidator.class.getName());
    private static final String binaryName = "vespa-verify-ranksetup-bin ";
    private final boolean ignoreValidationErrors;

    public RankSetupValidator(boolean ignoreValidationErrors) {
        this.ignoreValidationErrors = ignoreValidationErrors;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        File cfgDir = null;
        try {
            cfgDir = Files.createTempDirectory("verify-ranksetup." + deployState.getProperties().applicationId().toFullString() + ".", new FileAttribute[0]).toFile();
            for (AbstractSearchCluster cluster : model.getSearchClusters()) {
                if (!cluster.isRealtime()) continue;
                IndexedSearchCluster sc = (IndexedSearchCluster)cluster;
                String clusterDir = cfgDir.getAbsolutePath() + "/" + sc.getClusterName() + "/";
                for (DocumentDatabase docDb : sc.getDocumentDbs()) {
                    String name = docDb.getDerivedConfiguration().getSearch().getName();
                    String searchDir = clusterDir + name + "/";
                    this.writeConfigs(searchDir, docDb);
                    this.writeExtraVerifyRanksetupConfig(searchDir, docDb);
                    if (this.validate("dir:" + searchDir, sc, name, deployState.getDeployLogger(), cfgDir)) continue;
                    if (cfgDir == null) return;
                    this.deleteTempDir(cfgDir);
                    return;
                }
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (cfgDir == null) throw throwable;
                this.deleteTempDir(cfgDir);
                throw throwable;
            }
        }
        if (cfgDir == null) return;
        this.deleteTempDir(cfgDir);
    }

    private boolean validate(String configId, SearchCluster searchCluster, String sdName, DeployLogger deployLogger, File tempDir) {
        Instant start = Instant.now();
        try {
            boolean ret = this.execValidate(configId, searchCluster, sdName, deployLogger);
            if (!ret) {
                this.deleteTempDir(tempDir);
            }
            log.log(Level.FINE, () -> String.format("Validating %s for %s, %s took %s ms", sdName, searchCluster, configId, Duration.between(start, Instant.now()).toMillis()));
            return ret;
        }
        catch (IllegalArgumentException e) {
            this.deleteTempDir(tempDir);
            throw e;
        }
    }

    private void deleteTempDir(File dir) {
        IOUtils.recursiveDeleteDir((File)dir);
    }

    private void writeConfigs(String dir, AbstractConfigProducer<?> producer) throws IOException {
        RankProfilesConfig.Builder rpcb = new RankProfilesConfig.Builder();
        ((RankProfilesConfig.Producer)producer).getConfig(rpcb);
        RankProfilesConfig rpc = new RankProfilesConfig(rpcb);
        RankSetupValidator.writeConfig(dir, RankProfilesConfig.getDefName() + ".cfg", (ConfigInstance)rpc);
        IndexschemaConfig.Builder iscb = new IndexschemaConfig.Builder();
        ((IndexschemaConfig.Producer)producer).getConfig(iscb);
        IndexschemaConfig isc = new IndexschemaConfig(iscb);
        RankSetupValidator.writeConfig(dir, IndexschemaConfig.getDefName() + ".cfg", (ConfigInstance)isc);
        AttributesConfig.Builder acb = new AttributesConfig.Builder();
        ((AttributesConfig.Producer)producer).getConfig(acb);
        AttributesConfig ac = new AttributesConfig(acb);
        RankSetupValidator.writeConfig(dir, AttributesConfig.getDefName() + ".cfg", (ConfigInstance)ac);
        RankingConstantsConfig.Builder rccb = new RankingConstantsConfig.Builder();
        ((RankingConstantsConfig.Producer)producer).getConfig(rccb);
        RankingConstantsConfig rcc = new RankingConstantsConfig(rccb);
        RankSetupValidator.writeConfig(dir, RankingConstantsConfig.getDefName() + ".cfg", (ConfigInstance)rcc);
        RankingExpressionsConfig.Builder recb = new RankingExpressionsConfig.Builder();
        ((RankingExpressionsConfig.Producer)producer).getConfig(recb);
        RankingExpressionsConfig rec = new RankingExpressionsConfig(recb);
        RankSetupValidator.writeConfig(dir, RankingExpressionsConfig.getDefName() + ".cfg", (ConfigInstance)rec);
        OnnxModelsConfig.Builder omcb = new OnnxModelsConfig.Builder();
        ((OnnxModelsConfig.Producer)producer).getConfig(omcb);
        OnnxModelsConfig omc = new OnnxModelsConfig(omcb);
        RankSetupValidator.writeConfig(dir, OnnxModelsConfig.getDefName() + ".cfg", (ConfigInstance)omc);
        ImportedFieldsConfig.Builder ifcb = new ImportedFieldsConfig.Builder();
        ((ImportedFieldsConfig.Producer)producer).getConfig(ifcb);
        ImportedFieldsConfig ifc = new ImportedFieldsConfig(ifcb);
        RankSetupValidator.writeConfig(dir, ImportedFieldsConfig.getDefName() + ".cfg", (ConfigInstance)ifc);
    }

    private void writeExtraVerifyRanksetupConfig(String dir, DocumentDatabase db) throws IOException {
        String modelPath;
        String configName = "verify-ranksetup.cfg";
        String configContent = "";
        ArrayList<String> config = new ArrayList<String>();
        for (OnnxModel model : db.getDerivedConfiguration().getSearch().onnxModels().asMap().values()) {
            modelPath = RankSetupValidator.getFileRepositoryPath(model.getFilePath(), model.getFileReference());
            config.add(String.format("file[%d].ref \"%s\"", config.size() / 2, model.getFileReference()));
            config.add(String.format("file[%d].path \"%s\"", config.size() / 2, modelPath));
        }
        for (RankExpressionBody expr : db.getDerivedConfiguration().getSearch().rankExpressionFiles().asMap().values()) {
            modelPath = RankSetupValidator.getFileRepositoryPath(expr.getFilePath(), expr.getFileReference());
            config.add(String.format("file[%d].ref \"%s\"", config.size() / 2, expr.getFileReference()));
            config.add(String.format("file[%d].path \"%s\"", config.size() / 2, modelPath));
        }
        if (!config.isEmpty()) {
            configContent = StringUtilities.implodeMultiline(config);
        }
        IOUtils.writeFile((String)(dir + configName), (String)configContent, (boolean)false);
    }

    public static String getFileRepositoryPath(Path path, String fileReference) {
        ConfigserverConfig cfg = new ConfigserverConfig(new ConfigserverConfig.Builder());
        String fileRefDir = Defaults.getDefaults().underVespaHome(cfg.fileReferencesDir());
        return Paths.get(fileRefDir, fileReference, path.getName()).toString();
    }

    private static void writeConfig(String dir, String configName, ConfigInstance config) throws IOException {
        IOUtils.writeFile((String)(dir + configName), (String)StringUtilities.implodeMultiline((List)ConfigInstance.serialize((InnerNode)config)), (boolean)false);
    }

    private boolean execValidate(String configId, SearchCluster sc, String sdName, DeployLogger deployLogger) {
        String job = String.format("%s %s", binaryName, configId);
        ProcessExecuter executer = new ProcessExecuter(true);
        try {
            Pair ret = executer.exec(job);
            if ((Integer)ret.getFirst() != 0) {
                this.validateFail((String)ret.getSecond(), sc, sdName, deployLogger);
            }
        }
        catch (IOException e) {
            this.validateWarn(e, deployLogger);
            return false;
        }
        return true;
    }

    private void validateWarn(Exception e, DeployLogger deployLogger) {
        String msg = "Unable to execute 'vespa-verify-ranksetup-bin ', validation of rank expressions will only take place when you start Vespa: " + Exceptions.toMessageString((Throwable)e);
        deployLogger.logApplicationPackage(Level.WARNING, msg);
    }

    private void validateFail(String output, SearchCluster sc, String sdName, DeployLogger deployLogger) {
        StringBuilder errMsg = new StringBuilder("For search cluster '").append(sc.getClusterName()).append("', ").append("search definition '").append(sdName).append("': error in rank setup. Details:\n");
        for (String line : output.split("\n")) {
            if (line.startsWith("debug\t")) continue;
            try {
                LogMessage logMessage = LogMessage.parseNativeFormat((String)line);
                errMsg.append(logMessage.getLevel()).append(": ").append(logMessage.getPayload()).append("\n");
            }
            catch (InvalidLogFormatException e) {
                errMsg.append(line).append("\n");
            }
        }
        if (!this.ignoreValidationErrors) {
            throw new IllegalArgumentException(errMsg.toString());
        }
        deployLogger.log(Level.WARNING, errMsg.append("(Continuing since ignoreValidationErrors flag is set.)").toString());
    }
}

