/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.path.Path;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipException;

public class ComponentValidator
extends Validator {
    private JarFile jarFile;

    public ComponentValidator() {
    }

    public ComponentValidator(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public void validate(VespaModel model, DeployState deployState) {
        ApplicationPackage app = deployState.getApplicationPackage();
        for (ComponentInfo info : app.getComponentsInfo(deployState.getVespaVersion())) {
            try {
                this.jarFile = new JarFile(app.getFileReference(Path.fromString((String)info.getPathRelativeToAppDir())));
            }
            catch (ZipException e) {
                throw new IllegalArgumentException("Error opening jar file '" + info.getPathRelativeToAppDir() + "'. Please check that this is a valid jar file");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.validateAll(deployState.getDeployLogger());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void validateAll(DeployLogger deployLogger) throws IOException {
        this.validateOSGIHeaders(deployLogger);
    }

    public void validateOSGIHeaders(DeployLogger deployLogger) throws IOException {
        Manifest mf = this.jarFile.getManifest();
        if (mf == null) {
            throw new IllegalArgumentException("Non-existing or invalid manifest in " + this.jarFile.getName());
        }
        Attributes attributes = mf.getMainAttributes();
        HashSet<String> mfAttributes = new HashSet<String>();
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> attributeSet;
            Map.Entry<Object, Object> e = attributeSet = iterator.next();
            mfAttributes.add(e.getKey().toString());
        }
        List<String> requiredOSGIHeaders = Arrays.asList("Bundle-ManifestVersion", "Bundle-Name", "Bundle-SymbolicName", "Bundle-Version");
        for (String header : requiredOSGIHeaders) {
            if (mfAttributes.contains(header)) continue;
            throw new IllegalArgumentException("Required OSGI header '" + header + "' was not found in manifest in '" + this.jarFile.getName() + "'");
        }
        if (attributes.getValue("Bundle-Version").endsWith(".SNAPSHOT")) {
            deployLogger.logApplicationPackage(Level.WARNING, "Deploying snapshot bundle " + this.jarFile.getName() + ".\nTo use this bundle, you must include the qualifier 'SNAPSHOT' in  the version specification in services.xml.");
        }
    }
}

