/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.Lowercase;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.Affinity;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractService
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements Service {
    private static final long serialVersionUID = 1L;
    private HostResource hostResource = null;
    private int id = 0;
    private int basePort = 0;
    private List<Integer> ports = new ArrayList<Integer>();
    private String jvmOptions = "";
    private String preload = null;
    private long mmapNoCoreLimit = -1L;
    private boolean coreOnOOM = false;
    private int ompNumThreads = 0;
    private String noVespaMalloc = "";
    private String vespaMalloc = "";
    private String vespaMallocDebug = "";
    private String vespaMallocDebugStackTrace = "";
    protected PortsMeta portsMeta = new PortsMeta();
    private final Map<String, Object> serviceProperties = new LinkedHashMap<String, Object>();
    private Optional<Affinity> affinity = Optional.empty();
    private boolean initialized = false;

    protected String defaultPreload() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamalloc.so");
    }

    public AbstractService(AbstractConfigProducer<?> parent, String name) {
        super(parent, name);
    }

    public AbstractService(String name) {
        super(name);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.hostResource != null) {
            this.hostResource.deallocateService(this);
        }
    }

    public static <SERVICE extends AbstractService> void distributeCpuSocketAffinity(Collection<SERVICE> services) {
        HashMap affinityMap = new HashMap();
        for (AbstractService service : services) {
            if (!affinityMap.containsKey(service.getHostResource())) {
                affinityMap.put(service.getHostResource(), new ArrayList());
            }
            int cpuSocket = ((List)affinityMap.get(service.getHostResource())).size();
            ((List)affinityMap.get(service.getHostResource())).add(service);
            service.setAffinity(new Affinity.Builder().cpuSocket(cpuSocket).build());
        }
    }

    private void initService(DeployLogger deployLogger, HostResource hostResource, int userPort) {
        if (this.initialized) {
            throw new IllegalStateException("Service '" + this.getConfigId() + "' already initialized.");
        }
        if (hostResource == null) {
            throw new RuntimeException("No host found for service '" + this.getServiceName() + "'. The hostalias is probably missing from hosts.xml.");
        }
        this.id = this.getIndex(hostResource);
        this.ports = hostResource.allocateService(deployLogger, this, this.getInstanceWantedPort(userPort));
        this.initialized = true;
    }

    public void initService(DeployLogger deployLogger) {
        this.initService(deployLogger, this.hostResource, this.basePort);
    }

    @Override
    public int getWantedPort() {
        return 0;
    }

    private int getInstanceWantedPort(int userWantedPort) {
        int wantedPort = 0;
        if (userWantedPort == 0) {
            if (this.requiresWantedPort()) {
                wantedPort = this.getWantedPort();
            } else if (this.getWantedPort() > 0) {
                wantedPort = this.getWantedPort() + (this.getId() - 1) * this.getPortCount();
            }
        } else {
            wantedPort = userWantedPort;
        }
        return wantedPort;
    }

    @Override
    public boolean requiresWantedPort() {
        return false;
    }

    @Override
    public PortsMeta getPortsMeta() {
        return this.portsMeta;
    }

    @Override
    public int getRelativePort(int i) {
        if (this.ports.size() < 1) {
            throw new IllegalStateException("Requested port with offset " + i + " for service that has not reserved any ports: " + this);
        }
        if (i >= this.ports.size()) {
            throw new IllegalStateException("Requested port with offset " + i + " for service that only has reserved " + this.ports.size() + " ports: " + this);
        }
        return this.ports.get(i);
    }

    @Override
    public String getStartupCommand() {
        return null;
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        return Optional.empty();
    }

    @Override
    public String getServiceName() {
        return this.getServiceType() + (this.id == 1 ? "" : Integer.toString(this.id));
    }

    @Override
    public String getServiceType() {
        return Lowercase.toLowerCase((String)this.getShortClassName());
    }

    private String getShortClassName() {
        Class<?> myClass = this.getClass();
        Package myPackage = myClass.getPackage();
        return myClass.getName().substring(1 + myPackage.getName().length());
    }

    @Override
    public HostResource getHost() {
        return this.hostResource;
    }

    @Override
    public String getHostName() {
        return this.hostResource.getHostname();
    }

    public int getId() {
        return this.id;
    }

    protected int getIndex(HostResource host) {
        int i = 0;
        for (Service s : host.getServices()) {
            if (!s.getServiceType().equals(this.getServiceType()) || s == this) continue;
            ++i;
        }
        return i + 1;
    }

    @Override
    public ServiceInfo getServiceInfo() {
        LinkedHashSet<PortInfo> portInfos = new LinkedHashSet<PortInfo>();
        for (int i = 0; i < this.portsMeta.getNumPorts(); ++i) {
            portInfos.add(new PortInfo(this.ports.get(i).intValue(), new LinkedHashSet<String>(this.portsMeta.getTagsAt(i))));
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> prop : this.serviceProperties.entrySet()) {
            properties.put(prop.getKey(), prop.getValue().toString());
        }
        return new ServiceInfo(this.getServiceName(), this.getServiceType(), portInfos, properties, this.getConfigId(), this.getHostName());
    }

    public AbstractService setProp(String key, String value) {
        this.serviceProperties.put(key, value);
        return this;
    }

    public AbstractService setProp(String key, Integer value) {
        this.serviceProperties.put(key, value);
        return this;
    }

    public String getServicePropertyString(String key) {
        return this.getServicePropertyString(key, null);
    }

    @Override
    public String getServicePropertyString(String key, String defStr) {
        Object result = this.serviceProperties.get(key);
        return result == null ? defStr : result.toString();
    }

    @Override
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public final void setJvmOptions(String args) {
        this.jvmOptions = args == null ? "" : args;
    }

    public final void appendJvmOptions(String args) {
        if (args != null && !"".equals(args)) {
            this.setJvmOptions(this.jvmOptions + AbstractService.getSeparator(this.jvmOptions) + args);
        }
    }

    private static String getSeparator(String current) {
        return "".equals(current) ? "" : " ";
    }

    public final void prependJvmOptions(String args) {
        if (args != null && !"".equals(args)) {
            this.setJvmOptions(args + AbstractService.getSeparator(this.jvmOptions) + this.jvmOptions);
        }
    }

    public String getPreLoad() {
        return this.preload != null ? this.preload : this.defaultPreload();
    }

    public void setPreLoad(String preload) {
        this.preload = preload;
    }

    public long getMMapNoCoreLimit() {
        return this.mmapNoCoreLimit;
    }

    public void setMMapNoCoreLimit(long noCoreLimit) {
        this.mmapNoCoreLimit = noCoreLimit;
    }

    public boolean getCoreOnOOM() {
        return this.coreOnOOM;
    }

    public void setCoreOnOOM(boolean coreOnOOM) {
        this.coreOnOOM = coreOnOOM;
    }

    public int getOmpNumThreads() {
        return this.ompNumThreads;
    }

    public void setOmpNumThreads(int value) {
        this.ompNumThreads = value;
    }

    public String getNoVespaMalloc() {
        return this.noVespaMalloc;
    }

    public String getVespaMalloc() {
        return this.vespaMalloc;
    }

    public String getVespaMallocDebug() {
        return this.vespaMallocDebug;
    }

    public String getVespaMallocDebugStackTrace() {
        return this.vespaMallocDebugStackTrace;
    }

    public void setNoVespaMalloc(String s) {
        this.noVespaMalloc = s;
    }

    public void setVespaMalloc(String s) {
        this.vespaMalloc = s;
    }

    public void setVespaMallocDebug(String s) {
        this.vespaMallocDebug = s;
    }

    public void setVespaMallocDebugStackTrace(String s) {
        this.vespaMallocDebugStackTrace = s;
    }

    public String getMMapNoCoreEnvVariable() {
        return this.getMMapNoCoreLimit() >= 0L ? "VESPA_MMAP_NOCORE_LIMIT=" + this.getMMapNoCoreLimit() + " " : "";
    }

    public String getCoreOnOOMEnvVariable() {
        return this.getCoreOnOOM() ? "" : "VESPA_SILENCE_CORE_ON_OOM=true ";
    }

    public String getOmpNumThreadsEnvVariable() {
        return this.getOmpNumThreads() == 0 ? "" : "OMP_NUM_THREADS=" + this.getOmpNumThreads() + " ";
    }

    public String getNoVespaMallocEnvVariable() {
        return "".equals(this.getNoVespaMalloc()) ? "" : "VESPA_USE_NO_VESPAMALLOC=\"" + this.getNoVespaMalloc() + "\" ";
    }

    public String getVespaMallocEnvVariable() {
        return "".equals(this.getVespaMalloc()) ? "" : "VESPA_USE_VESPAMALLOC=\"" + this.getVespaMalloc() + "\" ";
    }

    public String getVespaMallocDebugEnvVariable() {
        return "".equals(this.getVespaMallocDebug()) ? "" : "VESPA_USE_VESPAMALLOC_D=\"" + this.getVespaMallocDebug() + "\" ";
    }

    public String getVespaMallocDebugStackTraceEnvVariable() {
        return "".equals(this.getVespaMallocDebugStackTrace()) ? "" : "VESPA_USE_VESPAMALLOC_DST=\"" + this.getVespaMallocDebugStackTrace() + "\" ";
    }

    public String getEnvVariables() {
        return this.getCoreOnOOMEnvVariable() + this.getOmpNumThreadsEnvVariable() + this.getMMapNoCoreEnvVariable() + this.getNoVespaMallocEnvVariable() + this.getVespaMallocEnvVariable() + this.getVespaMallocDebugEnvVariable() + this.getVespaMallocDebugStackTraceEnvVariable();
    }

    public void setBasePort(int wantedPort) {
        this.basePort = wantedPort;
    }

    public void setHostResource(HostResource hostResource) {
        this.hostResource = hostResource;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public FileReference sendFile(String relativePath) {
        Host host = null;
        if (this.getHost() != null) {
            host = this.getHost().getHost();
        }
        return this.getRoot().getFileDistributor().sendFileToHost(relativePath, host);
    }

    public FileReference sendUri(String uri) {
        return this.getRoot().getFileDistributor().sendUriToHost(uri, this.getHost().getHost());
    }

    public FileReference sendBlob(ByteBuffer blob) {
        return this.getRoot().getFileDistributor().sendBlobToHost(blob, this.getHost().getHost());
    }

    @Override
    public int getHealthPort() {
        return -1;
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        return new LinkedHashMap<String, String>();
    }

    public int getNumPortsAllocated() {
        return this.ports.size();
    }

    public HostResource getHostResource() {
        return this.hostResource;
    }

    @Override
    public Optional<Affinity> getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = Optional.ofNullable(affinity);
    }

    public String toString() {
        return this.getServiceName() + " on " + (this.getHost() == null ? "no host" : this.getHost().toString());
    }
}

