/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing.multifieldresolver;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.multifieldresolver.MultiFieldResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class IndexCommandResolver
extends MultiFieldResolver {
    private static List<String> ignoredCommands = new ArrayList<String>();
    private static List<String> harmonizedCommands = new ArrayList<String>();

    public IndexCommandResolver(String indexName, List<SDField> fields, Search search, DeployLogger logger) {
        super(indexName, fields, search, logger);
    }

    @Override
    public void resolve() {
        for (SDField field : this.fields) {
            for (String command : field.getQueryCommands()) {
                if (ignoredCommands.contains(command)) continue;
                this.checkCommand(command);
            }
        }
    }

    private void checkCommand(String command) {
        for (SDField field : this.fields) {
            if (field.hasQueryCommand(command)) continue;
            if (harmonizedCommands.contains(command)) {
                this.deployLogger.logApplicationPackage(Level.WARNING, command + " must be added to all fields going to the same index (" + this.indexName + "), adding to field " + field.getName());
                field.addQueryCommand(command);
                continue;
            }
            this.deployLogger.logApplicationPackage(Level.WARNING, "All fields going to the same index should have the same query-commands. Field '" + field.getName() + "' doesn't contain command '" + command + "'");
        }
    }

    static {
        String[] ignore = new String[]{"complete-boost", "literal-boost", "highlight"};
        ignoredCommands.addAll(Arrays.asList(ignore));
        String[] harmonize = new String[]{"stemming", "normalizing"};
        harmonizedCommands.addAll(Arrays.asList(harmonize));
    }
}

