/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.ConnectionLogConfig;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.OptionalInt;

public class ConnectionLogComponent
extends SimpleComponent
implements ConnectionLogConfig.Producer {
    private final String logDirectoryName;
    private final String clusterName;
    private final int queueSize;

    public ConnectionLogComponent(ContainerCluster<?> cluster, Class<? extends ConnectionLog> cls, String logDirectoryName) {
        this(cluster, cls, logDirectoryName, cluster.getName());
    }

    public ConnectionLogComponent(ContainerCluster<?> cluster, Class<? extends ConnectionLog> cls, String logDirectoryName, String clusterName) {
        super(cls.getName());
        this.logDirectoryName = logDirectoryName;
        this.clusterName = clusterName;
        this.queueSize = ConnectionLogComponent.queueSize(cluster).orElse(-1);
    }

    private static OptionalInt queueSize(ContainerCluster<?> cluster) {
        if (cluster == null) {
            return OptionalInt.empty();
        }
        double vcpu = cluster.vcpu().orElse(0.0);
        if (vcpu <= 0.0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((int)Math.max(4096.0, Math.ceil(vcpu * 512.0)));
    }

    public void getConfig(ConnectionLogConfig.Builder builder) {
        builder.cluster(this.clusterName);
        builder.logDirectoryName(this.logDirectoryName);
        if (this.queueSize >= 0) {
            builder.queueSize(this.queueSize);
        }
    }
}

