/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.searchdefinition.DocumentGraphValidator;
import com.yahoo.searchdefinition.DocumentModelBuilder;
import com.yahoo.searchdefinition.DocumentReferenceResolver;
import com.yahoo.searchdefinition.FieldOperationApplier;
import com.yahoo.searchdefinition.FieldOperationApplierForSearch;
import com.yahoo.searchdefinition.FieldOperationApplierForStructs;
import com.yahoo.searchdefinition.ImportedFieldsEnumerator;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SDDocumentTypeOrderer;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.SearchOrderer;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.SDParser;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.TokenMgrException;
import com.yahoo.searchdefinition.processing.Processing;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SearchBuilder {
    private final DocumentTypeManager docTypeMgr = new DocumentTypeManager();
    private final DocumentModel model = new DocumentModel();
    private final ApplicationPackage app;
    private final RankProfileRegistry rankProfileRegistry;
    private final QueryProfileRegistry queryProfileRegistry;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;
    private final boolean documentsOnly;
    private List<Search> searchList = new LinkedList<Search>();
    private boolean isBuilt = false;

    public SearchBuilder() {
        this(new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public SearchBuilder(DeployLogger deployLogger) {
        this(MockApplicationPackage.createEmpty(), deployLogger);
    }

    public SearchBuilder(DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(MockApplicationPackage.createEmpty(), deployLogger, rankProfileRegistry);
    }

    public SearchBuilder(boolean documentsOnly) {
        this(MockApplicationPackage.createEmpty(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry(), documentsOnly);
    }

    public SearchBuilder(ApplicationPackage app, DeployLogger deployLogger) {
        this(app, deployLogger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public SearchBuilder(ApplicationPackage app, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(app, deployLogger, new TestProperties(), rankProfileRegistry, new QueryProfileRegistry());
    }

    public SearchBuilder(RankProfileRegistry rankProfileRegistry) {
        this(rankProfileRegistry, new QueryProfileRegistry());
    }

    public SearchBuilder(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(MockApplicationPackage.createEmpty(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), rankProfileRegistry, queryProfileRegistry);
    }

    public SearchBuilder(ApplicationPackage app, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(app, deployLogger, properties, rankProfileRegistry, queryProfileRegistry, false);
    }

    private SearchBuilder(ApplicationPackage app, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry, boolean documentsOnly) {
        this.app = app;
        this.rankProfileRegistry = rankProfileRegistry;
        this.queryProfileRegistry = queryProfileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.documentsOnly = documentsOnly;
    }

    public String importFile(String fileName) throws IOException, ParseException {
        File file = new File(fileName);
        return this.importString(IOUtils.readFile((File)file), file.getAbsoluteFile().getParent());
    }

    private String importFile(Path file) throws IOException, ParseException {
        return this.importFile(file.toString());
    }

    public String importReader(NamedReader reader, String searchDefDir) throws IOException, ParseException {
        return this.importString(IOUtils.readAll((Reader)reader), searchDefDir);
    }

    public String importString(String str) throws ParseException {
        return this.importString(str, null);
    }

    private String importString(String str, String searchDefDir) throws ParseException {
        SimpleCharStream stream = new SimpleCharStream(str);
        try {
            return this.importRawSearch(new SDParser(stream, this.deployLogger, this.properties, this.app, this.rankProfileRegistry, this.documentsOnly).search(this.docTypeMgr, searchDefDir));
        }
        catch (TokenMgrException e) {
            throw new ParseException("Unknown symbol: " + e.getMessage());
        }
        catch (ParseException pe) {
            throw new ParseException(stream.formatException(Exceptions.toMessageString((Throwable)pe)));
        }
    }

    public String importRawSearch(Search rawSearch) {
        if (rawSearch.getName() == null) {
            throw new IllegalArgumentException("Search has no name.");
        }
        String rawName = rawSearch.getName();
        for (Search search : this.searchList) {
            if (!rawName.equals(search.getName())) continue;
            throw new IllegalArgumentException("A search definition with a search section called '" + rawName + "' has already been added.");
        }
        this.searchList.add(rawSearch);
        return rawName;
    }

    public void build() {
        this.build(true);
    }

    public void build(boolean validate) {
        if (this.isBuilt) {
            throw new IllegalStateException("Model already built");
        }
        ArrayList<Search> built = new ArrayList<Search>();
        ArrayList<SDDocumentType> sdocs = new ArrayList<SDDocumentType>();
        sdocs.add(SDDocumentType.VESPA_DOCUMENT);
        for (Search search : this.searchList) {
            if (!search.hasDocument()) continue;
            sdocs.add(search.getDocument());
        }
        SDDocumentTypeOrderer orderer = new SDDocumentTypeOrderer(sdocs, this.deployLogger);
        orderer.process();
        for (SDDocumentType sdoc : orderer.getOrdered()) {
            new FieldOperationApplierForStructs().process(sdoc);
            new FieldOperationApplier().process(sdoc);
        }
        DocumentReferenceResolver documentReferenceResolver = new DocumentReferenceResolver(this.searchList);
        sdocs.forEach(documentReferenceResolver::resolveReferences);
        sdocs.forEach(documentReferenceResolver::resolveInheritedReferences);
        ImportedFieldsEnumerator importedFieldsEnumerator = new ImportedFieldsEnumerator(this.searchList);
        sdocs.forEach(importedFieldsEnumerator::enumerateImportedFields);
        if (validate) {
            new DocumentGraphValidator().validateDocumentGraph(sdocs);
        }
        DocumentModelBuilder builder = new DocumentModelBuilder(this.model);
        for (Search search : new SearchOrderer().order(this.searchList)) {
            new FieldOperationApplierForSearch().process(search);
            this.process(search, new QueryProfiles(this.queryProfileRegistry, this.deployLogger), validate);
            built.add(search);
        }
        builder.addToModel(this.searchList);
        if (validate && !builder.valid()) {
            throw new IllegalArgumentException("Impossible to build a correct model.");
        }
        this.searchList = built;
        this.isBuilt = true;
    }

    private void process(Search search, QueryProfiles queryProfiles, boolean validate) {
        new Processing().process(search, this.deployLogger, this.rankProfileRegistry, queryProfiles, validate, this.documentsOnly);
    }

    public Search getSearch() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Searches not built.");
        }
        if (this.searchList.size() != 1) {
            throw new IllegalStateException("This call only works if we have 1 search definition. Search definitions: " + this.searchList);
        }
        return this.searchList.get(0);
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public Search getSearch(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("Searches not built.");
        }
        if (name == null) {
            return this.getSearch();
        }
        for (Search search : this.searchList) {
            if (!search.getName().equals(name)) continue;
            return search;
        }
        return null;
    }

    public List<Search> getSearchList() {
        return new ArrayList<Search>(this.searchList);
    }

    public static SearchBuilder createFromString(String sd) throws ParseException {
        return SearchBuilder.createFromString(sd, (DeployLogger)new BaseDeployLogger());
    }

    public static SearchBuilder createFromString(String sd, DeployLogger logger) throws ParseException {
        SearchBuilder builder = new SearchBuilder(logger);
        builder.importString(sd);
        builder.build(true);
        return builder;
    }

    public static SearchBuilder createFromFile(String fileName) throws IOException, ParseException {
        return SearchBuilder.createFromFile(fileName, (DeployLogger)new BaseDeployLogger());
    }

    public static SearchBuilder createFromFiles(Collection<String> fileNames) throws IOException, ParseException {
        return SearchBuilder.createFromFiles(fileNames, (DeployLogger)new BaseDeployLogger());
    }

    public static SearchBuilder createFromFile(String fileName, DeployLogger logger) throws IOException, ParseException {
        return SearchBuilder.createFromFile(fileName, logger, new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static SearchBuilder createFromFiles(Collection<String> fileNames, DeployLogger logger) throws IOException, ParseException {
        return SearchBuilder.createFromFiles(fileNames, logger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static SearchBuilder createFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        return SearchBuilder.createFromFiles(Collections.singletonList(fileName), deployLogger, new TestProperties(), rankProfileRegistry, queryprofileRegistry);
    }

    private static SearchBuilder createFromFiles(Collection<String> fileNames, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        SearchBuilder builder = new SearchBuilder(MockApplicationPackage.createEmpty(), deployLogger, properties, rankProfileRegistry, queryprofileRegistry);
        for (String fileName : fileNames) {
            builder.importFile(fileName);
        }
        builder.build(true);
        return builder;
    }

    public static SearchBuilder createFromDirectory(String dir, DeployLogger logger, ModelContext.Properties properties) throws IOException, ParseException {
        return SearchBuilder.createFromDirectory(dir, logger, properties, new RankProfileRegistry());
    }

    public static SearchBuilder createFromDirectory(String dir, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry) throws IOException, ParseException {
        return SearchBuilder.createFromDirectory(dir, logger, properties, rankProfileRegistry, SearchBuilder.createQueryProfileRegistryFromDirectory(dir));
    }

    private static SearchBuilder createFromDirectory(String dir, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SearchBuilder.createFromDirectory(dir, MockApplicationPackage.fromSearchDefinitionDirectory(dir), logger, properties, rankProfileRegistry, queryProfileRegistry);
    }

    private static SearchBuilder createFromDirectory(String dir, ApplicationPackage applicationPackage, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        SearchBuilder builder = new SearchBuilder(applicationPackage, deployLogger, properties, rankProfileRegistry, queryProfileRegistry);
        Iterator i = Files.list(new File(dir).toPath()).filter(p -> p.getFileName().toString().endsWith(".sd")).iterator();
        while (i.hasNext()) {
            builder.importFile((Path)i.next());
        }
        builder.build(true);
        return builder;
    }

    private static QueryProfileRegistry createQueryProfileRegistryFromDirectory(String dir) {
        File queryProfilesDir = new File(dir, "query-profiles");
        if (!queryProfilesDir.exists()) {
            return new QueryProfileRegistry();
        }
        return new QueryProfileXMLReader().read(queryProfilesDir.toString());
    }

    public static Search buildFromFile(String fileName) throws IOException, ParseException {
        return SearchBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public static Search buildFromFile(String fileName, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SearchBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), rankProfileRegistry, queryProfileRegistry);
    }

    public static Search buildFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SearchBuilder.createFromFile(fileName, deployLogger, rankProfileRegistry, queryProfileRegistry).getSearch();
    }

    public static SearchBuilder createFromRawSearch(Search rawSearch, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        SearchBuilder builder = new SearchBuilder(rankProfileRegistry, queryProfileRegistry);
        builder.importRawSearch(rawSearch);
        builder.build();
        return builder;
    }

    public static Search buildFromRawSearch(Search rawSearch, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        return SearchBuilder.createFromRawSearch(rawSearch, rankProfileRegistry, queryProfileRegistry).getSearch();
    }

    public RankProfileRegistry getRankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public QueryProfileRegistry getQueryProfileRegistry() {
        return this.queryProfileRegistry;
    }
}

