/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.path.Path;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.utils.FileSender;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;

public class DistributableResource {
    private final String name;
    private final ByteBuffer blob;
    private String path;
    private String fileReference = "";
    private PathType pathType = PathType.FILE;

    public PathType getPathType() {
        return this.pathType;
    }

    public DistributableResource(String name) {
        this.name = name;
        this.blob = null;
    }

    public DistributableResource(String name, String path) {
        this.name = name;
        this.path = path;
        this.blob = null;
    }

    public DistributableResource(String name, ByteBuffer blob) {
        Objects.requireNonNull(name, "Blob name cannot be null");
        Objects.requireNonNull(blob, "Blob cannot be null");
        this.name = name;
        this.blob = blob;
        this.pathType = PathType.BLOB;
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri, "uri cannot be null");
        this.path = uri;
        this.pathType = PathType.URI;
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.fileReference = this.sendToServices(services).value();
    }

    private FileReference sendToServices(Collection<? extends AbstractService> services) {
        switch (this.pathType) {
            case FILE: {
                return FileSender.sendFileToServices(this.path, services);
            }
            case URI: {
                return FileSender.sendUriToServices(this.path, services);
            }
            case BLOB: {
                return FileSender.sendBlobToServices(this.blob, services);
            }
        }
        throw new IllegalArgumentException("Unknown path type " + this.pathType);
    }

    public String getName() {
        return this.name;
    }

    public ByteBuffer getBlob() {
        return this.blob;
    }

    public String getFileName() {
        return this.path;
    }

    public Path getFilePath() {
        return Path.fromString((String)this.path);
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void validate() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("Distributable resource must have a file or uri.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("resource '").append(this.name).append(" of type '").append((Object)this.pathType).append("' with ref '").append(this.fileReference).append("'");
        return b.toString();
    }

    public static enum PathType {
        FILE,
        URI,
        BLOB;

    }
}

