/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component.chain;

import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ConfigProducerGroup;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.component.chain.ChainedComponentConfigGenerator;
import com.yahoo.vespa.model.container.component.chain.ChainsConfigGenerator;
import java.util.LinkedHashSet;
import java.util.Set;

public class Chains<CHAIN extends Chain<?>>
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ChainsConfig.Producer {
    private final ComponentGroup<ChainedComponent<?>> componentGroup = new ComponentGroup(this, "component");
    private final ConfigProducerGroup<CHAIN> chainGroup = new ConfigProducerGroup(this, "chain");

    public Chains(AbstractConfigProducer parent, String subId) {
        super(parent, subId);
    }

    public void initializeComponents() {
        for (ChainedComponent<?> component : this.allComponents()) {
            component.initialize();
        }
    }

    @Override
    public void validate() throws Exception {
        ChainsModel chainsModel = new ChainsModel();
        for (Chain chain : this.allChains().allComponents()) {
            chainsModel.register(chain.getChainSpecification());
        }
        for (ChainedComponent chainedComponent : this.allComponents()) {
            chainsModel.register(chainedComponent.getGlobalComponentId(), (ChainedComponentModel)chainedComponent.model);
        }
        chainsModel.validate();
        super.validate();
    }

    public Set<ChainedComponent<?>> allComponents() {
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(this.componentGroup.getComponents());
        for (Chain chain : this.allChains().allComponents()) {
            result.addAll(chain.getInnerComponents());
        }
        return result;
    }

    public ComponentRegistry<ChainedComponent<?>> componentsRegistry() {
        ComponentRegistry result = new ComponentRegistry();
        for (ChainedComponent component : this.componentGroup.getComponents()) {
            result.register(component.getGlobalComponentId(), (Object)component);
        }
        for (Chain chain : this.allChains().allComponents()) {
            for (ChainedComponent component : chain.getInnerComponents()) {
                result.register(component.getGlobalComponentId(), (Object)component);
            }
        }
        return result;
    }

    public ComponentRegistry<CHAIN> allChains() {
        ComponentRegistry allChains = new ComponentRegistry();
        for (Chain chain : this.chainGroup.getComponents()) {
            allChains.register(chain.getId(), (Object)chain);
        }
        allChains.freeze();
        return allChains;
    }

    public void add(CHAIN chain) {
        this.chainGroup.addComponent(((Chain)chain).getId(), chain);
    }

    public void add(ChainedComponent outerComponent) {
        this.componentGroup.addComponent(outerComponent);
    }

    public void getConfig(ChainsConfig.Builder builder) {
        ChainsConfigGenerator.generate(builder, this.allChains().allComponents());
        ChainedComponentConfigGenerator.generate(builder, this.allComponents());
    }

    public ConfigProducerGroup<ChainedComponent<?>> getComponentGroup() {
        return this.componentGroup;
    }

    protected ConfigProducerGroup<CHAIN> getChainGroup() {
        return this.chainGroup;
    }
}

