/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.vespa.config.content.LoadTypeConfig;

public class Clients
extends ConfigModel {
    private static final long serialVersionUID = 1L;
    private LoadTypeSet loadTypes = new LoadTypeSet();

    public Clients(ConfigModelContext modelContext) {
        super(modelContext);
    }

    public LoadTypeSet getLoadTypes() {
        return this.loadTypes;
    }

    public void getConfig(LoadTypeConfig.Builder builder) {
        for (LoadType t : this.loadTypes.getNameMap().values()) {
            if (t == LoadType.DEFAULT) continue;
            builder.type(this.getLoadTypeConfig(t));
        }
    }

    private LoadTypeConfig.Type.Builder getLoadTypeConfig(LoadType loadType) {
        LoadTypeConfig.Type.Builder builder = new LoadTypeConfig.Type.Builder();
        builder.name(loadType.getName());
        builder.id(loadType.getId());
        builder.priority(loadType.getPriority().toString());
        return builder;
    }
}

