/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankExpressionFile;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class RankExpressionFiles {
    private final Map<String, RankExpressionFile> expressions = new HashMap<String, RankExpressionFile>();

    public void add(RankExpressionFile expression, DeployLogger deployLogger) {
        expression.validate();
        String name = expression.getName();
        if (this.expressions.containsKey(name)) {
            if (this.expressions.get(name).getFileName().equals(expression.getFileName())) {
                deployLogger.logApplicationPackage(Level.WARNING, "Rank expression file '" + name + "' defined twice with identical expression (illegal and will be enforced soon) '" + expression.getFileName() + "'.");
            } else {
                throw new IllegalArgumentException("Rank expression file '" + name + "' defined twice (illegal but not enforced), but redefinition is not matching (illegal and enforced), previous = '" + this.expressions.get(name).getFileName() + "', new = '" + expression.getFileName() + "'.");
            }
        }
        this.expressions.put(name, expression);
    }

    public RankExpressionFile get(String name) {
        return this.expressions.get(name);
    }

    public Map<String, RankExpressionFile> asMap() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.expressions.values().forEach(constant -> constant.sendTo(services));
    }
}

