/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.path.Path;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.Collection;
import java.util.Objects;

public class DistributableResource {
    private final String name;
    private String path = null;
    private String fileReference = "";
    private PathType pathType = PathType.FILE;

    public PathType getPathType() {
        return this.pathType;
    }

    public DistributableResource(String name) {
        this(name, null);
    }

    public DistributableResource(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri, "uri cannot be null");
        this.path = uri;
        this.pathType = PathType.URI;
    }

    protected void setFileReference(String fileReference) {
        this.fileReference = fileReference;
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        FileReference reference = this.pathType == PathType.FILE ? FileSender.sendFileToServices(this.path, services) : FileSender.sendUriToServices(this.path, services);
        this.fileReference = reference.value();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.path;
    }

    public Path getFilePath() {
        return Path.fromString((String)this.path);
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void validate() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("Distributable resource must have a file or uri.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("resource '").append(this.name).append(this.pathType == PathType.FILE ? "' from file '" : " from uri ").append(this.path).append("' with ref '").append(this.fileReference).append("'");
        return b.toString();
    }

    public static enum PathType {
        FILE,
        URI;

    }
}

