/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.Version;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.logging.FileConnectionLog;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.DomClientProviderBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomHandlerBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.builder.xml.dom.ServletBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.docproc.DomDocprocChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.processing.DomProcessingBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomSearchChainsBuilder;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.IdentityProvider;
import com.yahoo.vespa.model.container.SecretStore;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ConnectionLogComponent;
import com.yahoo.vespa.model.container.component.FileStatusHandlerComponent;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.container.http.ssl.HostedSslConnectorFactory;
import com.yahoo.vespa.model.container.http.xml.HttpBuilder;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.container.jersey.xml.RestApiBuilder;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.GUIHandler;
import com.yahoo.vespa.model.container.search.PageTemplates;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.xml.AccessLogBuilder;
import com.yahoo.vespa.model.container.xml.CloudSecretStore;
import com.yahoo.vespa.model.container.xml.ContainerServiceBuilder;
import com.yahoo.vespa.model.container.xml.DocprocOptionsBuilder;
import com.yahoo.vespa.model.container.xml.DocumentApiOptionsBuilder;
import com.yahoo.vespa.model.container.xml.PlatformBundles;
import com.yahoo.vespa.model.container.xml.SearchHandler;
import com.yahoo.vespa.model.container.xml.document.DocumentFactoryBuilder;
import com.yahoo.vespa.model.content.StorageGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContainerModelBuilder
extends ConfigModelBuilder<ContainerModel> {
    static final String HOSTED_VESPA_STATUS_FILE = Defaults.getDefaults().underVespaHome("var/vespa/load-balancer/status.html");
    private static final String HOSTED_VESPA_STATUS_FILE_SETTING = "VESPA_LB_STATUS_FILE";
    private static final String CONTAINER_TAG = "container";
    private static final String DEPRECATED_CONTAINER_TAG = "jdisc";
    private static final String ENVIRONMENT_VARIABLES_ELEMENT = "environment-variables";
    private static final int MIN_ZOOKEEPER_NODE_COUNT = 1;
    private static final int MAX_ZOOKEEPER_NODE_COUNT = 7;
    private ApplicationPackage app;
    private final boolean standaloneBuilder;
    private final Networking networking;
    private final boolean rpcServerEnabled;
    private final boolean httpServerEnabled;
    protected DeployLogger log;
    public static final List<ConfigModelId> configModelIds = ImmutableList.of((Object)ConfigModelId.fromName("container"), (Object)ConfigModelId.fromName("jdisc"));
    private static final String xmlRendererId = RendererRegistry.xmlRendererId.getName();
    private static final String jsonRendererId = RendererRegistry.jsonRendererId.getName();

    public ContainerModelBuilder(boolean standaloneBuilder, Networking networking) {
        super(ContainerModel.class);
        this.standaloneBuilder = standaloneBuilder;
        this.networking = networking;
        this.rpcServerEnabled = !standaloneBuilder;
        this.httpServerEnabled = networking == Networking.enable;
    }

    @Override
    public List<ConfigModelId> handlesElements() {
        return configModelIds;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        this.log = modelContext.getDeployLogger();
        this.app = modelContext.getApplicationPackage();
        this.checkVersion(spec);
        this.checkTagName(spec, this.log);
        ApplicationContainerCluster cluster = this.createContainerCluster(spec, modelContext);
        this.addClusterContent(cluster, spec, modelContext);
        cluster.setMessageBusEnabled(this.rpcServerEnabled);
        cluster.setRpcServerEnabled(this.rpcServerEnabled);
        cluster.setHttpServerEnabled(this.httpServerEnabled);
        model.setCluster(cluster);
    }

    private ApplicationContainerCluster createContainerCluster(Element spec, final ConfigModelContext modelContext) {
        return (ApplicationContainerCluster)new VespaDomBuilder.DomConfigProducerBuilder<ApplicationContainerCluster>(){

            @Override
            protected ApplicationContainerCluster doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
                return new ApplicationContainerCluster(ancestor, modelContext.getProducerId(), modelContext.getProducerId(), deployState);
            }
        }.build(modelContext.getDeployState(), modelContext.getParentProducer(), spec);
    }

    private void addClusterContent(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        DocumentFactoryBuilder.buildDocumentFactories(cluster, spec);
        this.addConfiguredComponents(deployState, cluster, spec);
        this.addSecretStore(cluster, spec, deployState);
        this.addRestApis(deployState, spec, cluster);
        this.addServlets(deployState, spec, cluster);
        this.addModelEvaluation(spec, cluster, context);
        this.addProcessing(deployState, spec, cluster);
        this.addSearch(deployState, spec, cluster);
        this.addDocproc(deployState, spec, cluster);
        this.addDocumentApi(spec, cluster);
        cluster.addDefaultHandlersExceptStatus();
        this.addStatusHandlers(cluster, context.getDeployState().isHosted());
        this.addUserHandlers(deployState, cluster, spec);
        this.addHttp(deployState, spec, cluster, context);
        this.addAccessLogs(deployState, cluster, spec);
        this.addRoutingAliases(cluster, spec, deployState.zone().environment());
        this.addNodes(cluster, spec, context);
        this.addClientProviders(deployState, spec, cluster);
        this.addServerProviders(deployState, spec, cluster);
        this.addAthensCopperArgos(cluster, context);
        this.addZooKeeper(cluster, spec);
        this.addParameterStoreValidationHandler(cluster, deployState);
    }

    private void addParameterStoreValidationHandler(ApplicationContainerCluster cluster, DeployState deployState) {
        if (deployState.isHosted()) {
            cluster.addPlatformBundle(PlatformBundles.absoluteBundlePath("jdisc-cloud-aws"));
        }
        if (deployState.featureFlags().tenantIamRole()) {
            SystemBindingPattern bindingPattern = SystemBindingPattern.fromHttpPath("/validate-secret-store");
            Handler handler = new Handler(new ComponentModel("com.yahoo.jdisc.cloud.aws.AwsParameterStoreValidationHandler", null, "jdisc-cloud-aws", null));
            handler.addServerBindings(bindingPattern);
            cluster.addComponent(handler);
        }
    }

    private void addZooKeeper(ApplicationContainerCluster cluster, Element spec) {
        boolean isCombined;
        if (!ContainerModelBuilder.hasZooKeeper(spec)) {
            return;
        }
        Element nodesElement = XML.getChild((Element)spec, (String)"nodes");
        boolean bl = isCombined = nodesElement != null && nodesElement.hasAttribute("of");
        if (isCombined) {
            throw new IllegalArgumentException("A combined cluster cannot run ZooKeeper");
        }
        long nonRetiredNodes = cluster.getContainers().stream().filter(c -> !c.isRetired()).count();
        if (nonRetiredNodes < 1L || nonRetiredNodes > 7L || nonRetiredNodes % 2L == 0L) {
            throw new IllegalArgumentException("Cluster with ZooKeeper needs an odd number of nodes, between 1 and 7, have " + nonRetiredNodes + " non-retired");
        }
        cluster.addSimpleComponent("com.yahoo.vespa.curator.Curator", null, "zkfacade");
        cluster.getContainers().forEach(ContainerModelBuilder::addReconfigurableZooKeeperServerComponents);
    }

    public static void addReconfigurableZooKeeperServerComponents(Container container) {
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.ReconfigurableVespaZooKeeperServer", container));
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.Reconfigurer", container));
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.VespaZooKeeperAdminImpl", container));
    }

    private static SimpleComponent zookeeperComponent(String idSpec, Container container) {
        String configId = container.getConfigId();
        return new SimpleComponent(new ComponentModel(idSpec, null, "zookeeper-server", configId));
    }

    private void addSecretStore(ApplicationContainerCluster cluster, Element spec, DeployState deployState) {
        Element secretStoreElement = XML.getChild((Element)spec, (String)"secret-store");
        if (secretStoreElement != null) {
            String type = secretStoreElement.getAttribute("type");
            if ("cloud".equals(type)) {
                this.addCloudSecretStore(cluster, secretStoreElement, deployState);
            } else {
                SecretStore secretStore = new SecretStore();
                for (Element group : XML.getChildren((Element)secretStoreElement, (String)"group")) {
                    secretStore.addGroup(group.getAttribute("name"), group.getAttribute("environment"));
                }
                cluster.setSecretStore(secretStore);
            }
        }
    }

    private void addCloudSecretStore(ApplicationContainerCluster cluster, Element secretStoreElement, DeployState deployState) {
        if (!deployState.isHosted()) {
            return;
        }
        CloudSecretStore cloudSecretStore = new CloudSecretStore();
        Map<String, TenantSecretStore> secretStoresByName = deployState.getProperties().tenantSecretStores().stream().collect(Collectors.toMap(TenantSecretStore::getName, store -> store));
        Element store2 = XML.getChild((Element)secretStoreElement, (String)"store");
        for (Element group : XML.getChildren((Element)store2, (String)"aws-parameter-store")) {
            String account = group.getAttribute("account");
            String region = group.getAttribute("aws-region");
            TenantSecretStore secretStore = secretStoresByName.get(account);
            if (secretStore == null) {
                throw new RuntimeException("No configured secret store named " + account);
            }
            if (secretStore.getExternalId().isEmpty()) {
                throw new RuntimeException("No external ID has been set");
            }
            cloudSecretStore.addConfig(account, region, secretStore.getAwsId(), secretStore.getRole(), (String)secretStore.getExternalId().get());
        }
        cluster.addComponent(cloudSecretStore);
    }

    private void addAthensCopperArgos(ApplicationContainerCluster cluster, ConfigModelContext context) {
        if (!context.getDeployState().isHosted()) {
            return;
        }
        this.app.getDeployment().map(DeploymentSpec::fromXml).ifPresent(deploymentSpec -> {
            this.addIdentityProvider(cluster, context.getDeployState().getProperties().configServerSpecs(), context.getDeployState().getProperties().loadBalancerName(), context.getDeployState().getProperties().ztsUrl(), context.getDeployState().getProperties().athenzDnsSuffix(), context.getDeployState().zone(), (DeploymentSpec)deploymentSpec);
            this.addRotationProperties(cluster, context.getDeployState().zone(), context.getDeployState().getEndpoints(), (DeploymentSpec)deploymentSpec);
        });
    }

    private void addRotationProperties(ApplicationContainerCluster cluster, Zone zone, Set<ContainerEndpoint> endpoints, DeploymentSpec spec) {
        cluster.getContainers().forEach(container -> {
            this.setRotations((Container)container, endpoints, cluster.getName());
            container.setProp("activeRotation", Boolean.toString(this.zoneHasActiveRotation(zone, spec)));
        });
    }

    private boolean zoneHasActiveRotation(Zone zone, DeploymentSpec spec) {
        Optional instance = spec.instance(this.app.getApplicationId().instance());
        if (instance.isEmpty()) {
            return false;
        }
        return ((DeploymentInstanceSpec)instance.get()).zones().stream().anyMatch(declaredZone -> declaredZone.concerns(zone.environment(), Optional.of(zone.region())) && declaredZone.active());
    }

    private void setRotations(Container container, Set<ContainerEndpoint> endpoints, String containerClusterName) {
        Set rotationsProperty = endpoints.stream().filter(endpoint -> endpoint.clusterId().equals(containerClusterName)).flatMap(endpoint -> endpoint.names().stream()).collect(Collectors.toUnmodifiableSet());
        container.setProp("rotations", String.join((CharSequence)",", rotationsProperty));
    }

    private void addRoutingAliases(ApplicationContainerCluster cluster, Element spec, Environment environment) {
        if (environment != Environment.prod) {
            return;
        }
        Element aliases = XML.getChild((Element)spec, (String)"aliases");
        for (Element alias : XML.getChildren((Element)aliases, (String)"service-alias")) {
            cluster.serviceAliases().add(XML.getValue((Element)alias));
        }
        for (Element alias : XML.getChildren((Element)aliases, (String)"endpoint-alias")) {
            cluster.endpointAliases().add(XML.getValue((Element)alias));
        }
    }

    private void addConfiguredComponents(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        for (Element components : XML.getChildren((Element)spec, (String)"components")) {
            this.addIncludes(components);
            ContainerModelBuilder.addConfiguredComponents(deployState, cluster, components, "component");
        }
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, spec, "component");
    }

    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        if (isHostedVespa) {
            String name = "status.html";
            Optional<String> statusFile = Optional.ofNullable(System.getenv(HOSTED_VESPA_STATUS_FILE_SETTING));
            cluster.addComponent(new FileStatusHandlerComponent(name + "-status-handler", statusFile.orElse(HOSTED_VESPA_STATUS_FILE), SystemBindingPattern.fromHttpPath("/" + name)));
        } else {
            cluster.addVipHandler();
        }
    }

    private void addClientProviders(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element clientSpec : XML.getChildren((Element)spec, (String)"client")) {
            cluster.addComponent((Component)new DomClientProviderBuilder(cluster).build(deployState, cluster, clientSpec));
        }
    }

    private void addServerProviders(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, spec, "server");
    }

    protected void addAccessLogs(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        List<Element> accessLogElements = this.getAccessLogElements(spec);
        for (Element accessLog : accessLogElements) {
            AccessLogBuilder.buildIfNotDisabled(deployState, cluster, accessLog).ifPresent(cluster::addComponent);
        }
        if (accessLogElements.isEmpty() && deployState.getAccessLoggingEnabledByDefault()) {
            cluster.addDefaultSearchAccessLog();
        }
        if (cluster.getAllComponents().stream().anyMatch(component -> component instanceof AccessLogComponent)) {
            cluster.addComponent(new ConnectionLogComponent(cluster, FileConnectionLog.class, "qrs"));
        }
    }

    private List<Element> getAccessLogElements(Element spec) {
        return XML.getChildren((Element)spec, (String)"accesslog");
    }

    protected void addHttp(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element httpElement = XML.getChild((Element)spec, (String)"http");
        if (httpElement != null) {
            cluster.setHttp(this.buildHttp(deployState, cluster, httpElement));
        }
        if (ContainerModelBuilder.isHostedTenantApplication(context)) {
            ContainerModelBuilder.addHostedImplicitHttpIfNotPresent(cluster);
            this.addHostedImplicitAccessControlIfNotPresent(deployState, cluster);
            this.addDefaultConnectorHostedFilterBinding(cluster);
            this.addAdditionalHostedConnector(deployState, cluster, context);
        }
    }

    private void addDefaultConnectorHostedFilterBinding(ApplicationContainerCluster cluster) {
        cluster.getHttp().getAccessControl().ifPresent(accessControl -> accessControl.configureDefaultHostedConnector(cluster.getHttp()));
    }

    private void addAdditionalHostedConnector(DeployState deployState, ApplicationContainerCluster cluster, ConfigModelContext context) {
        HostedSslConnectorFactory connectorFactory;
        JettyHttpServer server = cluster.getHttp().getHttpServer().get();
        String serverName = server.getComponentId().getName();
        if (deployState.endpointCertificateSecrets().isPresent()) {
            boolean authorizeClient = deployState.zone().system().isPublic();
            if (authorizeClient && deployState.tlsClientAuthority().isEmpty()) {
                throw new RuntimeException("Client certificate authority security/clients.pem is missing - see: https://cloud.vespa.ai/en/security-model#data-plane");
            }
            EndpointCertificateSecrets endpointCertificateSecrets = deployState.endpointCertificateSecrets().get();
            boolean enforceHandshakeClientAuth = cluster.getHttp().getAccessControl().map(accessControl -> accessControl.clientAuthentication).map(clientAuth -> clientAuth.equals((Object)AccessControl.ClientAuthentication.need)).orElse(false);
            connectorFactory = authorizeClient ? HostedSslConnectorFactory.withProvidedCertificateAndTruststore(serverName, endpointCertificateSecrets, deployState.tlsClientAuthority().get()) : HostedSslConnectorFactory.withProvidedCertificate(serverName, endpointCertificateSecrets, enforceHandshakeClientAuth);
        } else {
            connectorFactory = HostedSslConnectorFactory.withDefaultCertificateAndTruststore(serverName);
        }
        cluster.getHttp().getAccessControl().ifPresent(accessControl -> accessControl.configureHostedConnector(connectorFactory));
        server.addConnector(connectorFactory);
    }

    private static boolean isHostedTenantApplication(ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        boolean isTesterApplication = deployState.getProperties().applicationId().instance().isTester();
        return deployState.isHosted() && context.getApplicationType() == ConfigModelContext.ApplicationType.DEFAULT && !isTesterApplication;
    }

    private static void addHostedImplicitHttpIfNotPresent(ApplicationContainerCluster cluster) {
        JettyHttpServer httpServer;
        if (cluster.getHttp() == null) {
            cluster.setHttp(new Http(new FilterChains(cluster)));
        }
        if ((httpServer = (JettyHttpServer)cluster.getHttp().getHttpServer().orElse(null)) == null) {
            httpServer = new JettyHttpServer("DefaultHttpServer", cluster, cluster.isHostedVespa());
            cluster.getHttp().setHttpServer(httpServer);
        }
        int defaultPort = Defaults.getDefaults().vespaWebServicePort();
        boolean defaultConnectorPresent = httpServer.getConnectorFactories().stream().anyMatch(connector -> connector.getListenPort() == defaultPort);
        if (!defaultConnectorPresent) {
            httpServer.addConnector(new ConnectorFactory.Builder("SearchServer", defaultPort).build());
        }
    }

    private void addHostedImplicitAccessControlIfNotPresent(DeployState deployState, ApplicationContainerCluster cluster) {
        Http http = cluster.getHttp();
        if (http.getAccessControl().isPresent()) {
            return;
        }
        AthenzDomain tenantDomain = deployState.getProperties().athenzDomain().orElse(null);
        if (tenantDomain == null) {
            return;
        }
        new AccessControl.Builder(tenantDomain.value()).setHandlers(cluster).readEnabled(false).writeEnabled(false).clientAuthentication(AccessControl.ClientAuthentication.need).build().configureHttpFilterChains(http);
    }

    private Http buildHttp(DeployState deployState, ApplicationContainerCluster cluster, Element httpElement) {
        Http http = (Http)new HttpBuilder().build(deployState, cluster, httpElement);
        if (this.networking == Networking.disable) {
            http.removeAllServers();
        }
        return http;
    }

    private void addRestApis(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element restApiElem : XML.getChildren((Element)spec, (String)"rest-api")) {
            cluster.addRestApi((RestApi)new RestApiBuilder().build(deployState, cluster, restApiElem));
        }
    }

    private void addServlets(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element servletElem : XML.getChildren((Element)spec, (String)"servlet")) {
            cluster.addServlet((Servlet)new ServletBuilder().build(deployState, cluster, servletElem));
        }
    }

    private void addDocumentApi(Element spec, ApplicationContainerCluster cluster) {
        ContainerDocumentApi containerDocumentApi = this.buildDocumentApi(cluster, spec);
        if (containerDocumentApi == null) {
            return;
        }
        cluster.setDocumentApi(containerDocumentApi);
    }

    private void addDocproc(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerDocproc containerDocproc = this.buildDocproc(deployState, cluster, spec);
        if (containerDocproc == null) {
            return;
        }
        cluster.setDocproc(containerDocproc);
        ContainerDocproc.Options docprocOptions = containerDocproc.options;
        cluster.setMbusParams(new ApplicationContainerCluster.MbusParams(docprocOptions.maxConcurrentFactor, docprocOptions.documentExpansionFactor, docprocOptions.containerCoreMemory));
    }

    private void addSearch(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        Element searchElement = XML.getChild((Element)spec, (String)"search");
        if (searchElement == null) {
            return;
        }
        this.addIncludes(searchElement);
        cluster.setSearch(this.buildSearch(deployState, cluster, searchElement));
        this.addSearchHandler(cluster, searchElement);
        this.addGUIHandler(cluster);
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, searchElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private void addModelEvaluation(Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element modelEvaluationElement = XML.getChild((Element)spec, (String)"model-evaluation");
        if (modelEvaluationElement == null) {
            return;
        }
        RankProfileList profiles = context.vespaModel() != null ? context.vespaModel().rankProfileList() : RankProfileList.empty;
        cluster.setModelEvaluation(new ContainerModelEvaluation(cluster, profiles));
    }

    private void addProcessing(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        Element processingElement = XML.getChild((Element)spec, (String)"processing");
        if (processingElement == null) {
            return;
        }
        this.addIncludes(processingElement);
        cluster.setProcessingChains((ProcessingChains)new DomProcessingBuilder(null).build(deployState, cluster, processingElement), (BindingPattern[])this.serverBindings(processingElement, ProcessingChains.defaultBindings).toArray(BindingPattern[]::new));
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, processingElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private ContainerSearch buildSearch(DeployState deployState, ApplicationContainerCluster containerCluster, Element producerSpec) {
        SearchChains searchChains = (SearchChains)new DomSearchChainsBuilder(null, false).build(deployState, containerCluster, producerSpec);
        ContainerSearch containerSearch = new ContainerSearch(containerCluster, searchChains, new ContainerSearch.Options());
        this.applyApplicationPackageDirectoryConfigs(deployState.getApplicationPackage(), containerSearch);
        containerSearch.setQueryProfiles(deployState.getQueryProfiles());
        containerSearch.setSemanticRules(deployState.getSemanticRules());
        return containerSearch;
    }

    private void applyApplicationPackageDirectoryConfigs(ApplicationPackage applicationPackage, ContainerSearch containerSearch) {
        PageTemplates.validate(applicationPackage);
        containerSearch.setPageTemplates(PageTemplates.create(applicationPackage));
    }

    private void addUserHandlers(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        for (Element component : XML.getChildren((Element)spec, (String)"handler")) {
            cluster.addComponent((Component)new DomHandlerBuilder(cluster).build(deployState, cluster, component));
        }
    }

    private void checkVersion(Element spec) {
        String version = spec.getAttribute("version");
        if (!Version.fromString((String)version).equals((Object)new Version(1))) {
            throw new RuntimeException("Expected container version to be 1.0, but got " + version);
        }
    }

    private void checkTagName(Element spec, DeployLogger logger) {
        if (spec.getTagName().equals(DEPRECATED_CONTAINER_TAG)) {
            logger.logApplicationPackage(Level.WARNING, "'jdisc' is deprecated as tag name. Use 'container' instead.");
        }
    }

    private void addNodes(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        if (this.standaloneBuilder) {
            this.addStandaloneNode(cluster, context.getDeployState());
        } else {
            this.addNodesFromXml(cluster, spec, context);
        }
    }

    private void addStandaloneNode(ApplicationContainerCluster cluster, DeployState deployState) {
        ApplicationContainer container = new ApplicationContainer(cluster, "standalone", cluster.getContainers().size(), deployState);
        cluster.addContainers(Collections.singleton(container));
    }

    static boolean incompatibleGCOptions(String jvmargs) {
        Pattern gcAlgorithm = Pattern.compile("-XX:[-+]Use.+GC");
        Pattern cmsArgs = Pattern.compile("-XX:[-+]*CMS");
        return gcAlgorithm.matcher(jvmargs).find() || cmsArgs.matcher(jvmargs).find();
    }

    private static String buildJvmGCOptions(DeployState deployState, String jvmGCOPtions) {
        String options;
        String string = options = jvmGCOPtions != null ? jvmGCOPtions : deployState.getProperties().jvmGCOptions();
        return options == null || options.isEmpty() ? (deployState.isHosted() ? "-XX:+UseConcMarkSweepGC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1" : "-XX:+UseG1GC -XX:MaxTenuringThreshold=15") : options;
    }

    private static String getJvmOptions(ApplicationContainerCluster cluster, Element nodesElement, DeployLogger deployLogger) {
        String jvmOptions;
        if (nodesElement.hasAttribute("jvm-options")) {
            jvmOptions = nodesElement.getAttribute("jvm-options");
            if (nodesElement.hasAttribute("jvmargs")) {
                String jvmArgs = nodesElement.getAttribute("jvmargs");
                throw new IllegalArgumentException("You have specified both jvm-options='" + jvmOptions + "' and deprecated jvmargs='" + jvmArgs + "'. Merge jvmargs into jvm-options.");
            }
        } else {
            jvmOptions = nodesElement.getAttribute("jvmargs");
            if (ContainerModelBuilder.incompatibleGCOptions(jvmOptions)) {
                deployLogger.logApplicationPackage(Level.WARNING, "You need to move out your GC related options from 'jvmargs' to 'jvm-gc-options'");
                cluster.setJvmGCOptions("-XX:+UseG1GC -XX:MaxTenuringThreshold=15");
            }
        }
        return jvmOptions;
    }

    private static String extractAttribute(Element element, String attrName) {
        return element.hasAttribute(attrName) ? element.getAttribute(attrName) : null;
    }

    void extractJvmFromLegacyNodesTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, ContainerModelBuilder.getJvmOptions(cluster, nodesElement, context.getDeployLogger()));
        if (cluster.getJvmGCOptions().isEmpty()) {
            String jvmGCOptions = ContainerModelBuilder.extractAttribute(nodesElement, "jvm-gc-options");
            cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context.getDeployState(), jvmGCOptions));
        }
        ContainerModelBuilder.applyMemoryPercentage(cluster, nodesElement.getAttribute("allocated-memory"));
    }

    void extractJvmTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element jvmElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, jvmElement.getAttribute("options"));
        ContainerModelBuilder.applyMemoryPercentage(cluster, jvmElement.getAttribute("allocated-memory"));
        String jvmGCOptions = ContainerModelBuilder.extractAttribute(jvmElement, "gc-options");
        cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context.getDeployState(), jvmGCOptions));
    }

    private void addNodesFromXml(ApplicationContainerCluster cluster, Element containerElement, ConfigModelContext context) {
        Element nodesElement = XML.getChild((Element)containerElement, (String)"nodes");
        if (nodesElement == null) {
            cluster.addContainers(this.allocateWithoutNodesTag(cluster, context));
        } else {
            List<ApplicationContainer> nodes = this.createNodes(cluster, containerElement, nodesElement, context);
            Element jvmElement = XML.getChild((Element)nodesElement, (String)"jvm");
            if (jvmElement == null) {
                this.extractJvmFromLegacyNodesTag(nodes, cluster, nodesElement, context);
            } else {
                this.extractJvmTag(nodes, cluster, jvmElement, context);
            }
            ContainerModelBuilder.applyRoutingAliasProperties(nodes, cluster);
            ContainerModelBuilder.applyDefaultPreload(nodes, nodesElement);
            String environmentVars = ContainerModelBuilder.getEnvironmentVariables(XML.getChild((Element)nodesElement, (String)ENVIRONMENT_VARIABLES_ELEMENT));
            if (!environmentVars.isEmpty()) {
                cluster.setEnvironmentVars(environmentVars);
            }
            if (ContainerModelBuilder.useCpuSocketAffinity(nodesElement)) {
                AbstractService.distributeCpuSocketAffinity(nodes);
            }
            cluster.addContainers(nodes);
        }
    }

    private static String getEnvironmentVariables(Element environmentVariables) {
        StringBuilder sb = new StringBuilder();
        if (environmentVariables != null) {
            for (Element var : XML.getChildren((Element)environmentVariables)) {
                sb.append(var.getNodeName()).append('=').append(var.getTextContent()).append(' ');
            }
        }
        return sb.toString();
    }

    private List<ApplicationContainer> createNodes(ApplicationContainerCluster cluster, Element containerElement, Element nodesElement, ConfigModelContext context) {
        if (nodesElement.hasAttribute("type")) {
            return this.createNodesFromNodeType(cluster, nodesElement, context);
        }
        if (nodesElement.hasAttribute("of")) {
            return this.createNodesFromContentServiceReference(cluster, nodesElement, context);
        }
        if (nodesElement.hasAttribute("count")) {
            return this.createNodesFromNodeCount(cluster, containerElement, nodesElement, context);
        }
        if (cluster.isHostedVespa() && cluster.getZone().environment().isManuallyDeployed()) {
            return this.createNodesFromNodeCount(cluster, containerElement, nodesElement, context);
        }
        return this.createNodesFromNodeList(context.getDeployState(), cluster, nodesElement);
    }

    private static void applyRoutingAliasProperties(List<ApplicationContainer> result, ApplicationContainerCluster cluster) {
        if (!cluster.serviceAliases().isEmpty()) {
            result.forEach(container -> container.setProp("servicealiases", cluster.serviceAliases().stream().collect(Collectors.joining(","))));
        }
        if (!cluster.endpointAliases().isEmpty()) {
            result.forEach(container -> container.setProp("endpointaliases", cluster.endpointAliases().stream().collect(Collectors.joining(","))));
        }
    }

    private static void applyMemoryPercentage(ApplicationContainerCluster cluster, String memoryPercentage) {
        if (memoryPercentage == null || memoryPercentage.isEmpty()) {
            return;
        }
        if (!(memoryPercentage = memoryPercentage.trim()).endsWith("%")) {
            throw new IllegalArgumentException("The memory percentage given for nodes in " + cluster + " must be an integer percentage ending by the '%' sign");
        }
        memoryPercentage = memoryPercentage.substring(0, memoryPercentage.length() - 1).trim();
        try {
            cluster.setMemoryPercentage(Integer.parseInt(memoryPercentage));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The memory percentage given for nodes in " + cluster + " must be an integer percentage ending by the '%' sign");
        }
    }

    private List<ApplicationContainer> allocateWithoutNodesTag(ApplicationContainerCluster cluster, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        HostSystem hostSystem = cluster.hostSystem();
        if (deployState.isHosted()) {
            ClusterSpec clusterSpec = ClusterSpec.request((ClusterSpec.Type)ClusterSpec.Type.container, (ClusterSpec.Id)ClusterSpec.Id.from((String)cluster.getName())).vespaVersion(deployState.getWantedNodeVespaVersion()).dockerImageRepository(deployState.getWantedDockerImageRepo()).build();
            int nodeCount = deployState.zone().environment().isProduction() ? 2 : 1;
            Capacity capacity = Capacity.from((ClusterResources)new ClusterResources(nodeCount, 1, NodeResources.unspecified()), (boolean)false, (!deployState.getProperties().isBootstrap() ? 1 : 0) != 0);
            Map<HostResource, ClusterMembership> hosts = hostSystem.allocateHosts(clusterSpec, capacity, this.log);
            return this.createNodesFromHosts(this.log, hosts, cluster, context.getDeployState());
        }
        return this.singleHostContainerCluster(cluster, hostSystem.getHost("default_singlenode_container"), context);
    }

    private List<ApplicationContainer> singleHostContainerCluster(ApplicationContainerCluster cluster, HostResource host, ConfigModelContext context) {
        ApplicationContainer node = new ApplicationContainer(cluster, "container.0", 0, context.getDeployState());
        node.setHostResource(host);
        node.initService(context.getDeployLogger());
        return List.of(node);
    }

    private List<ApplicationContainer> createNodesFromNodeCount(ApplicationContainerCluster cluster, Element containerElement, Element nodesElement, ConfigModelContext context) {
        NodesSpecification nodesSpecification = NodesSpecification.from(new ModelElement(nodesElement), context);
        Map<HostResource, ClusterMembership> hosts = nodesSpecification.provision(cluster.getRoot().hostSystem(), ClusterSpec.Type.container, ClusterSpec.Id.from((String)cluster.getName()), this.log, ContainerModelBuilder.hasZooKeeper(containerElement));
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster, context.getDeployState());
    }

    private List<ApplicationContainer> createNodesFromNodeType(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodeType type = NodeType.valueOf((String)nodesElement.getAttribute("type"));
        ClusterSpec clusterSpec = ClusterSpec.request((ClusterSpec.Type)ClusterSpec.Type.container, (ClusterSpec.Id)ClusterSpec.Id.from((String)cluster.getName())).vespaVersion(context.getDeployState().getWantedNodeVespaVersion()).dockerImageRepository(context.getDeployState().getWantedDockerImageRepo()).build();
        Map<HostResource, ClusterMembership> hosts = cluster.getRoot().hostSystem().allocateHosts(clusterSpec, Capacity.fromRequiredNodeType((NodeType)type), this.log);
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster, context.getDeployState());
    }

    private List<ApplicationContainer> createNodesFromContentServiceReference(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodesSpecification nodeSpecification;
        try {
            nodeSpecification = NodesSpecification.from(new ModelElement(nodesElement), context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(cluster + " contains an invalid reference", e);
        }
        String referenceId = nodesElement.getAttribute("of");
        cluster.setHostClusterId(referenceId);
        Map<HostResource, ClusterMembership> hosts = StorageGroup.provisionHosts(nodeSpecification, referenceId, cluster.getRoot().hostSystem(), context.getDeployLogger());
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster, context.getDeployState());
    }

    private List<ApplicationContainer> createNodesFromHosts(DeployLogger deployLogger, Map<HostResource, ClusterMembership> hosts, ApplicationContainerCluster cluster, DeployState deployState) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        for (Map.Entry<HostResource, ClusterMembership> entry : hosts.entrySet()) {
            String id = "container." + entry.getValue().index();
            ApplicationContainer container = new ApplicationContainer(cluster, id, entry.getValue().retired(), entry.getValue().index(), deployState);
            container.setHostResource(entry.getKey());
            container.initService(deployLogger);
            nodes.add(container);
        }
        return nodes;
    }

    private List<ApplicationContainer> createNodesFromNodeList(DeployState deployState, ApplicationContainerCluster cluster, Element nodesElement) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        int nodeIndex = 0;
        for (Element nodeElem : XML.getChildren((Element)nodesElement, (String)"node")) {
            nodes.add((ApplicationContainer)new ContainerServiceBuilder("container." + nodeIndex, nodeIndex).build(deployState, cluster, nodeElem));
            ++nodeIndex;
        }
        return nodes;
    }

    private static boolean useCpuSocketAffinity(Element nodesElement) {
        if (nodesElement.hasAttribute("cpu-socket-affinity")) {
            return Boolean.parseBoolean(nodesElement.getAttribute("cpu-socket-affinity"));
        }
        return false;
    }

    private static void applyNodesTagJvmArgs(List<ApplicationContainer> containers, String jvmArgs) {
        for (Container container : containers) {
            if (!container.getAssignedJvmOptions().isEmpty()) continue;
            container.prependJvmOptions(jvmArgs);
        }
    }

    private static void applyDefaultPreload(List<ApplicationContainer> containers, Element nodesElement) {
        if (!nodesElement.hasAttribute("preload")) {
            return;
        }
        for (Container container : containers) {
            container.setPreLoad(nodesElement.getAttribute("preload"));
        }
    }

    private void addSearchHandler(ApplicationContainerCluster cluster, Element searchElement) {
        cluster.addComponent(new ProcessingHandler<SearchChains>((SearchChains)cluster.getSearch().getChains(), "com.yahoo.search.searchchain.ExecutionFactory"));
        cluster.addComponent(new SearchHandler(cluster, this.serverBindings(searchElement, SearchHandler.DEFAULT_BINDING), ContainerThreadpool.UserOptions.fromXml(searchElement).orElse(null)));
    }

    private void addGUIHandler(ApplicationContainerCluster cluster) {
        GUIHandler guiHandler = new GUIHandler();
        guiHandler.addServerBindings(SystemBindingPattern.fromHttpPath("/querybuilder/*"));
        cluster.addComponent(guiHandler);
    }

    private List<BindingPattern> serverBindings(Element searchElement, BindingPattern ... defaultBindings) {
        List bindings = XML.getChildren((Element)searchElement, (String)"binding");
        if (bindings.isEmpty()) {
            return List.of(defaultBindings);
        }
        return this.toBindingList(bindings);
    }

    private List<BindingPattern> toBindingList(List<Element> bindingElements) {
        ArrayList<BindingPattern> result = new ArrayList<BindingPattern>();
        for (Element element : bindingElements) {
            String text = element.getTextContent().trim();
            if (text.isEmpty()) continue;
            result.add(UserBindingPattern.fromPattern(text));
        }
        return result;
    }

    private ContainerDocumentApi buildDocumentApi(ApplicationContainerCluster cluster, Element spec) {
        Element documentApiElement = XML.getChild((Element)spec, (String)"document-api");
        if (documentApiElement == null) {
            return null;
        }
        ContainerDocumentApi.Options documentApiOptions = DocumentApiOptionsBuilder.build(documentApiElement);
        return new ContainerDocumentApi(cluster, documentApiOptions);
    }

    private ContainerDocproc buildDocproc(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        Element docprocElement = XML.getChild((Element)spec, (String)"document-processing");
        if (docprocElement == null) {
            return null;
        }
        this.addIncludes(docprocElement);
        DocprocChains chains = (DocprocChains)new DomDocprocChainsBuilder(null, false).build(deployState, cluster, docprocElement);
        ContainerDocproc.Options docprocOptions = DocprocOptionsBuilder.build(docprocElement);
        return new ContainerDocproc(cluster, chains, docprocOptions, !this.standaloneBuilder);
    }

    private void addIncludes(Element parentElement) {
        List includes = XML.getChildren((Element)parentElement, (String)"include");
        if (includes.isEmpty()) {
            return;
        }
        if (this.app == null) {
            throw new IllegalArgumentException("Element <include> given in XML config, but no application package given.");
        }
        for (Element include : includes) {
            this.addInclude(parentElement, include);
        }
    }

    private void addInclude(Element parentElement, Element include) {
        String dirName = include.getAttribute("dir");
        this.app.validateIncludeDir(dirName);
        List includedFiles = Xml.allElemsFromPath((ApplicationPackage)this.app, (String)dirName);
        for (Element includedFile : includedFiles) {
            List includedSubElements = XML.getChildren((Element)includedFile);
            for (Element includedSubElement : includedSubElements) {
                Node copiedNode = parentElement.getOwnerDocument().importNode(includedSubElement, true);
                parentElement.appendChild(copiedNode);
            }
        }
    }

    private static void addConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element spec, String componentName) {
        for (Element node : XML.getChildren((Element)spec, (String)componentName)) {
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, node));
        }
    }

    private static void validateAndAddConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element spec, String componentName, Consumer<Element> elementValidator) {
        for (Element node : XML.getChildren((Element)spec, (String)componentName)) {
            elementValidator.accept(node);
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, node));
        }
    }

    private void addIdentityProvider(ApplicationContainerCluster cluster, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, Zone zone, DeploymentSpec spec) {
        spec.athenzDomain().ifPresent(domain -> {
            AthenzService service = (AthenzService)spec.instance(this.app.getApplicationId().instance()).flatMap(instanceSpec -> instanceSpec.athenzService(zone.environment(), zone.region())).or(() -> spec.athenzService()).orElseThrow(() -> new RuntimeException("Missing Athenz service configuration in instance '" + this.app.getApplicationId().instance() + "'"));
            String zoneDnsSuffix = zone.environment().value() + "-" + zone.region().value() + "." + athenzDnsSuffix;
            IdentityProvider identityProvider = new IdentityProvider((AthenzDomain)domain, service, this.getLoadBalancerName(loadBalancerName, configServerSpecs), ztsUrl, zoneDnsSuffix, zone);
            cluster.addComponent(identityProvider);
            cluster.getContainers().forEach(container -> {
                container.setProp("identity.domain", domain.value());
                container.setProp("identity.service", service.value());
            });
        });
    }

    private HostName getLoadBalancerName(HostName loadbalancerName, List<ConfigServerSpec> configServerSpecs) {
        return Optional.ofNullable(loadbalancerName).orElseGet(() -> HostName.from((String)configServerSpecs.stream().findFirst().map(ConfigServerSpec::getHostName).orElse("unknown")));
    }

    private static boolean hasZooKeeper(Element spec) {
        return XML.getChild((Element)spec, (String)"zookeeper") != null;
    }

    private static void validateRendererElement(Element element) {
        String idAttr = element.getAttribute("id");
        if (idAttr.equals(xmlRendererId) || idAttr.equals(jsonRendererId)) {
            throw new IllegalArgumentException(String.format("Renderer id %s is reserved for internal use", idAttr));
        }
    }

    public static boolean isContainerTag(Element element) {
        return CONTAINER_TAG.equals(element.getTagName()) || DEPRECATED_CONTAINER_TAG.equals(element.getTagName());
    }

    public static enum Networking {
        disable,
        enable;

    }
}

