/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Sorting;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;

public class SortingOperation
implements FieldOperation {
    private final String attributeName;
    private Boolean ascending;
    private Boolean descending;
    private Sorting.Function function;
    private Sorting.Strength strength;
    private String locale;

    public SortingOperation(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Boolean getAscending() {
        return this.ascending;
    }

    public void setAscending() {
        this.ascending = true;
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public void setDescending() {
        this.descending = true;
    }

    public Sorting.Function getFunction() {
        return this.function;
    }

    public void setFunction(Sorting.Function function) {
        this.function = function;
    }

    public Sorting.Strength getStrength() {
        return this.strength;
    }

    public void setStrength(Sorting.Strength strength) {
        this.strength = strength;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void apply(SDField field) {
        Attribute attribute = field.getAttributes().get(this.attributeName);
        if (attribute == null) {
            attribute = new Attribute(this.attributeName, field.getDataType());
            field.addAttribute(attribute);
        }
        Sorting sorting = attribute.getSorting();
        if (this.ascending != null) {
            sorting.setAscending();
        }
        if (this.descending != null) {
            sorting.setDescending();
        }
        if (this.function != null) {
            sorting.setFunction(this.function);
        }
        if (this.strength != null) {
            sorting.setStrength(this.strength);
        }
        if (this.locale != null) {
            sorting.setLocale(this.locale);
        }
    }
}

