/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.DispatchSpec;
import java.util.ArrayList;
import java.util.List;

public class DomDispatchBuilder {
    public static DispatchSpec build(ModelElement contentXml) {
        DispatchSpec.Builder builder = new DispatchSpec.Builder();
        ModelElement dispatchElement = contentXml.child("dispatch");
        if (dispatchElement == null) {
            return builder.build();
        }
        builder.setNumDispatchGroups(dispatchElement.childAsInteger("num-dispatch-groups"));
        List<ModelElement> groupsElement = dispatchElement.subElements("group");
        if (groupsElement != null) {
            builder.setGroups(DomDispatchBuilder.buildGroups(groupsElement));
        }
        return builder.build();
    }

    private static List<DispatchSpec.Group> buildGroups(List<ModelElement> groupsElement) {
        ArrayList<DispatchSpec.Group> groups = new ArrayList<DispatchSpec.Group>();
        for (ModelElement groupElement : groupsElement) {
            groups.add(DomDispatchBuilder.buildGroup(groupElement));
        }
        return groups;
    }

    private static DispatchSpec.Group buildGroup(ModelElement groupElement) {
        List<ModelElement> nodes = groupElement.subElements("node");
        DispatchSpec.Group group = new DispatchSpec.Group();
        for (ModelElement nodeElement : nodes) {
            group.addNode(DomDispatchBuilder.buildNode(nodeElement));
        }
        return group;
    }

    private static DispatchSpec.Node buildNode(ModelElement nodeElement) {
        return new DispatchSpec.Node(nodeElement.integerAttribute("distribution-key"));
    }
}

