/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;

public final class ApplicationContainer
extends Container
implements QrStartConfig.Producer,
ZookeeperServerConfig.Producer {
    private static final String defaultHostedJVMArgs = "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage";
    private final boolean isHostedVespa;

    public ApplicationContainer(AbstractConfigProducer<?> parent, String name, int index, DeployState deployState) {
        this(parent, name, false, index, deployState);
    }

    public ApplicationContainer(AbstractConfigProducer<?> parent, String name, boolean retired, int index, DeployState deployState) {
        super(parent, name, retired, index, deployState);
        this.isHostedVespa = deployState.isHosted();
    }

    public void getConfig(QrStartConfig.Builder builder) {
        NodeResources nodeResources;
        if (this.getHostResource() != null && !(nodeResources = this.getHostResource().realResources()).isUnspecified()) {
            builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(nodeResources.vcpu())));
        }
    }

    @Override
    protected ContainerServiceType myServiceType() {
        ContainerCluster cluster;
        if (this.parent instanceof ContainerCluster && (cluster = (ContainerCluster)this.parent).getSearch() != null && cluster.getDocproc() == null && cluster.getDocumentApi() == null) {
            return ContainerServiceType.QRSERVER;
        }
        return ContainerServiceType.CONTAINER;
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs = super.getJvmOptions();
        return this.isHostedVespa && this.hasDocproc() ? ("".equals(jvmArgs) ? defaultHostedJVMArgs : "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage " + jvmArgs) : jvmArgs;
    }

    private boolean hasDocproc() {
        return this.parent instanceof ContainerCluster && ((ContainerCluster)this.parent).getDocproc() != null;
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }

    @Override
    protected String jvmOmitStackTraceInFastThrowOption(ModelContext.FeatureFlags featureFlags) {
        return featureFlags.jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type.container);
    }
}

