/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.vespa.model.admin.Configserver;
import java.util.ArrayList;
import java.util.List;

public class ZooKeepersConfigProvider
implements ZookeepersConfig.Producer {
    public static final int zooKeeperClientPort = 2181;
    private final List<Configserver> configServers;

    public ZooKeepersConfigProvider(List<Configserver> configServers) {
        if (configServers == null) {
            configServers = new ArrayList<Configserver>();
        }
        this.configServers = configServers;
    }

    public List<String> getZooKeepers() {
        ArrayList<String> servers = new ArrayList<String>();
        for (Configserver server : this.configServers) {
            servers.add(server.getHostName() + ":2181");
        }
        return servers;
    }

    public String getZooKeepersConnectionSpec() {
        return CollectionUtil.mkString(this.getZooKeepers(), (String)",");
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        builder.zookeeperserverlist(this.getZooKeepersConnectionSpec());
    }
}

