/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configmodel.producers;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentmodel.DataTypeCollection;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.vespa.documentmodel.DocumentModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DocumentManager {
    public DocumentmanagerConfig.Builder produce(DocumentModel model, DocumentmanagerConfig.Builder documentConfigBuilder) {
        documentConfigBuilder.enablecompression(false);
        HashSet<DataType> handled = new HashSet<DataType>();
        for (NewDocumentType documentType : model.getDocumentManager().getTypes()) {
            this.buildConfig(documentType, documentConfigBuilder, handled);
            this.buildConfig(documentType.getAnnotations(), documentConfigBuilder);
            if (documentType == VespaDocumentType.INSTANCE) continue;
            DocumentmanagerConfig.Datatype.Builder dataTypeBuilder = new DocumentmanagerConfig.Datatype.Builder();
            documentConfigBuilder.datatype(dataTypeBuilder);
            this.buildConfig((DataType)documentType, dataTypeBuilder);
        }
        return documentConfigBuilder;
    }

    private void buildConfig(DataTypeCollection type, DocumentmanagerConfig.Builder documentConfigBuilder, Set<DataType> built) {
        for (DataType dataType : type.getTypes()) {
            if (built.contains(dataType)) continue;
            built.add(dataType);
            if (dataType instanceof TemporaryStructuredDataType || dataType.getId() >= 0 && dataType.getId() <= DataType.lastPredefinedDataTypeId()) continue;
            DocumentmanagerConfig.Datatype.Builder dataTypeBuilder = new DocumentmanagerConfig.Datatype.Builder();
            documentConfigBuilder.datatype(dataTypeBuilder);
            this.buildConfig(dataType, dataTypeBuilder);
        }
    }

    private void buildConfig(AnnotationType type, DocumentmanagerConfig.Annotationtype.Builder atb) {
        atb.id(type.getId()).name(type.getName());
        if (type.getDataType() != null) {
            atb.datatype(type.getDataType().getId());
        }
        if (!type.getInheritedTypes().isEmpty()) {
            for (AnnotationType inherited : type.getInheritedTypes()) {
                atb.inherits(new DocumentmanagerConfig.Annotationtype.Inherits.Builder().id(inherited.getId()));
            }
        }
    }

    private void buildConfig(Collection<AnnotationType> types, DocumentmanagerConfig.Builder builder) {
        for (AnnotationType type : types) {
            DocumentmanagerConfig.Annotationtype.Builder atb = new DocumentmanagerConfig.Annotationtype.Builder();
            this.buildConfig(type, atb);
            builder.annotationtype(atb);
        }
    }

    private void buildConfig(DataType type, DocumentmanagerConfig.Datatype.Builder builder) {
        builder.id(type.getId());
        if (type instanceof ArrayDataType) {
            CollectionDataType dt = (CollectionDataType)type;
            builder.arraytype(new DocumentmanagerConfig.Datatype.Arraytype.Builder().datatype(dt.getNestedType().getId()));
        } else if (type instanceof WeightedSetDataType) {
            WeightedSetDataType dt = (WeightedSetDataType)type;
            builder.weightedsettype(new DocumentmanagerConfig.Datatype.Weightedsettype.Builder().datatype(dt.getNestedType().getId()).createifnonexistant(dt.createIfNonExistent()).removeifzero(dt.removeIfZero()));
        } else if (type instanceof MapDataType) {
            MapDataType mtype = (MapDataType)type;
            builder.maptype(new DocumentmanagerConfig.Datatype.Maptype.Builder().keytype(mtype.getKeyType().getId()).valtype(mtype.getValueType().getId()));
        } else if (type instanceof DocumentType) {
            DocumentType dt = (DocumentType)type;
            DocumentmanagerConfig.Datatype.Documenttype.Builder doc = new DocumentmanagerConfig.Datatype.Documenttype.Builder();
            builder.documenttype(doc);
            doc.name(dt.getName()).headerstruct(dt.contentStruct().getId());
            for (DocumentType inherited : dt.getInheritedTypes()) {
                doc.inherits(new DocumentmanagerConfig.Datatype.Documenttype.Inherits.Builder().name(inherited.getName()));
            }
        } else if (type instanceof NewDocumentType) {
            NewDocumentType dt = (NewDocumentType)type;
            DocumentmanagerConfig.Datatype.Documenttype.Builder doc = new DocumentmanagerConfig.Datatype.Documenttype.Builder();
            builder.documenttype(doc);
            doc.name(dt.getName()).headerstruct(dt.getHeader().getId());
            for (NewDocumentType inherited : dt.getInherited()) {
                doc.inherits(new DocumentmanagerConfig.Datatype.Documenttype.Inherits.Builder().name(inherited.getName()));
            }
            this.buildConfig(dt.getFieldSets(), doc);
            this.buildImportedFieldsConfig(dt.getImportedFieldNames(), doc);
        } else if (!(type instanceof TemporaryStructuredDataType)) {
            if (type instanceof StructDataType) {
                StructDataType structType = (StructDataType)type;
                DocumentmanagerConfig.Datatype.Structtype.Builder structBuilder = new DocumentmanagerConfig.Datatype.Structtype.Builder();
                builder.structtype(structBuilder);
                structBuilder.name(structType.getName());
                if (structType.getCompressionConfig().type.getCode() != 0) {
                    structBuilder.compresstype(DocumentmanagerConfig.Datatype.Structtype.Compresstype.Enum.valueOf((String)structType.getCompressionConfig().type.toString())).compresslevel(structType.getCompressionConfig().compressionLevel).compressthreshold((int)structType.getCompressionConfig().threshold).compressminsize((int)structType.getCompressionConfig().minsize);
                }
                for (Field field : structType.getFieldsThisTypeOnly()) {
                    DocumentmanagerConfig.Datatype.Structtype.Field.Builder fieldBuilder = new DocumentmanagerConfig.Datatype.Structtype.Field.Builder();
                    structBuilder.field(fieldBuilder);
                    fieldBuilder.name(field.getName());
                    if (field.hasForcedId()) {
                        fieldBuilder.id(new DocumentmanagerConfig.Datatype.Structtype.Field.Id.Builder().id(field.getId()));
                    }
                    fieldBuilder.datatype(field.getDataType().getId());
                    if (!(field.getDataType() instanceof TensorDataType)) continue;
                    fieldBuilder.detailedtype(((TensorDataType)field.getDataType()).getTensorType().toString());
                }
                for (StructDataType inherited : structType.getInheritedTypes()) {
                    structBuilder.inherits(new DocumentmanagerConfig.Datatype.Structtype.Inherits.Builder().name(inherited.getName()));
                }
            } else if (type instanceof AnnotationReferenceDataType) {
                AnnotationReferenceDataType annotationRef = (AnnotationReferenceDataType)type;
                builder.annotationreftype(new DocumentmanagerConfig.Datatype.Annotationreftype.Builder().annotation(annotationRef.getAnnotationType().getName()));
            } else if (!(type instanceof TensorDataType)) {
                if (type instanceof ReferenceDataType) {
                    ReferenceDataType refType = (ReferenceDataType)type;
                    builder.referencetype(new DocumentmanagerConfig.Datatype.Referencetype.Builder().target_type_id(refType.getTargetType().getId()));
                } else {
                    throw new IllegalArgumentException("Can not create config for data type '" + type.getName());
                }
            }
        }
    }

    private void buildConfig(Set<FieldSet> fieldSets, DocumentmanagerConfig.Datatype.Documenttype.Builder doc) {
        for (FieldSet builtinFs : fieldSets) {
            this.buildConfig(builtinFs, doc);
        }
    }

    private void buildConfig(FieldSet fs, DocumentmanagerConfig.Datatype.Documenttype.Builder doc) {
        doc.fieldsets(fs.getName(), new DocumentmanagerConfig.Datatype.Documenttype.Fieldsets.Builder().fields(fs.getFieldNames()));
    }

    private void buildImportedFieldsConfig(Collection<String> fieldNames, DocumentmanagerConfig.Datatype.Documenttype.Builder builder) {
        for (String fieldName : fieldNames) {
            DocumentmanagerConfig.Datatype.Documenttype.Importedfield.Builder ib = new DocumentmanagerConfig.Datatype.Documenttype.Importedfield.Builder();
            ib.name(fieldName);
            builder.importedfield(ib);
        }
    }
}

