/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.routing;

import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.documentapi.messagebus.protocol.DocumentrouteselectorpolicyConfig;
import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.content.Distributor;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.routing.Protocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class DocumentProtocol
implements Protocol,
DocumentrouteselectorpolicyConfig.Producer,
DocumentProtocolPoliciesConfig.Producer {
    private static final String NAME = "document";
    private final ApplicationSpec application;
    private final RoutingTableSpec routingTable;
    private final ConfigModelRepo repo;

    public static String getIndexedRouteName(String configId) {
        return configId + "-index";
    }

    public static String getDirectRouteName(String configId) {
        return configId + "-direct";
    }

    DocumentProtocol(ConfigModelRepo plugins) {
        this.application = DocumentProtocol.createApplicationSpec(plugins);
        this.routingTable = DocumentProtocol.createRoutingTable(plugins);
        this.repo = plugins;
    }

    private static ApplicationSpec createApplicationSpec(ConfigModelRepo plugins) {
        ApplicationSpec ret = new ApplicationSpec();
        for (ContentCluster contentCluster : Content.getContentClusters(plugins)) {
            for (Distributor node : contentCluster.getDistributorNodes().getChildren().values()) {
                ret.addService(NAME, node.getConfigId() + "/default");
            }
        }
        for (ContainerCluster containerCluster : ContainerModel.containerClusters(plugins)) {
            ContainerDocproc containerDocproc = containerCluster.getDocproc();
            if (containerDocproc == null) continue;
            DocumentProtocol.createDocprocChainSpec(ret, ((DocprocChains)containerDocproc.getChains()).allChains().allComponents(), containerCluster.getContainers());
        }
        return ret;
    }

    private static void createDocprocChainSpec(ApplicationSpec spec, List<DocprocChain> docprocChains, List<? extends Container> containerNodes) {
        for (DocprocChain chain : docprocChains) {
            for (Container container : containerNodes) {
                spec.addService(NAME, container.getConfigId() + "/chain." + chain.getComponentId().stringValue());
            }
        }
    }

    public void getConfig(DocumentrouteselectorpolicyConfig.Builder builder) {
        for (ContentCluster cluster : Content.getContentClusters(this.repo)) {
            DocumentProtocol.addRoute(cluster.getConfigId(), cluster.getRoutingSelector(), builder);
        }
    }

    public void getConfig(DocumentProtocolPoliciesConfig.Builder builder) {
        for (ContentCluster cluster : Content.getContentClusters(this.repo)) {
            DocumentProtocolPoliciesConfig.Cluster.Builder clusterBuilder = new DocumentProtocolPoliciesConfig.Cluster.Builder();
            DocumentProtocol.addSelector(cluster.getConfigId(), cluster.getRoutingSelector(), clusterBuilder);
            if (cluster.getSearch().hasIndexedCluster()) {
                DocumentProtocol.addRoutes(DocumentProtocol.getDirectRouteName(cluster.getConfigId()), DocumentProtocol.getIndexedRouteName(cluster.getConfigId()), clusterBuilder);
            }
            builder.cluster(cluster.getConfigId(), clusterBuilder);
        }
    }

    private static void addRoutes(String directRoute, String indexedRoute, DocumentProtocolPoliciesConfig.Cluster.Builder builder) {
        builder.defaultRoute(directRoute).route(new DocumentProtocolPoliciesConfig.Cluster.Route.Builder().messageType(100004).name(indexedRoute)).route(new DocumentProtocolPoliciesConfig.Cluster.Route.Builder().messageType(100005).name(indexedRoute)).route(new DocumentProtocolPoliciesConfig.Cluster.Route.Builder().messageType(100006).name(indexedRoute));
    }

    private static void addSelector(String clusterConfigId, String selector, DocumentProtocolPoliciesConfig.Cluster.Builder builder) {
        try {
            new DocumentSelector(selector);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse selector '" + selector + "' for route '" + clusterConfigId + "' in policy 'DocumentRouteSelector'.");
        }
        builder.selector(selector);
    }

    private static void addRoute(String clusterConfigId, String selector, DocumentrouteselectorpolicyConfig.Builder builder) {
        try {
            new DocumentSelector(selector);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse selector '" + selector + "' for route '" + clusterConfigId + "' in policy 'DocumentRouteSelector'.");
        }
        DocumentrouteselectorpolicyConfig.Route.Builder routeBuilder = new DocumentrouteselectorpolicyConfig.Route.Builder();
        routeBuilder.name(clusterConfigId);
        routeBuilder.selector(selector);
        builder.route(routeBuilder);
    }

    private static RoutingTableSpec createRoutingTable(ConfigModelRepo plugins) {
        List<ContentCluster> content = Content.getContentClusters(plugins);
        Collection<ContainerCluster<?>> containerClusters = ContainerModel.containerClusters(plugins);
        RoutingTableSpec table = new RoutingTableSpec(NAME);
        DocumentProtocol.addContainerClusterDocprocHops(containerClusters, table);
        DocumentProtocol.addContentRouting(content, table);
        DocumentProtocol.addIndexingHop(content, table);
        DocumentProtocol.addDefaultRoutes(content, containerClusters, table);
        DocumentProtocol.simplifyRouteNames(table);
        return table;
    }

    private static void addContainerClusterDocprocHops(Collection<ContainerCluster<?>> containerClusters, RoutingTableSpec table) {
        for (ContainerCluster<?> cluster : containerClusters) {
            ContainerDocproc docproc = cluster.getDocproc();
            if (docproc == null) continue;
            String policy = DocumentProtocol.policy(docproc);
            for (DocprocChain chain : ((DocprocChains)docproc.getChains()).allChains().allComponents()) {
                DocumentProtocol.addChainHop(table, cluster.getConfigId(), policy, chain);
            }
        }
    }

    private static void addChainHop(RoutingTableSpec table, String configId, String policy, DocprocChain chain) {
        StringBuilder selector = new StringBuilder();
        if (policy != null) {
            selector.append(configId).append("/").append(policy).append("/").append(chain.getSessionName());
        } else {
            selector.append("[LoadBalancer:cluster=").append(configId).append(";session=").append(chain.getSessionName()).append("]");
        }
        table.addHop(new HopSpec(chain.getServiceName(), selector.toString()));
    }

    private static String policy(ContainerDocproc docproc) {
        if (docproc.getNumNodesPerClient() > 0) {
            return "[SubsetService:" + docproc.getNumNodesPerClient() + "]";
        }
        if (docproc.isPreferLocalNode()) {
            return "[LocalService]";
        }
        return null;
    }

    private static void addContentRouting(List<ContentCluster> content, RoutingTableSpec table) {
        for (ContentCluster cluster : content) {
            RouteSpec spec = new RouteSpec(cluster.getConfigId());
            if (cluster.getSearch().hasIndexedCluster()) {
                table.addRoute(spec.addHop("[MessageType:" + cluster.getConfigId() + "]"));
                table.addRoute(new RouteSpec(DocumentProtocol.getIndexedRouteName(cluster.getConfigId())).addHop(cluster.getSearch().getIndexed().getIndexingServiceName()).addHop("[Content:cluster=" + cluster.getName() + "]"));
                table.addRoute(new RouteSpec(DocumentProtocol.getDirectRouteName(cluster.getConfigId())).addHop("[Content:cluster=" + cluster.getName() + "]"));
            } else {
                table.addRoute(spec.addHop("[Content:cluster=" + cluster.getName() + "]"));
            }
            table.addRoute(new RouteSpec("storage/cluster." + cluster.getName()).addHop("route:" + cluster.getConfigId()));
        }
    }

    private static void addIndexingHop(List<ContentCluster> content, RoutingTableSpec table) {
        if (content.isEmpty()) {
            return;
        }
        HopSpec hop = new HopSpec("indexing", "[DocumentRouteSelector]");
        for (ContentCluster cluster : content) {
            hop.addRecipient(cluster.getConfigId());
        }
        if (hop.hasRecipients()) {
            table.addHop(hop);
        }
    }

    private static void addDefaultRoutes(List<ContentCluster> content, Collection<ContainerCluster<?>> containerClusters, RoutingTableSpec table) {
        if (content.isEmpty() || !DocumentProtocol.indexingHopExists(table)) {
            return;
        }
        RouteSpec route = new RouteSpec("default");
        String hop = DocumentProtocol.getContainerClustersDocprocHop(containerClusters);
        if (hop != null) {
            route.addHop(hop);
        }
        route.addHop("indexing");
        table.addRoute(route);
        if (content.size() == 1) {
            table.addRoute(new RouteSpec("default-get").addHop("[Content:cluster=" + content.get(0).getConfigId() + "]"));
        } else {
            table.addRoute(new RouteSpec("default-get").addHop("indexing"));
        }
    }

    private static boolean indexingHopExists(RoutingTableSpec table) {
        int len = table.getNumHops();
        for (int i = 0; i < len; ++i) {
            if (!table.getHop(i).getName().equals("indexing")) continue;
            return true;
        }
        return false;
    }

    private static String getContainerClustersDocprocHop(Collection<ContainerCluster<?>> containerClusters) {
        DocprocChain result = null;
        for (ContainerCluster<?> containerCluster : containerClusters) {
            DocprocChain defaultChain = DocumentProtocol.getDefaultChain(containerCluster.getDocproc());
            if (defaultChain == null) continue;
            if (result != null) {
                throw new RuntimeException("Only a single default docproc chain is allowed across all container clusters");
            }
            result = defaultChain;
        }
        return result == null ? null : result.getServiceName();
    }

    private static DocprocChain getDefaultChain(ContainerDocproc docproc) {
        return docproc == null ? null : (DocprocChain)((DocprocChains)docproc.getChains()).allChains().getComponent("default");
    }

    private static void simplifyRouteNames(RoutingTableSpec table) {
        if (table == null || !table.hasRoutes()) {
            return;
        }
        TreeMap simple = new TreeMap();
        ArrayList<String> broken = new ArrayList<String>();
        int len = table.getNumRoutes();
        for (int i = 0; i < len; ++i) {
            Set<String> l;
            String before = table.getRoute(i).getName();
            String after = DocumentProtocol.simplifyRouteName(before);
            if (simple.containsKey(after)) {
                l = (Set)simple.get(after);
                l.add(before);
                if (l.contains("content/" + after) && l.contains("storage/cluster." + after) && l.size() == 2) continue;
                broken.add(after);
                continue;
            }
            l = new HashSet();
            l.add(before);
            simple.put(after, l);
        }
        HashSet<RouteSpec> alias = new HashSet<RouteSpec>();
        HashSet<String> unique = new HashSet<String>();
        int i = 0;
        while (i < table.getNumRoutes()) {
            String after;
            RouteSpec route = table.getRoute(i);
            String before = route.getName();
            if (!before.equals(after = DocumentProtocol.simplifyRouteName(before)) && !broken.contains(after)) {
                if (route.getNumHops() == 1 && route.getHop(0).equals(route.getName())) {
                    alias.add(new RouteSpec(after).addHop(route.getHop(0)));
                    unique.add(after);
                    table.removeRoute(i);
                    continue;
                }
                if (!unique.contains(after)) {
                    alias.add(new RouteSpec(after).addHop("route:" + before));
                    unique.add(after);
                }
            }
            ++i;
        }
        for (RouteSpec rs : alias) {
            table.addRoute(rs);
        }
    }

    private static String simplifyRouteName(String name) {
        String[] foo = name.split("/", 2);
        if (foo.length < 2) {
            return name;
        }
        String[] bar = foo[1].split("\\.", 2);
        if (bar.length < 2) {
            return foo[1];
        }
        return bar[1];
    }

    @Override
    public ApplicationSpec getApplicationSpec() {
        return this.application;
    }

    @Override
    public RoutingTableSpec getRoutingTableSpec() {
        return this.routingTable;
    }
}

