/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldOperation;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SummaryInFieldLongOperation
extends SummaryInFieldOperation {
    private DataType type;
    private Boolean bold;
    private Set<String> destinations = new LinkedHashSet<String>();
    private List<SummaryField.Property> properties = new ArrayList<SummaryField.Property>();

    public SummaryInFieldLongOperation(String name) {
        super(name);
    }

    public SummaryInFieldLongOperation() {
        super(null);
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public void addDestination(String destination) {
        this.destinations.add(destination);
    }

    public Iterator<String> destinationIterator() {
        return this.destinations.iterator();
    }

    public void addProperty(SummaryField.Property property) {
        this.properties.add(property);
    }

    @Override
    public void apply(SDField field) {
        if (this.type == null) {
            this.type = field.getDataType();
        }
        SummaryField summary = new SummaryField(this.name, this.type);
        this.applyToSummary(summary);
        field.addSummaryField(summary);
    }

    public void applyToSummary(SummaryField summary) {
        if (this.transform != null) {
            summary.setTransform(this.transform);
        }
        if (this.bold != null) {
            summary.setTransform(this.bold != false ? summary.getTransform().bold() : summary.getTransform().unbold());
        }
        for (SummaryField.Source source : this.sources) {
            summary.addSource(source);
        }
        for (String destination : this.destinations) {
            summary.addDestination(destination);
        }
        for (SummaryField.Property prop : this.properties) {
            summary.addProperty(prop.getName(), prop.getValue());
        }
    }
}

