/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.document.BooleanIndexDefinition;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class IndexOperation
implements FieldOperation {
    private String indexName;
    private Optional<Boolean> prefix = Optional.empty();
    private List<String> aliases = new LinkedList<String>();
    private Optional<String> stemming = Optional.empty();
    private Optional<Index.Type> type = Optional.empty();
    private OptionalInt arity = OptionalInt.empty();
    private OptionalLong lowerBound = OptionalLong.empty();
    private OptionalLong upperBound = OptionalLong.empty();
    private OptionalDouble densePostingListThreshold = OptionalDouble.empty();

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public boolean getPrefix() {
        return this.prefix.get();
    }

    public void setPrefix(Boolean prefix) {
        this.prefix = Optional.of(prefix);
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public String getStemming() {
        return this.stemming.get();
    }

    public void setStemming(String stemming) {
        this.stemming = Optional.of(stemming);
    }

    @Override
    public void apply(SDField field) {
        Index index = field.getIndex(this.indexName);
        if (index == null) {
            index = new Index(this.indexName);
            field.addIndex(index);
        }
        this.applyToIndex(index);
    }

    public void applyToIndex(Index index) {
        if (this.prefix.isPresent()) {
            index.setPrefix(this.prefix.get());
        }
        for (String alias : this.aliases) {
            index.addAlias(alias);
        }
        if (this.stemming.isPresent()) {
            index.setStemming(Stemming.get(this.stemming.get()));
        }
        if (this.type.isPresent()) {
            index.setType(this.type.get());
        }
        if (this.arity.isPresent() || this.lowerBound.isPresent() || this.upperBound.isPresent() || this.densePostingListThreshold.isPresent()) {
            index.setBooleanIndexDefiniton(new BooleanIndexDefinition(this.arity, this.lowerBound, this.upperBound, this.densePostingListThreshold));
        }
    }

    public Index.Type getType() {
        return this.type.get();
    }

    public void setType(Index.Type type) {
        this.type = Optional.of(type);
    }

    public void setArity(int arity) {
        this.arity = OptionalInt.of(arity);
    }

    public void setLowerBound(long value) {
        this.lowerBound = OptionalLong.of(value);
    }

    public void setUpperBound(long value) {
        this.upperBound = OptionalLong.of(value);
    }

    public void setDensePostingListThreshold(double densePostingListThreshold) {
        this.densePostingListThreshold = OptionalDouble.of(densePostingListThreshold);
    }
}

