/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.xml.InconsistentSchemaAndCodeError;
import java.util.Optional;
import org.w3c.dom.Element;

public class AccessLogBuilder {
    private static AccessLogComponent.AccessLogType logTypeFor(AccessLogTypeLiteral typeLiteral) {
        switch (typeLiteral) {
            case DISABLED: {
                return null;
            }
            case VESPA: {
                return AccessLogComponent.AccessLogType.queryAccessLog;
            }
            case JSON: {
                return AccessLogComponent.AccessLogType.jsonAccessLog;
            }
        }
        throw new InconsistentSchemaAndCodeError();
    }

    public static Optional<AccessLogComponent> buildIfNotDisabled(DeployState deployState, ContainerCluster<?> cluster, Element accessLogSpec) {
        AccessLogTypeLiteral typeLiteral = XmlHelper.getOptionalAttribute(accessLogSpec, "type").map(AccessLogTypeLiteral::fromAttributeValue).orElse(AccessLogTypeLiteral.JSON);
        AccessLogComponent.AccessLogType logType = AccessLogBuilder.logTypeFor(typeLiteral);
        if (logType == null) {
            return Optional.empty();
        }
        boolean hosted = cluster.isHostedVespa();
        return Optional.of((AccessLogComponent)new DomBuilder(logType, hosted).build(deployState, cluster, accessLogSpec));
    }

    private static class DomBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<AccessLogComponent> {
        private final AccessLogComponent.AccessLogType accessLogType;
        private final boolean isHostedVespa;

        public DomBuilder(AccessLogComponent.AccessLogType accessLogType, boolean isHostedVespa) {
            this.accessLogType = accessLogType;
            this.isHostedVespa = isHostedVespa;
        }

        @Override
        protected AccessLogComponent doBuild(DeployState deployState, AbstractConfigProducer<?> ancestor, Element spec) {
            return new AccessLogComponent((ContainerCluster)ancestor, this.accessLogType, DomBuilder.compressionType(spec, this.isHostedVespa), this.fileNamePattern(spec), this.rotationInterval(spec), this.compressOnRotation(spec), this.isHostedVespa, this.symlinkName(spec));
        }

        private String symlinkName(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("symlinkName"));
        }

        private Boolean compressOnRotation(Element spec) {
            String compress = spec.getAttribute("compressOnRotation");
            return compress.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(compress));
        }

        private String rotationInterval(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("rotationInterval"));
        }

        private String fileNamePattern(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("fileNamePattern"));
        }

        private static AccessLogComponent.CompressionType compressionType(Element spec, boolean isHostedVespa) {
            AccessLogComponent.CompressionType fallback = isHostedVespa ? AccessLogComponent.CompressionType.ZSTD : AccessLogComponent.CompressionType.GZIP;
            return Optional.ofNullable(spec.getAttribute("compressionType")).filter(value -> !value.isBlank()).map(value -> {
                switch (value) {
                    case "gzip": {
                        return AccessLogComponent.CompressionType.GZIP;
                    }
                    case "zstd": {
                        return AccessLogComponent.CompressionType.ZSTD;
                    }
                }
                throw new IllegalArgumentException("Unknown compression type: " + value);
            }).orElse(fallback);
        }
    }

    private static enum AccessLogTypeLiteral {
        VESPA("vespa"),
        JSON("json"),
        DISABLED("disabled");

        final String attributeValue;

        private AccessLogTypeLiteral(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        static AccessLogTypeLiteral fromAttributeValue(String value) {
            return (AccessLogTypeLiteral)((Object)CollectionUtil.firstMatching((Object[])AccessLogTypeLiteral.values(), typeLiteral -> typeLiteral.attributeValue.equals(value)).get());
        }
    }
}

