/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.Zone;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.vespa.config.content.DistributionConfig;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.MessagetyperouteselectorpolicyConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.config.content.core.BucketspacesConfig;
import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerComponent;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerConfigurer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.content.ClusterControllerConfig;
import com.yahoo.vespa.model.content.ClusterResourceLimits;
import com.yahoo.vespa.model.content.ContentSearch;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.DistributionBitCalculator;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.GlobalDistributionValidator;
import com.yahoo.vespa.model.content.IndexedHierarchicDistributionValidator;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.ReservedDocumentTypeNameValidator;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.cluster.DocumentSelectionBuilder;
import com.yahoo.vespa.model.content.cluster.DomContentSearchBuilder;
import com.yahoo.vespa.model.content.cluster.DomDispatchBuilder;
import com.yahoo.vespa.model.content.cluster.DomSearchCoverageBuilder;
import com.yahoo.vespa.model.content.cluster.DomTuningDispatchBuilder;
import com.yahoo.vespa.model.content.cluster.EngineFactoryBuilder;
import com.yahoo.vespa.model.content.cluster.GlobalDistributionBuilder;
import com.yahoo.vespa.model.content.cluster.RedundancyBuilder;
import com.yahoo.vespa.model.content.cluster.SearchDefinitionBuilder;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.content.engines.ProtonEngine;
import com.yahoo.vespa.model.content.storagecluster.StorageCluster;
import com.yahoo.vespa.model.routing.DocumentProtocol;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ContentCluster
extends AbstractConfigProducer
implements DistributionConfig.Producer,
StorDistributionConfig.Producer,
StorDistributormanagerConfig.Producer,
FleetcontrollerConfig.Producer,
MetricsmanagerConfig.Producer,
MessagetyperouteselectorpolicyConfig.Producer,
BucketspacesConfig.Producer {
    private final String documentSelection;
    private ContentSearchCluster search;
    private final boolean isHosted;
    private final Map<String, NewDocumentType> documentDefinitions;
    private final Set<NewDocumentType> globallyDistributedDocuments;
    private StorageGroup rootGroup;
    private StorageCluster storageNodes;
    private DistributorCluster distributorNodes;
    private Redundancy redundancy;
    private ClusterControllerConfig clusterControllerConfig;
    private PersistenceEngine.PersistenceFactory persistenceFactory;
    private final String clusterId;
    private Integer maxNodesPerMerge;
    private final Zone zone;
    private ClusterControllerContainerCluster clusterControllers;
    private DistributionMode distributionMode;
    public static Map<String, Integer> METRIC_INDEX_MAP = new TreeMap<String, Integer>();
    private static final String DEFAULT_BUCKET_SPACE = "default";
    private static final String GLOBAL_BUCKET_SPACE = "global";

    private ContentCluster(AbstractConfigProducer<?> parent, String clusterId, Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, String routingSelection, Zone zone, boolean isHosted) {
        super(parent, clusterId);
        this.isHosted = isHosted;
        this.clusterId = clusterId;
        this.documentDefinitions = documentDefinitions;
        this.globallyDistributedDocuments = globallyDistributedDocuments;
        this.documentSelection = routingSelection;
        this.zone = zone;
    }

    public ClusterSpec.Id id() {
        return ClusterSpec.Id.from((String)this.clusterId);
    }

    public void prepare(DeployState deployState) {
        this.search.prepare();
        if (this.clusterControllers != null) {
            this.clusterControllers.prepare(deployState);
        }
    }

    public ClusterControllerContainerCluster getClusterControllers() {
        return this.clusterControllers;
    }

    public DistributionMode getDistributionMode() {
        if (this.distributionMode != null) {
            return this.distributionMode;
        }
        return this.getPersistence().getDefaultDistributionMode();
    }

    public static String getClusterId(ModelElement clusterElem) {
        String clusterId = clusterElem.stringAttribute("id");
        return clusterId != null ? clusterId : "content";
    }

    public String getName() {
        return this.clusterId;
    }

    public String getRoutingSelector() {
        return this.documentSelection;
    }

    public DistributorCluster getDistributorNodes() {
        return this.distributorNodes;
    }

    public StorageCluster getStorageNodes() {
        return this.storageNodes;
    }

    public ClusterControllerConfig getClusterControllerConfig() {
        return this.clusterControllerConfig;
    }

    public PersistenceEngine.PersistenceFactory getPersistence() {
        return this.persistenceFactory;
    }

    public Map<String, NewDocumentType> getDocumentDefinitions() {
        return this.documentDefinitions;
    }

    public boolean isGloballyDistributed(NewDocumentType docType) {
        return this.globallyDistributedDocuments.contains(docType);
    }

    public final ContentSearchCluster getSearch() {
        return this.search;
    }

    public Redundancy redundancy() {
        return this.redundancy;
    }

    public ContentCluster setRedundancy(Redundancy redundancy) {
        this.redundancy = redundancy;
        return this;
    }

    public void getConfig(MessagetyperouteselectorpolicyConfig.Builder builder) {
        if (!this.getSearch().hasIndexedCluster()) {
            return;
        }
        builder.defaultroute(DocumentProtocol.getDirectRouteName(this.getConfigId())).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100004).name(DocumentProtocol.getIndexedRouteName(this.getConfigId()))).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100005).name(DocumentProtocol.getIndexedRouteName(this.getConfigId()))).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100006).name(DocumentProtocol.getIndexedRouteName(this.getConfigId())));
    }

    public StorageGroup getRootGroup() {
        return this.rootGroup;
    }

    public void getConfig(StorDistributionConfig.Builder builder) {
        if (this.rootGroup != null) {
            builder.group.addAll(this.rootGroup.getGroupStructureConfig());
        }
        if (this.redundancy != null) {
            this.redundancy.getConfig(builder);
        }
        if (this.search.usesHierarchicDistribution()) {
            builder.active_per_leaf_group(true);
        }
    }

    int getNodeCount() {
        return this.storageNodes.getChildren().size();
    }

    int getNodeCountPerGroup() {
        return this.rootGroup != null ? this.getNodeCount() / this.rootGroup.getNumberOfLeafGroups() : this.getNodeCount();
    }

    public void getConfig(FleetcontrollerConfig.Builder builder) {
        builder.ideal_distribution_bits(this.distributionBits());
        if (this.getNodeCount() < 5) {
            builder.min_storage_up_count(1);
            builder.min_distributor_up_ratio(0.0);
            builder.min_storage_up_ratio(0.0);
        }
        builder.cluster_has_global_document_types(!this.globallyDistributedDocuments.isEmpty());
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        builder.minsplitcount(this.distributionBits());
        if (this.maxNodesPerMerge != null) {
            builder.maximum_nodes_per_merge(this.maxNodesPerMerge.intValue());
        }
    }

    public int distributionBits() {
        if (this.zone.environment() == Environment.prod && !this.zone.equals((Object)Zone.defaultZone())) {
            return 16;
        }
        return DistributionBitCalculator.getDistributionBits(this.getNodeCountPerGroup(), this.getDistributionMode());
    }

    public boolean isHosted() {
        return this.isHosted;
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.search.usesHierarchicDistribution() && !this.isHosted) {
            new IndexedHierarchicDistributionValidator(this.search.getClusterName(), this.rootGroup, this.redundancy, this.search.getIndexed().getTuning().dispatch.getDispatchPolicy()).validate();
        }
        new ReservedDocumentTypeNameValidator().validate(this.documentDefinitions);
        new GlobalDistributionValidator().validate(this.documentDefinitions, this.globallyDistributedDocuments);
    }

    public static MetricsmanagerConfig.Consumer.Builder getMetricBuilder(String name, MetricsmanagerConfig.Builder builder) {
        Integer index = METRIC_INDEX_MAP.get(name);
        if (index != null) {
            return (MetricsmanagerConfig.Consumer.Builder)builder.consumer.get(index);
        }
        MetricsmanagerConfig.Consumer.Builder retVal = new MetricsmanagerConfig.Consumer.Builder();
        retVal.name(name);
        builder.consumer(retVal);
        return retVal;
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        Monitoring monitoring = this.getMonitoringService();
        if (monitoring != null) {
            builder.snapshot(new MetricsmanagerConfig.Snapshot.Builder().periods(monitoring.getIntervalSeconds()).periods(Integer.valueOf(300)));
        }
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("status").addedmetrics("*").removedtags("partofsum"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("log").tags("logdefault").removedtags("loadtype"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("yamas").tags("yamasdefault").removedtags("loadtype"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("health"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("fleetcontroller"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("statereporter").addedmetrics("*").removedtags("thread").removedtags("partofsum"));
    }

    private String bucketSpaceOfDocumentType(NewDocumentType docType) {
        return this.isGloballyDistributed(docType) ? GLOBAL_BUCKET_SPACE : DEFAULT_BUCKET_SPACE;
    }

    public AllClustersBucketSpacesConfig.Cluster.Builder clusterBucketSpaceConfigBuilder() {
        AllClustersBucketSpacesConfig.Cluster.Builder builder = new AllClustersBucketSpacesConfig.Cluster.Builder();
        for (NewDocumentType docType : this.getDocumentDefinitions().values()) {
            AllClustersBucketSpacesConfig.Cluster.DocumentType.Builder typeBuilder = new AllClustersBucketSpacesConfig.Cluster.DocumentType.Builder();
            typeBuilder.bucketSpace(this.bucketSpaceOfDocumentType(docType));
            builder.documentType(docType.getName(), typeBuilder);
        }
        return builder;
    }

    public void getConfig(BucketspacesConfig.Builder builder) {
        for (NewDocumentType docType : this.getDocumentDefinitions().values()) {
            BucketspacesConfig.Documenttype.Builder docTypeBuilder = new BucketspacesConfig.Documenttype.Builder();
            docTypeBuilder.name(docType.getName());
            docTypeBuilder.bucketspace(this.bucketSpaceOfDocumentType(docType));
            builder.documenttype(docTypeBuilder);
        }
    }

    public void getConfig(DistributionConfig.Builder builder) {
        DistributionConfig.Cluster.Builder clusterBuilder = new DistributionConfig.Cluster.Builder();
        StorDistributionConfig.Builder storDistributionBuilder = new StorDistributionConfig.Builder();
        this.getConfig(storDistributionBuilder);
        StorDistributionConfig config = storDistributionBuilder.build();
        clusterBuilder.active_per_leaf_group(config.active_per_leaf_group());
        clusterBuilder.ready_copies(config.ready_copies());
        clusterBuilder.redundancy(config.redundancy());
        clusterBuilder.initial_redundancy(config.initial_redundancy());
        for (StorDistributionConfig.Group group : config.group()) {
            DistributionConfig.Cluster.Group.Builder groupBuilder = new DistributionConfig.Cluster.Group.Builder();
            groupBuilder.index(group.index()).name(group.name()).capacity(group.capacity()).partitions(group.partitions());
            for (StorDistributionConfig.Group.Nodes node : group.nodes()) {
                DistributionConfig.Cluster.Group.Nodes.Builder nodesBuilder = new DistributionConfig.Cluster.Group.Nodes.Builder();
                nodesBuilder.index(node.index()).retired(node.retired());
                groupBuilder.nodes(nodesBuilder);
            }
            clusterBuilder.group(groupBuilder);
        }
        builder.cluster(this.getConfigId(), clusterBuilder);
    }

    public void setDeferChangesUntilRestart(boolean deferChangesUntilRestart) {
    }

    static {
        METRIC_INDEX_MAP.put("status", 0);
        METRIC_INDEX_MAP.put("log", 1);
        METRIC_INDEX_MAP.put("yamas", 2);
        METRIC_INDEX_MAP.put("health", 3);
        METRIC_INDEX_MAP.put("fleetcontroller", 4);
        METRIC_INDEX_MAP.put("statereporter", 5);
    }

    public static class Builder {
        private final Admin admin;
        public static final NodeResources clusterControllerResources = new NodeResources(0.5, 2.0, 10.0, 0.3, NodeResources.DiskSpeed.any, NodeResources.StorageType.any);

        public Builder(Admin admin) {
            this.admin = admin;
        }

        public ContentCluster build(Collection<ContainerModel> containers, ConfigModelContext context, Element w3cContentElement) {
            ModelElement experimental;
            ModelElement contentElement = new ModelElement(w3cContentElement);
            DeployState deployState = context.getDeployState();
            ModelElement documentsElement = contentElement.child("documents");
            Map<String, NewDocumentType> documentDefinitions = new SearchDefinitionBuilder().build(deployState.getDocumentModel().getDocumentManager(), documentsElement);
            String routingSelection = new DocumentSelectionBuilder().build(documentsElement);
            RedundancyBuilder redundancyBuilder = new RedundancyBuilder(contentElement);
            Set<NewDocumentType> globallyDistributedDocuments = new GlobalDistributionBuilder(documentDefinitions).build(documentsElement);
            ContentCluster c = new ContentCluster(context.getParentProducer(), ContentCluster.getClusterId(contentElement), documentDefinitions, globallyDistributedDocuments, routingSelection, deployState.zone(), deployState.isHosted());
            boolean enableFeedBlockInDistributor = deployState.getProperties().featureFlags().enableFeedBlockInDistributor();
            ClusterResourceLimits resourceLimits = new ClusterResourceLimits.Builder(enableFeedBlockInDistributor).build(contentElement);
            c.clusterControllerConfig = (ClusterControllerConfig)new ClusterControllerConfig.Builder(ContentCluster.getClusterId(contentElement), contentElement, resourceLimits.getClusterControllerLimits()).build(deployState, c, contentElement.getXml());
            c.search = (ContentSearchCluster)new ContentSearchCluster.Builder(documentDefinitions, globallyDistributedDocuments, this.isCombined(ContentCluster.getClusterId(contentElement), containers), resourceLimits.getContentNodeLimits()).build(deployState, c, contentElement.getXml());
            c.persistenceFactory = new EngineFactoryBuilder().build(contentElement, c);
            c.storageNodes = (StorageCluster)new StorageCluster.Builder().build(deployState, c, w3cContentElement);
            c.distributorNodes = (DistributorCluster)new DistributorCluster.Builder(c).build(deployState, c, w3cContentElement);
            c.rootGroup = new StorageGroup.Builder(contentElement, context).buildRootGroup(deployState, redundancyBuilder, c);
            this.validateThatGroupSiblingsAreUnique(c.clusterId, c.rootGroup);
            c.search.handleRedundancy(c.redundancy);
            this.setupSearchCluster(c.search, contentElement, deployState.getDeployLogger());
            if (c.search.hasIndexedCluster() && !(c.persistenceFactory instanceof ProtonEngine.Factory)) {
                throw new RuntimeException("Indexed search requires proton as engine");
            }
            if (documentsElement != null) {
                ModelElement e = documentsElement.child("document-processing");
                if (e != null) {
                    this.setupDocumentProcessing(c, e);
                }
            } else if (c.persistenceFactory != null) {
                throw new IllegalArgumentException("The specified content engine requires the <documents> element to be specified.");
            }
            ModelElement tuning = contentElement.child("tuning");
            if (tuning != null) {
                this.setupTuning(c, tuning);
            }
            if ((experimental = contentElement.child("experimental")) != null) {
                this.setupExperimental(c, experimental);
            }
            if (context.getParentProducer().getRoot() == null) {
                return c;
            }
            this.addClusterControllers(context, c.rootGroup, contentElement, c.clusterId, c, deployState);
            return c;
        }

        private void setupSearchCluster(ContentSearchCluster csc, ModelElement element, DeployLogger logger) {
            ContentSearch search = DomContentSearchBuilder.build(element);
            Double visibilityDelay = search.getVisibilityDelay();
            if (visibilityDelay != null) {
                csc.setVisibilityDelay(visibilityDelay);
            }
            if (csc.hasIndexedCluster()) {
                this.setupIndexedCluster(csc.getIndexed(), search, element, logger);
            }
        }

        private void setupIndexedCluster(IndexedSearchCluster index, ContentSearch search, ModelElement element, DeployLogger logger) {
            Double queryTimeout = search.getQueryTimeout();
            if (queryTimeout != null) {
                Preconditions.checkState((index.getQueryTimeout() == null ? 1 : 0) != 0, (Object)("In " + index + ": You may not specify query-timeout in both proton and content."));
                index.setQueryTimeout(queryTimeout);
            }
            index.setSearchCoverage(DomSearchCoverageBuilder.build(element));
            index.setDispatchSpec(DomDispatchBuilder.build(element));
            if (index.getTuning() == null) {
                index.setTuning(new Tuning(index));
            }
            index.getTuning().dispatch = DomTuningDispatchBuilder.build(element, logger);
        }

        private void setupDocumentProcessing(ContentCluster c, ModelElement e) {
            String docprocChain;
            String docprocCluster = e.stringAttribute("cluster");
            if (docprocCluster != null) {
                docprocCluster = docprocCluster.trim();
            }
            if (c.getSearch().hasIndexedCluster() && docprocCluster != null && !docprocCluster.isEmpty()) {
                c.getSearch().getIndexed().setIndexingClusterName(docprocCluster);
            }
            if ((docprocChain = e.stringAttribute("chain")) != null) {
                docprocChain = docprocChain.trim();
            }
            if (c.getSearch().hasIndexedCluster() && docprocChain != null && !docprocChain.isEmpty()) {
                c.getSearch().getIndexed().setIndexingChainName(docprocChain);
            }
        }

        private void setupTuning(ContentCluster c, ModelElement tuning) {
            Integer attr;
            ModelElement merges;
            String attr2;
            ModelElement distribution = tuning.child("distribution");
            if (distribution != null && (attr2 = distribution.stringAttribute("type")) != null) {
                if (attr2.toLowerCase().equals("strict")) {
                    c.distributionMode = DistributionMode.STRICT;
                } else if (attr2.toLowerCase().equals("loose")) {
                    c.distributionMode = DistributionMode.LOOSE;
                } else if (attr2.toLowerCase().equals("legacy")) {
                    c.distributionMode = DistributionMode.LEGACY;
                } else {
                    throw new IllegalStateException("Distribution type " + attr2 + " not supported.");
                }
            }
            if ((merges = tuning.child("merges")) != null && (attr = merges.integerAttribute("max-nodes-per-merge")) != null) {
                c.maxNodesPerMerge = attr;
            }
        }

        private boolean isCombined(String clusterId, Collection<ContainerModel> containers) {
            return containers.stream().map(model -> model.getCluster().getHostClusterId()).filter(Optional::isPresent).anyMatch(id -> ((String)id.get()).equals(clusterId));
        }

        private void setupExperimental(ContentCluster cluster, ModelElement experimental) {
        }

        private void validateGroupSiblings(String cluster, StorageGroup group) {
            HashSet<String> siblings = new HashSet<String>();
            for (StorageGroup g : group.getSubgroups()) {
                String name = g.getName();
                if (siblings.contains(name)) {
                    throw new IllegalArgumentException("Cluster '" + cluster + "' has multiple groups with name '" + name + "' in the same subgroup. Group sibling names must be unique.");
                }
                siblings.add(name);
            }
        }

        private void validateThatGroupSiblingsAreUnique(String cluster, StorageGroup group) {
            if (group == null) {
                return;
            }
            this.validateGroupSiblings(cluster, group);
            for (StorageGroup g : group.getSubgroups()) {
                this.validateThatGroupSiblingsAreUnique(cluster, g);
            }
        }

        private void addClusterControllers(ConfigModelContext context, StorageGroup rootGroup, ModelElement contentElement, String contentClusterName, ContentCluster contentCluster, DeployState deployState) {
            ClusterControllerContainerCluster clusterControllers;
            if (this.admin == null) {
                return;
            }
            if (contentCluster.getPersistence() == null) {
                return;
            }
            ContentCluster overlappingCluster = this.findOverlappingCluster(context.getParentProducer().getRoot(), contentCluster);
            if (overlappingCluster != null && overlappingCluster.getClusterControllers() != null) {
                clusterControllers = overlappingCluster.getClusterControllers();
            } else if (this.admin.multitenant()) {
                if (context.properties().dedicatedClusterControllerCluster()) {
                    clusterControllers = this.getDedicatedSharedControllers(contentElement, this.admin, context, deployState);
                } else {
                    contentCluster.clusterControllers = clusterControllers = this.createClusterControllers(new ClusterControllerCluster(contentCluster, "standalone", deployState), this.drawControllerHosts(3, rootGroup), contentClusterName + "-controllers", true, context.getDeployState());
                }
            } else {
                clusterControllers = this.admin.getClusterControllers();
                if (clusterControllers == null) {
                    List<HostResource> hosts = this.admin.getClusterControllerHosts();
                    if (hosts.size() > 1) {
                        context.getDeployState().getDeployLogger().log(Level.INFO, "When having content cluster(s) and more than 1 config server it is recommended to configure cluster controllers explicitly.");
                    }
                    clusterControllers = this.createClusterControllers(this.admin, hosts, "cluster-controllers", false, context.getDeployState());
                    this.admin.setClusterControllers(clusterControllers);
                }
            }
            this.addClusterControllerComponentsForThisCluster(clusterControllers, contentCluster);
            ReindexingContext reindexingContext = clusterControllers.reindexingContext();
            for (NewDocumentType type : contentCluster.documentDefinitions.values()) {
                reindexingContext.addDocumentType(contentCluster.clusterId, type);
            }
        }

        private ContentCluster findOverlappingCluster(AbstractConfigProducerRoot root, ContentCluster contentCluster) {
            for (ContentCluster otherContentCluster : root.getChildrenByTypeRecursive(ContentCluster.class)) {
                if (otherContentCluster == contentCluster || !this.overlaps(contentCluster, otherContentCluster)) continue;
                return otherContentCluster;
            }
            return null;
        }

        private boolean overlaps(ContentCluster c1, ContentCluster c2) {
            Set c2Hosts;
            Set c1Hosts = c1.getRootGroup().recursiveGetNodes().stream().map(AbstractService::getHostResource).collect(Collectors.toSet());
            return !Sets.intersection(c1Hosts, c2Hosts = c2.getRootGroup().recursiveGetNodes().stream().map(AbstractService::getHostResource).collect(Collectors.toSet())).isEmpty();
        }

        private ClusterControllerContainerCluster getDedicatedSharedControllers(ModelElement contentElement, Admin admin, ConfigModelContext context, DeployState deployState) {
            if (admin.getClusterControllers() == null) {
                NodesSpecification spec = NodesSpecification.requiredFromSharedParents(deployState.zone().environment().isProduction() ? 3 : 1, deployState.featureFlags().dedicatedClusterControllerFlavor().orElse(clusterControllerResources), contentElement, context);
                Set<HostResource> hosts = spec.provision(admin.hostSystem(), ClusterSpec.Type.admin, ClusterSpec.Id.from((String)"cluster-controllers"), context.getDeployLogger(), true).keySet();
                admin.setClusterControllers(this.createClusterControllers(new ClusterControllerCluster(admin, "standalone", deployState), hosts, "cluster-controllers", true, context.getDeployState()));
            }
            return admin.getClusterControllers();
        }

        private List<HostResource> drawControllerHosts(int count, StorageGroup rootGroup) {
            List<HostResource> hosts = this.drawControllerHosts(count, false, rootGroup);
            List<HostResource> retiredHosts = this.drawControllerHosts(count, true, rootGroup);
            ArrayList<HostResource> all = new ArrayList<HostResource>(hosts);
            all.addAll(retiredHosts);
            return all;
        }

        private List<HostResource> drawControllerHosts(int count, boolean retired, StorageGroup rootGroup) {
            List<HostResource> hosts = this.drawContentHostsRecursively(count, retired, rootGroup);
            if (hosts.size() % 2 == 0 && !hosts.isEmpty()) {
                hosts = hosts.subList(0, hosts.size() - 1);
            }
            return hosts;
        }

        private List<HostResource> drawContentHostsRecursively(int count, boolean retired, StorageGroup group) {
            HashSet<HostResource> hosts = new HashSet<HostResource>();
            if (group.getNodes().isEmpty()) {
                int hostsPerSubgroup = (int)Math.ceil((double)count / (double)group.getSubgroups().size());
                for (StorageGroup subgroup : group.getSubgroups()) {
                    hosts.addAll(this.drawContentHostsRecursively(hostsPerSubgroup, retired, subgroup));
                }
            } else {
                hosts.addAll(group.getNodes().stream().filter(node -> node.isRetired() == retired).map(AbstractService::getHostResource).collect(Collectors.toList()));
            }
            ArrayList<HostResource> sortedHosts = new ArrayList(hosts);
            sortedHosts.sort(HostResource::comparePrimarilyByIndexTo);
            sortedHosts = sortedHosts.subList(0, Math.min(count, hosts.size()));
            return sortedHosts;
        }

        private ClusterControllerContainerCluster createClusterControllers(AbstractConfigProducer<?> parent, Collection<HostResource> hosts, String name, boolean multitenant, DeployState deployState) {
            ClusterControllerContainerCluster clusterControllers = new ClusterControllerContainerCluster(parent, name, name, deployState);
            ArrayList<ClusterControllerContainer> containers = new ArrayList<ClusterControllerContainer>();
            if (clusterControllers.getContainers().isEmpty()) {
                int index = 0;
                for (HostResource host : hosts) {
                    int ccIndex = deployState.getProperties().dedicatedClusterControllerCluster() ? host.spec().membership().map(ClusterMembership::index).orElse(index) : index;
                    boolean retired = host.spec().membership().map(ClusterMembership::retired).orElse(false);
                    ClusterControllerContainer clusterControllerContainer = new ClusterControllerContainer(clusterControllers, ccIndex, multitenant, deployState, retired);
                    clusterControllerContainer.setHostResource(host);
                    clusterControllerContainer.initService(deployState.getDeployLogger());
                    clusterControllerContainer.setProp("clustertype", "admin");
                    containers.add(clusterControllerContainer);
                    ++index;
                }
            }
            clusterControllers.addContainers(containers);
            return clusterControllers;
        }

        private void addClusterControllerComponentsForThisCluster(ClusterControllerContainerCluster clusterControllers, ContentCluster contentCluster) {
            int index = 0;
            for (ClusterControllerContainer container : clusterControllers.getContainers()) {
                if (!this.hasClusterControllerComponent(container)) {
                    container.addComponent(new ClusterControllerComponent());
                }
                container.addComponent(new ClusterControllerConfigurer(contentCluster, index++, clusterControllers.getContainers().size()));
            }
        }

        private boolean hasClusterControllerComponent(Container container) {
            for (Object o : container.getComponents().getComponents()) {
                if (!(o instanceof ClusterControllerComponent)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum DistributionMode {
        LEGACY,
        STRICT,
        LOOSE;

    }
}

