/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.Dictionary;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DictionaryProcessor
extends Processor {
    public DictionaryProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            Dictionary dictionary = field.getDictionary();
            if (dictionary == null) continue;
            Attribute attribute = field.getAttribute();
            if (attribute.getDataType().getPrimitiveType() instanceof NumericDataType) {
                if (attribute.isFastSearch()) {
                    attribute.setDictionary(dictionary);
                    continue;
                }
                this.fail(this.search, field, "You must specify 'attribute:fast-search' to allow dictionary control");
                continue;
            }
            this.fail(this.search, field, "You can only specify 'dictionary:' for numeric fields");
        }
    }
}

