/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties,
ModelContext.FeatureFlags {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private boolean hostedVespa = false;
    private Zone zone;
    private final Set<ContainerEndpoint> endpoints = Collections.emptySet();
    private boolean useDedicatedNodeForLogserver = false;
    private boolean dedicatedClusterControllerCluster = true;
    private boolean useThreePhaseUpdates = false;
    private double defaultTermwiseLimit = 1.0;
    private String jvmGCOptions = null;
    private String sequencerType = "LATENCY";
    private String responseSequencerType = "ADAPTIVE";
    private int responseNumThreads = 2;
    private int maxPendingMoveOps = 10;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;
    private ApplicationRoles applicationRoles;
    private Quota quota = Quota.unlimited();
    private boolean useAccessControlTlsHandshakeClientAuth;
    private boolean useAsyncMessageHandlingOnSchedule = false;
    private double feedConcurrency = 0.5;
    private boolean useBucketExecutorForLidSpaceCompact;
    private boolean useBucketExecutorForBucketMove;
    private boolean enableFeedBlockInDistributor = true;
    private double maxDeadBytesRatio = 0.2;
    private int clusterControllerMaxHeapSizeInMb = 256;
    private int metricsProxyMaxHeapSizeInMb = 256;
    private int maxActivationInhibitedOutOfSyncGroups = 0;
    private List<TenantSecretStore> tenantSecretStores = Collections.emptyList();
    private String jvmOmitStackTraceInFastThrowOption;

    public ModelContext.FeatureFlags featureFlags() {
        return this;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return null;
    }

    public URI ztsUrl() {
        return null;
    }

    public String athenzDnsSuffix() {
        return null;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
        return this.jvmGCOptions;
    }

    public String feedSequencerType() {
        return this.sequencerType;
    }

    public boolean isBootstrap() {
        return false;
    }

    public boolean isFirstTimeDeployment() {
        return false;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public boolean dedicatedClusterControllerCluster() {
        return this.hostedVespa && this.dedicatedClusterControllerCluster;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public double defaultTermwiseLimit() {
        return this.defaultTermwiseLimit;
    }

    public boolean useThreePhaseUpdates() {
        return this.useThreePhaseUpdates;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public Optional<ApplicationRoles> applicationRoles() {
        return Optional.ofNullable(this.applicationRoles);
    }

    public String responseSequencerType() {
        return this.responseSequencerType;
    }

    public int defaultNumResponseThreads() {
        return this.responseNumThreads;
    }

    public int maxPendingMoveOps() {
        return this.maxPendingMoveOps;
    }

    public boolean skipCommunicationManagerThread() {
        return false;
    }

    public boolean skipMbusRequestThread() {
        return false;
    }

    public boolean skipMbusReplyThread() {
        return false;
    }

    public Quota quota() {
        return this.quota;
    }

    public boolean useAccessControlTlsHandshakeClientAuth() {
        return this.useAccessControlTlsHandshakeClientAuth;
    }

    public boolean useAsyncMessageHandlingOnSchedule() {
        return this.useAsyncMessageHandlingOnSchedule;
    }

    public double feedConcurrency() {
        return this.feedConcurrency;
    }

    public boolean useBucketExecutorForLidSpaceCompact() {
        return this.useBucketExecutorForLidSpaceCompact;
    }

    public boolean useBucketExecutorForBucketMove() {
        return this.useBucketExecutorForBucketMove;
    }

    public boolean enableFeedBlockInDistributor() {
        return this.enableFeedBlockInDistributor;
    }

    public double maxDeadBytesRatio() {
        return this.maxDeadBytesRatio;
    }

    public int clusterControllerMaxHeapSizeInMb() {
        return this.clusterControllerMaxHeapSizeInMb;
    }

    public int metricsProxyMaxHeapSizeInMb(ClusterSpec.Type type) {
        return this.metricsProxyMaxHeapSizeInMb;
    }

    public int maxActivationInhibitedOutOfSyncGroups() {
        return this.maxActivationInhibitedOutOfSyncGroups;
    }

    public List<TenantSecretStore> tenantSecretStores() {
        return this.tenantSecretStores;
    }

    public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
        return this.jvmOmitStackTraceInFastThrowOption;
    }

    public TestProperties setFeedConcurrency(double feedConcurrency) {
        this.feedConcurrency = feedConcurrency;
        return this;
    }

    public TestProperties setAsyncMessageHandlingOnSchedule(boolean value) {
        this.useAsyncMessageHandlingOnSchedule = value;
        return this;
    }

    public TestProperties setJvmGCOptions(String gcOptions) {
        this.jvmGCOptions = gcOptions;
        return this;
    }

    public TestProperties setFeedSequencerType(String type) {
        this.sequencerType = type;
        return this;
    }

    public TestProperties setResponseSequencerType(String type) {
        this.responseSequencerType = type;
        return this;
    }

    public TestProperties setResponseNumThreads(int numThreads) {
        this.responseNumThreads = numThreads;
        return this;
    }

    public TestProperties setMaxPendingMoveOps(int moveOps) {
        this.maxPendingMoveOps = moveOps;
        return this;
    }

    public TestProperties setDefaultTermwiseLimit(double limit) {
        this.defaultTermwiseLimit = limit;
        return this;
    }

    public TestProperties setUseThreePhaseUpdates(boolean useThreePhaseUpdates) {
        this.useThreePhaseUpdates = useThreePhaseUpdates;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setDedicatedClusterControllerCluster(boolean dedicatedClusterControllerCluster) {
        this.dedicatedClusterControllerCluster = dedicatedClusterControllerCluster;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public TestProperties setApplicationRoles(ApplicationRoles applicationRoles) {
        this.applicationRoles = applicationRoles;
        return this;
    }

    public TestProperties setQuota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public TestProperties useAccessControlTlsHandshakeClientAuth(boolean useAccessControlTlsHandshakeClientAuth) {
        this.useAccessControlTlsHandshakeClientAuth = useAccessControlTlsHandshakeClientAuth;
        return this;
    }

    public TestProperties useBucketExecutorForLidSpaceCompact(boolean enabled) {
        this.useBucketExecutorForLidSpaceCompact = enabled;
        return this;
    }

    public TestProperties useBucketExecutorForBucketMove(boolean enabled) {
        this.useBucketExecutorForBucketMove = enabled;
        return this;
    }

    public TestProperties enableFeedBlockInDistributor(boolean enabled) {
        this.enableFeedBlockInDistributor = enabled;
        return this;
    }

    public TestProperties maxDeadBytesRatio(double ratio) {
        this.maxDeadBytesRatio = ratio;
        return this;
    }

    public TestProperties clusterControllerMaxHeapSizeInMb(int heapSize) {
        this.clusterControllerMaxHeapSizeInMb = heapSize;
        return this;
    }

    public TestProperties metricsProxyMaxHeapSizeInMb(int heapSize) {
        this.metricsProxyMaxHeapSizeInMb = heapSize;
        return this;
    }

    public TestProperties maxActivationInhibitedOutOfSyncGroups(int nGroups) {
        this.maxActivationInhibitedOutOfSyncGroups = nGroups;
        return this;
    }

    public TestProperties setTenantSecretStores(List<TenantSecretStore> secretStores) {
        this.tenantSecretStores = List.copyOf(secretStores);
        return this;
    }

    public TestProperties setJvmOmitStackTraceInFastThrowOption(String value) {
        this.jvmOmitStackTraceInFastThrowOption = value;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

