/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.search.RpcResourcePoolComponent;
import com.yahoo.vespa.model.search.IndexedSearchCluster;

public class DispatcherComponent
extends Component<AbstractConfigProducer<?>, ComponentModel>
implements DispatchConfig.Producer {
    private final IndexedSearchCluster indexedSearchCluster;

    public DispatcherComponent(IndexedSearchCluster indexedSearchCluster) {
        super(DispatcherComponent.toComponentModel(indexedSearchCluster));
        this.indexedSearchCluster = indexedSearchCluster;
        String clusterName = indexedSearchCluster.getClusterName();
        RpcResourcePoolComponent rpcResoucePool = new RpcResourcePoolComponent(clusterName);
        this.inject(rpcResoucePool);
        this.addComponent(rpcResoucePool);
    }

    private static ComponentModel toComponentModel(IndexedSearchCluster indexedSearchCluster) {
        String dispatcherComponentId = "dispatcher." + indexedSearchCluster.getClusterName();
        return new ComponentModel(dispatcherComponentId, Dispatcher.class.getName(), "container-search-and-docproc");
    }

    public void getConfig(DispatchConfig.Builder builder) {
        this.indexedSearchCluster.getConfig(builder);
    }
}

