/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ComplexAttributeFieldsValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        List<AbstractSearchCluster> searchClusters = model.getSearchClusters();
        for (AbstractSearchCluster cluster : searchClusters) {
            if (cluster.isStreaming()) continue;
            SearchCluster searchCluster = (SearchCluster)cluster;
            for (AbstractSearchCluster.SchemaSpec spec : searchCluster.getLocalSDS()) {
                ComplexAttributeFieldsValidator.validateComplexFields(searchCluster.getClusterName(), spec.getSearchDefinition().getSearch());
            }
        }
    }

    private static void validateComplexFields(String clusterName, Search search) {
        String unsupportedFields = search.allFields().filter(field -> ComplexAttributeFieldsValidator.isUnsupportedComplexField(field)).map(ComplexAttributeFieldsValidator::toString).collect(Collectors.joining(", "));
        if (!unsupportedFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("For cluster '%s', search '%s': The following complex fields do not support using struct field attributes: %s. Only supported for the following complex field types: array or map of struct with primitive types, map of primitive types", clusterName, search.getName(), unsupportedFields));
        }
    }

    private static boolean isUnsupportedComplexField(ImmutableSDField field) {
        return field.usesStructOrMap() && !ComplexAttributeFieldsValidator.isSupportedComplexField(field) && ComplexAttributeFieldsValidator.hasStructFieldAttributes(field.getStructFields());
    }

    private static boolean isSupportedComplexField(ImmutableSDField field) {
        return ComplexAttributeFieldUtils.isSupportedComplexField(field) || field.getDataType().equals((Object)PositionDataType.INSTANCE) || field.getDataType().equals((Object)DataType.getArray((DataType)PositionDataType.INSTANCE));
    }

    private static String toString(ImmutableSDField field) {
        return field.getName() + " (" + String.join((CharSequence)", ", ComplexAttributeFieldsValidator.getStructFieldAttributes(field.getStructFields(), false)) + ")";
    }

    private static boolean hasStructFieldAttributes(Collection<? extends ImmutableSDField> structFields) {
        return !ComplexAttributeFieldsValidator.getStructFieldAttributes(structFields, true).isEmpty();
    }

    private static List<String> getStructFieldAttributes(Collection<? extends ImmutableSDField> structFields, boolean returnAllTypes) {
        ArrayList<String> result = new ArrayList<String>();
        for (ImmutableSDField immutableSDField : structFields) {
            for (Attribute attr : immutableSDField.getAttributes().values()) {
                if (!returnAllTypes && ComplexAttributeFieldUtils.isPrimitiveType(attr)) continue;
                result.add(attr.getName());
            }
            if (immutableSDField.usesStructOrMap() && immutableSDField.wasConfiguredToDoAttributing()) {
                result.add(immutableSDField.getName());
            }
            result.addAll(ComplexAttributeFieldsValidator.getStructFieldAttributes(immutableSDField.getStructFields(), returnAllTypes));
        }
        return result;
    }
}

