/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.NormalizeLevel;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class FieldSetSettings
extends Processor {
    public FieldSetSettings(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (FieldSet fieldSet : this.search.fieldSets().userFieldSets().values()) {
            if (validate) {
                this.checkFieldNames(this.search, fieldSet);
            }
            this.checkMatching(this.search, fieldSet);
            this.checkNormalization(this.search, fieldSet);
            this.checkStemming(this.search, fieldSet);
        }
    }

    private void checkFieldNames(Search search, FieldSet fieldSet) {
        for (String field : fieldSet.getFieldNames()) {
            if (search.getField(field) != null) continue;
            throw new IllegalArgumentException("For search '" + search.getName() + "': Field '" + field + "' in " + fieldSet + " does not exist.");
        }
    }

    private void checkMatching(Search search, FieldSet fieldSet) {
        Matching matching = fieldSet.getMatching();
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = search.getField(fieldName);
            Matching fieldMatching = field.getMatching();
            if (matching == null) {
                matching = fieldMatching;
                continue;
            }
            if (matching.equals(fieldMatching)) continue;
            this.warn(search, field.asField(), "The matching settings for the fields in " + fieldSet + " are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
        fieldSet.setMatching(matching);
    }

    private void checkNormalization(Search search, FieldSet fieldSet) {
        NormalizeLevel.Level normalizing = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = search.getField(fieldName);
            NormalizeLevel.Level fieldNorm = field.getNormalizing().getLevel();
            if (normalizing == null) {
                normalizing = fieldNorm;
                continue;
            }
            if (normalizing.equals((Object)fieldNorm)) continue;
            this.warn(search, field.asField(), "The normalization settings for the fields in " + fieldSet + " are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
    }

    private void checkStemming(Search search, FieldSet fieldSet) {
        Stemming stemming = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = search.getField(fieldName);
            Stemming fieldStemming = field.getStemming();
            if (stemming == null) {
                stemming = fieldStemming;
                continue;
            }
            if (stemming.equals((Object)fieldStemming)) continue;
            this.warn(search, field.asField(), "The stemming settings for the fields in the fieldset '" + fieldSet.getName() + "' are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
    }
}

