/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Float16FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.vespa.documentmodel.SummaryTransform;

public class SummaryClassField {
    private final String name;
    private final Type type;

    public SummaryClassField(String name, DataType type, SummaryTransform transform) {
        this.name = name;
        this.type = SummaryClassField.convertDataType(type, transform);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public static Type convertDataType(DataType fieldType, SummaryTransform transform) {
        FieldValue fval = fieldType.createFieldValue();
        if (fval instanceof StringFieldValue) {
            if (transform != null && transform.equals((Object)SummaryTransform.RANKFEATURES)) {
                return Type.FEATUREDATA;
            }
            if (transform != null && transform.equals((Object)SummaryTransform.SUMMARYFEATURES)) {
                return Type.FEATUREDATA;
            }
            return Type.LONGSTRING;
        }
        if (fval instanceof IntegerFieldValue) {
            return Type.INTEGER;
        }
        if (fval instanceof LongFieldValue) {
            return Type.INT64;
        }
        if (fval instanceof Float16FieldValue) {
            return Type.FLOAT16;
        }
        if (fval instanceof FloatFieldValue) {
            return Type.FLOAT;
        }
        if (fval instanceof DoubleFieldValue) {
            return Type.DOUBLE;
        }
        if (fval instanceof BoolFieldValue) {
            return Type.BOOL;
        }
        if (fval instanceof ByteFieldValue) {
            return Type.BYTE;
        }
        if (fval instanceof Raw) {
            return Type.DATA;
        }
        if (fval instanceof Struct) {
            return Type.JSONSTRING;
        }
        if (fval instanceof PredicateFieldValue) {
            return Type.STRING;
        }
        if (fval instanceof TensorFieldValue) {
            return Type.TENSOR;
        }
        if (fieldType instanceof CollectionDataType) {
            if (transform != null && transform.equals((Object)SummaryTransform.POSITIONS)) {
                return Type.XMLSTRING;
            }
            return Type.JSONSTRING;
        }
        if (fieldType instanceof MapDataType) {
            return Type.JSONSTRING;
        }
        if (fieldType instanceof ReferenceDataType) {
            return Type.LONGSTRING;
        }
        throw new IllegalArgumentException("Don't know which summary type to convert " + fieldType + " to");
    }

    public String toString() {
        return "summary class field " + this.name;
    }

    public static enum Type {
        BOOL("bool"),
        BYTE("byte"),
        SHORT("short"),
        INTEGER("integer"),
        INT64("int64"),
        FLOAT16("float16"),
        FLOAT("float"),
        DOUBLE("double"),
        STRING("string"),
        DATA("data"),
        LONGSTRING("longstring"),
        LONGDATA("longdata"),
        XMLSTRING("xmlstring"),
        FEATUREDATA("featuredata"),
        JSONSTRING("jsonstring"),
        TENSOR("tensor");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "type: " + this.name;
        }
    }
}

