/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.OnnxModels;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.RawRankProfile;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RankProfileList
extends Derived
implements RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
OnnxModelsConfig.Producer {
    private static final Logger log = Logger.getLogger(RankProfileList.class.getName());
    private final Map<String, RawRankProfile> rankProfiles = new LinkedHashMap<String, RawRankProfile>();
    private final RankingConstants rankingConstants;
    private final OnnxModels onnxModels;
    public static RankProfileList empty = new RankProfileList();

    private RankProfileList() {
        this.rankingConstants = new RankingConstants();
        this.onnxModels = new OnnxModels();
    }

    public RankProfileList(Search search, RankingConstants rankingConstants, AttributeFields attributeFields, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, ModelContext.Properties deployProperties) {
        this.setName(search == null ? "default" : search.getName());
        this.rankingConstants = rankingConstants;
        this.deriveRankProfiles(rankProfileRegistry, queryProfiles, importedModels, search, attributeFields, deployProperties);
        this.onnxModels = search == null ? new OnnxModels() : search.onnxModels();
    }

    private void deriveRankProfiles(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, Search search, AttributeFields attributeFields, ModelContext.Properties deployProperties) {
        if (search != null) {
            RawRankProfile defaultProfile = new RawRankProfile(rankProfileRegistry.get(search, "default"), queryProfiles, importedModels, attributeFields, deployProperties);
            this.rankProfiles.put(defaultProfile.getName(), defaultProfile);
        }
        for (RankProfile rank : rankProfileRegistry.rankProfilesOf(search)) {
            if (search != null && "default".equals(rank.getName())) continue;
            RawRankProfile rawRank = new RawRankProfile(rank, queryProfiles, importedModels, attributeFields, deployProperties);
            this.rankProfiles.put(rawRank.getName(), rawRank);
        }
    }

    public Map<String, RawRankProfile> getRankProfiles() {
        return this.rankProfiles;
    }

    public RawRankProfile getRankProfile(String name) {
        return this.rankProfiles.get(name);
    }

    public void sendConstantsTo(Collection<? extends AbstractService> services) {
        this.rankingConstants.sendTo(services);
    }

    @Override
    public String getDerivedName() {
        return "rank-profiles";
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        for (RawRankProfile rank : this.rankProfiles.values()) {
            rank.getConfig(builder);
        }
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        for (RankingConstant constant : this.rankingConstants.asMap().values()) {
            if ("".equals(constant.getFileReference())) {
                log.warning("Illegal file reference " + constant);
                continue;
            }
            builder.constant(new RankingConstantsConfig.Constant.Builder().name(constant.getName()).fileref(constant.getFileReference()).type(constant.getType()));
        }
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        for (OnnxModel model : this.onnxModels.asMap().values()) {
            if ("".equals(model.getFileReference())) {
                log.warning("Illegal file reference " + model);
                continue;
            }
            OnnxModelsConfig.Model.Builder modelBuilder = new OnnxModelsConfig.Model.Builder();
            modelBuilder.name(model.getName());
            modelBuilder.fileref(model.getFileReference());
            model.getInputMap().forEach((name, source) -> modelBuilder.input(new OnnxModelsConfig.Model.Input.Builder().name(name).source(source)));
            model.getOutputMap().forEach((name, as) -> modelBuilder.output(new OnnxModelsConfig.Model.Output.Builder().name(name).as(as)));
            builder.model(modelBuilder);
        }
    }
}

