/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.engines.DummyPersistence;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.content.engines.ProtonEngine;

public class EngineFactoryBuilder {
    public PersistenceEngine.PersistenceFactory build(ModelElement clusterElem, ContentCluster c) {
        ModelElement persistence = clusterElem.getChild("engine");
        if (persistence != null) {
            if (c.getSearch().hasIndexedCluster() && persistence.getChild("proton") == null) {
                throw new IllegalArgumentException("Persistence engine does not allow for indexed search. Please use <proton> as your engine.");
            }
            if (persistence.getChild("proton") != null) {
                return new ProtonEngine.Factory(c.getSearch());
            }
            if (persistence.getChild("dummy") != null) {
                return new DummyPersistence.Factory();
            }
        }
        return new ProtonEngine.Factory(c.getSearch());
    }
}

