/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.cluster.DomResourceLimitsBuilder;
import java.util.Optional;
import java.util.function.Consumer;

public class ClusterResourceLimits {
    private final ResourceLimits clusterControllerLimits;
    private final ResourceLimits contentNodeLimits;

    private ClusterResourceLimits(Builder builder) {
        this.clusterControllerLimits = builder.ctrlBuilder.build();
        this.contentNodeLimits = builder.nodeBuilder.build();
    }

    public ResourceLimits getClusterControllerLimits() {
        return this.clusterControllerLimits;
    }

    public ResourceLimits getContentNodeLimits() {
        return this.contentNodeLimits;
    }

    public static class Builder {
        private final boolean enableFeedBlockInDistributor;
        private ResourceLimits.Builder ctrlBuilder = new ResourceLimits.Builder();
        private ResourceLimits.Builder nodeBuilder = new ResourceLimits.Builder();

        public Builder(boolean enableFeedBlockInDistributor) {
            this.enableFeedBlockInDistributor = enableFeedBlockInDistributor;
        }

        public ClusterResourceLimits build(ModelElement clusterElem) {
            ModelElement protonElem;
            ModelElement tuningElem = clusterElem.childByPath("tuning");
            if (tuningElem != null) {
                this.ctrlBuilder = DomResourceLimitsBuilder.createBuilder(tuningElem);
            }
            if ((protonElem = clusterElem.childByPath("engine.proton")) != null) {
                this.nodeBuilder = DomResourceLimitsBuilder.createBuilder(protonElem);
            }
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        public void setClusterControllerBuilder(ResourceLimits.Builder builder) {
            this.ctrlBuilder = builder;
        }

        public void setContentNodeBuilder(ResourceLimits.Builder builder) {
            this.nodeBuilder = builder;
        }

        public ClusterResourceLimits build() {
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        private void deriveLimits() {
            if (this.enableFeedBlockInDistributor) {
                this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit);
                this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit);
            }
            this.deriveClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit);
            this.deriveClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getDiskLimit(), this.ctrlBuilder.getDiskLimit(), this.nodeBuilder::setDiskLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder::setMemoryLimit);
        }

        private void considerSettingDefaultClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter) {
            if (!clusterControllerLimit.isPresent() && !contentNodeLimit.isPresent()) {
                setter.accept(0.8);
            }
        }

        private void deriveClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter) {
            if (!clusterControllerLimit.isPresent()) {
                contentNodeLimit.ifPresent(limit -> setter.accept(Double.max(0.0, limit - 0.01)));
            }
        }

        private void deriveContentNodeLimit(Optional<Double> contentNodeLimit, Optional<Double> clusterControllerLimit, Consumer<Double> setter) {
            if (!contentNodeLimit.isPresent()) {
                clusterControllerLimit.ifPresent(limit -> setter.accept(this.calcContentNodeLimit((double)limit)));
            }
        }

        private double calcContentNodeLimit(double clusterControllerLimit) {
            return clusterControllerLimit + (1.0 - clusterControllerLimit) / 2.0;
        }
    }
}

