/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.http.metrics.MetricsV2Handler;
import ai.vespa.metricsproxy.http.metrics.NodeInfoConfig;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensionsConfig;
import ai.vespa.metricsproxy.rpc.RpcConnector;
import ai.vespa.metricsproxy.rpc.RpcConnectorConfig;
import ai.vespa.metricsproxy.service.VespaServices;
import ai.vespa.metricsproxy.service.VespaServicesConfig;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainerCluster;
import com.yahoo.vespa.model.admin.metricsproxy.VespaServicesConfigGenerator;
import com.yahoo.vespa.model.container.Container;
import java.util.LinkedHashMap;
import java.util.Optional;

public class MetricsProxyContainer
extends Container
implements NodeDimensionsConfig.Producer,
NodeInfoConfig.Producer,
RpcConnectorConfig.Producer,
VespaServicesConfig.Producer,
QrStartConfig.Producer {
    public static final int BASEPORT = 19092;
    final boolean isHostedVespa;
    private final Optional<ClusterMembership> clusterMembership;
    private final ModelContext.FeatureFlags featureFlags;
    private final MetricsProxyContainerCluster cluster;
    private int metricsRpcPort;

    public MetricsProxyContainer(MetricsProxyContainerCluster cluster, HostResource host, int index, DeployState deployState) {
        super(cluster, host.getHostname(), index, deployState.isHosted());
        this.isHostedVespa = deployState.isHosted();
        this.clusterMembership = host.spec().membership();
        this.featureFlags = deployState.featureFlags();
        this.cluster = cluster;
        this.setProp("clustertype", "admin");
        this.setProp("index", String.valueOf(index));
        this.addNodeSpecificComponents();
    }

    private void addNodeSpecificComponents() {
        this.addMetricsProxyComponent(NodeDimensions.class);
        this.addMetricsProxyComponent(RpcConnector.class);
        this.addMetricsProxyComponent(VespaServices.class);
        this.addHandler(MetricsProxyContainerCluster.createMetricsHandler(MetricsV2Handler.class, "/metrics/v2"));
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.METRICS_PROXY_CONTAINER;
    }

    @Override
    public int getWantedPort() {
        return 19092;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            start = 19092;
        }
        if (this.getHttp() != null) {
            throw new IllegalArgumentException("unexpected HTTP setup");
        }
        this.allocatedSearchPort = from.wantPort(start++, "http");
        this.portsMeta.on(0).tag("http").tag("query").tag("external").tag("state");
        from.wantPort(start++, "http/1");
        this.portsMeta.on(1).tag("unused");
        if (this.numMessageBusPorts() != 0) {
            throw new IllegalArgumentException("expecting 0 message bus ports");
        }
        if (this.numRpcPorts() != 1) {
            throw new IllegalArgumentException("expecting 1 rpc port");
        }
        this.allocatedRpcPort = from.wantPort(start++, "rpc/admin");
        this.portsMeta.on(2).tag("rpc").tag("admin");
        this.metricsRpcPort = from.wantPort(start++, "rpc/metrics");
        this.portsMeta.on(3).tag("rpc").tag("metrics");
    }

    @Override
    public int getPortCount() {
        return 4;
    }

    public void getConfig(RpcConnectorConfig.Builder builder) {
        builder.port(this.metricsRpcPort);
    }

    public void getConfig(VespaServicesConfig.Builder builder) {
        builder.service.addAll(VespaServicesConfigGenerator.generate(this.getHostResource().getServices()));
    }

    public void getConfig(NodeDimensionsConfig.Builder builder) {
        LinkedHashMap dimensions = new LinkedHashMap();
        if (this.isHostedVespa) {
            this.getHostResource().spec().membership().map(ClusterMembership::cluster).ifPresent(cluster -> {
                dimensions.put("clustertype", cluster.type().name());
                dimensions.put("clusterid", cluster.id().value());
            });
            builder.dimensions(dimensions);
        }
    }

    public void getConfig(NodeInfoConfig.Builder builder) {
        builder.role(this.getNodeRole()).hostname(this.getHostName());
    }

    public void getConfig(QrStartConfig.Builder builder) {
        this.cluster.getConfig(builder);
        if (this.clusterMembership.isPresent()) {
            int maxHeapSize = this.featureFlags.metricsProxyMaxHeapSizeInMb(this.clusterMembership.get().cluster().type());
            boolean verboseGc = maxHeapSize < 512;
            builder.jvm.verbosegc(verboseGc).heapsize(maxHeapSize);
        }
    }

    private String getNodeRole() {
        String hostConfigId = this.getHost().getHost().getConfigId();
        if (!this.isHostedVespa) {
            return hostConfigId;
        }
        return this.getHostResource().spec().membership().map(ClusterMembership::stringValue).orElse(hostConfigId);
    }

    private void addMetricsProxyComponent(Class<?> componentClass) {
        this.addSimpleComponent(componentClass.getName(), null, "com.yahoo.vespa.metrics-proxy");
    }

    @Override
    protected String defaultPreload() {
        return "";
    }
}

