/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.cloud.config.log.LogdConfig;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.ConfigProxy;
import com.yahoo.vespa.model.ConfigSentinel;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.Logd;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.LogForwarder;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.LogserverContainerCluster;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.admin.ZooKeepersConfigProvider;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainer;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainerCluster;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Admin
extends AbstractConfigProducer<Admin>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isHostedVespa;
    private final Monitoring monitoring;
    private final List<Configserver> configservers = new ArrayList<Configserver>();
    private final Metrics metrics;
    private MetricsProxyContainerCluster metricsProxyCluster;
    private MetricSet additionalDefaultMetrics = MetricSet.empty();
    private final List<Slobrok> slobroks = new ArrayList<Slobrok>();
    private Configserver defaultConfigserver;
    private Logserver logserver;
    private LogForwarder.Config logForwarderConfig = null;
    private ConfigModelContext.ApplicationType applicationType = ConfigModelContext.ApplicationType.DEFAULT;
    private ClusterControllerContainerCluster clusterControllers;
    private Optional<LogserverContainerCluster> logServerContainerCluster = Optional.empty();
    private ZooKeepersConfigProvider zooKeepersConfigProvider;
    private final FileDistributionConfigProducer fileDistribution;
    private final boolean multitenant;

    public void setLogForwarderConfig(LogForwarder.Config cfg) {
        this.logForwarderConfig = cfg;
    }

    public Admin(AbstractConfigProducer parent, Monitoring monitoring, Metrics metrics, boolean multitenant, FileDistributionConfigProducer fileDistributionConfigProducer, boolean isHostedVespa) {
        super(parent, "admin");
        this.isHostedVespa = isHostedVespa;
        this.monitoring = monitoring;
        this.metrics = metrics;
        this.multitenant = multitenant;
        this.fileDistribution = fileDistributionConfigProducer;
    }

    public Configserver getConfigserver() {
        return this.defaultConfigserver;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public Metrics getUserMetrics() {
        return this.metrics;
    }

    public MetricsProxyContainerCluster getMetricsProxyCluster() {
        return this.metricsProxyCluster;
    }

    public void setAdditionalDefaultMetrics(MetricSet additionalDefaultMetrics) {
        if (additionalDefaultMetrics == null) {
            return;
        }
        this.additionalDefaultMetrics = additionalDefaultMetrics;
    }

    public MetricSet getAdditionalDefaultMetrics() {
        return this.additionalDefaultMetrics;
    }

    public List<Configserver> getConfigservers() {
        return this.configservers;
    }

    public List<Slobrok> getSlobroks() {
        return Collections.unmodifiableList(this.slobroks);
    }

    public void setLogserver(Logserver logserver) {
        this.logserver = logserver;
    }

    public Logserver getLogserver() {
        return this.logserver;
    }

    public void addConfigservers(List<Configserver> configservers) {
        this.configservers.addAll(configservers);
        if (this.configservers.size() > 0) {
            this.defaultConfigserver = configservers.get(0);
        }
        this.zooKeepersConfigProvider = new ZooKeepersConfigProvider(configservers);
    }

    public void addSlobroks(List<Slobrok> slobroks) {
        this.slobroks.addAll(slobroks);
    }

    public ClusterControllerContainerCluster getClusterControllers() {
        return this.clusterControllers;
    }

    public void setClusterControllers(ClusterControllerContainerCluster clusterControllers) {
        this.clusterControllers = clusterControllers;
    }

    public Optional<LogserverContainerCluster> getLogServerContainerCluster() {
        return this.logServerContainerCluster;
    }

    public void setLogserverContainerCluster(LogserverContainerCluster logServerContainerCluster) {
        this.logServerContainerCluster = Optional.of(logServerContainerCluster);
    }

    public ZooKeepersConfigProvider getZooKeepersConfigProvider() {
        return this.zooKeepersConfigProvider;
    }

    public void getConfig(LogdConfig.Builder builder) {
        if (this.logserver == null) {
            builder.logserver(new LogdConfig.Logserver.Builder().use(false));
        } else {
            builder.logserver(new LogdConfig.Logserver.Builder().userpc(true).use(this.logServerContainerCluster.isPresent() || !this.isHostedVespa).host(this.logserver.getHostName()).rpcport(this.logserver.getRelativePort(0)));
        }
    }

    public void getConfig(SlobroksConfig.Builder builder) {
        for (Slobrok slob : this.slobroks) {
            builder.slobrok(new SlobroksConfig.Slobrok.Builder().connectionspec(slob.getConnectionSpec()));
        }
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        this.zooKeepersConfigProvider.getConfig(builder);
    }

    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return this.fileDistribution;
    }

    public List<HostResource> getClusterControllerHosts() {
        ArrayList<HostResource> hosts = new ArrayList<HostResource>();
        if (this.multitenant) {
            if (this.logserver != null) {
                hosts.add(this.logserver.getHostResource());
            }
        } else {
            for (Configserver configserver : this.getConfigservers()) {
                hosts.add(configserver.getHostResource());
            }
        }
        return hosts;
    }

    public void addPerHostServices(List<HostResource> hosts, DeployState deployState) {
        if (this.slobroks.isEmpty()) {
            this.slobroks.addAll(this.createDefaultSlobrokSetup(deployState.getDeployLogger()));
        }
        this.addMetricsProxyCluster(hosts, deployState);
        for (HostResource host : hosts) {
            if (host.getHost().runsConfigServer()) continue;
            this.addCommonServices(host, deployState);
        }
    }

    private void addMetricsProxyCluster(List<HostResource> hosts, DeployState deployState) {
        this.metricsProxyCluster = new MetricsProxyContainerCluster(this, "metrics", deployState);
        int index = 0;
        for (HostResource host : hosts) {
            MetricsProxyContainer container = new MetricsProxyContainer(this.metricsProxyCluster, host, index, deployState);
            this.addAndInitializeService(deployState.getDeployLogger(), host, container);
            this.metricsProxyCluster.addContainer(container);
        }
    }

    private void addCommonServices(HostResource host, DeployState deployState) {
        this.addConfigSentinel(deployState.getDeployLogger(), host, deployState.getProperties().applicationId(), deployState.zone());
        this.addLogd(deployState.getDeployLogger(), host);
        this.addConfigProxy(deployState.getDeployLogger(), host);
        this.addFileDistribution(host);
        if (this.logForwarderConfig != null) {
            this.addLogForwarder(deployState.getDeployLogger(), host);
        }
    }

    private void addConfigSentinel(DeployLogger deployLogger, HostResource host, ApplicationId applicationId, Zone zone) {
        ConfigSentinel configSentinel = new ConfigSentinel(host.getHost(), applicationId, zone);
        this.addAndInitializeService(deployLogger, host, configSentinel);
        host.getHost().setConfigSentinel(configSentinel);
    }

    private void addLogForwarder(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new LogForwarder((AbstractConfigProducer)host.getHost(), this.logForwarderConfig));
    }

    private void addLogd(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new Logd(host.getHost()));
    }

    private void addConfigProxy(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new ConfigProxy(host.getHost()));
    }

    public void addAndInitializeService(DeployLogger deployLogger, HostResource host, AbstractService service) {
        service.setHostResource(host);
        service.initService(deployLogger);
    }

    private void addFileDistribution(HostResource host) {
        FileDistributor fileDistributor = this.fileDistribution.getFileDistributor();
        HostResource hostResource = this.hostSystem().getHostByHostname(fileDistributor.fileSourceHost());
        if (hostResource == null && !this.multitenant) {
            throw new IllegalArgumentException("Could not find " + fileDistributor.fileSourceHost() + " in the application's " + this.hostSystem());
        }
        FileDistributionConfigProvider configProvider = new FileDistributionConfigProvider(this.fileDistribution, fileDistributor, host == hostResource, host.getHost());
        this.fileDistribution.addFileDistributionConfigProducer(host.getHost(), configProvider);
    }

    private List<Slobrok> createDefaultSlobrokSetup(DeployLogger deployLogger) {
        List<HostResource> hosts = this.hostSystem().getHosts();
        ArrayList<Slobrok> slobs = new ArrayList<Slobrok>();
        if (this.logserver != null) {
            Slobrok slobrok = new Slobrok((AbstractConfigProducer)this, 0);
            this.addAndInitializeService(deployLogger, this.logserver.getHostResource(), slobrok);
            slobs.add(slobrok);
        }
        for (int n = 0; n < hosts.size() && slobs.size() < 3; ++n) {
            HostResource host = hosts.get(n);
            if (this.logserver != null && host == this.logserver.getHostResource() || host.getHost().runsConfigServer()) continue;
            Slobrok newSlobrok = new Slobrok((AbstractConfigProducer)this, slobs.size());
            this.addAndInitializeService(deployLogger, host, newSlobrok);
            slobs.add(newSlobrok);
        }
        int j = 0;
        for (Slobrok s : slobs) {
            s.setProp("index", j);
            ++j;
        }
        return slobs;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public void setApplicationType(ConfigModelContext.ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public ConfigModelContext.ApplicationType getApplicationType() {
        return this.applicationType;
    }
}

