/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.NormalizeLevel;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.Ranking;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.document.TypedKey;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;
import com.yahoo.searchdefinition.fieldoperation.FieldOperationContainer;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ExpressionSearcher;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.LowerCaseExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class SDField
extends Field
implements TypedKey,
FieldOperationContainer,
ImmutableSDField {
    private boolean indexStructureField = false;
    private ScriptExpression indexingScript = new ScriptExpression();
    private RankType rankType = RankType.DEFAULT;
    private final Ranking ranking = new Ranking();
    private int literalBoost = -1;
    private int weight = 100;
    private Matching matching = new Matching();
    private final Map<String, Attribute> attributes = new TreeMap<String, Attribute>();
    private Stemming stemming = null;
    private NormalizeLevel normalizing = new NormalizeLevel();
    private final List<String> queryCommands = new ArrayList<String>(0);
    private final Map<String, SummaryField> summaryFields = new LinkedHashMap<String, SummaryField>(0);
    private final Map<String, Index> indices = new LinkedHashMap<String, Index>();
    private boolean idOverride = false;
    private final Map<String, SDField> structFields = new LinkedHashMap<String, SDField>(0);
    private SDDocumentType ownerDocType = null;
    private final Map<String, String> aliasToName = new HashMap<String, String>();
    private final List<FieldOperation> pendingOperations = new LinkedList<FieldOperation>();
    private boolean isExtraField = false;
    private boolean wasConfiguredToDoAttributing = false;

    protected SDField(SDDocumentType repo, String name, int id, DataType dataType, boolean populate) {
        super(name, id, dataType);
        this.populate(populate, repo, name, dataType);
    }

    public SDField(SDDocumentType repo, String name, int id, DataType dataType) {
        this(repo, name, id, dataType, true);
    }

    public SDField(SDDocumentType repo, String name, DataType dataType, boolean populate) {
        super(name, dataType);
        this.populate(populate, repo, name, dataType);
    }

    protected SDField(SDDocumentType repo, String name, DataType dataType, SDDocumentType owner, boolean populate) {
        super(name, dataType, owner == null ? null : owner.getDocumentType());
        this.ownerDocType = owner;
        this.populate(populate, repo, name, dataType);
    }

    protected SDField(SDDocumentType repo, String name, DataType dataType, SDDocumentType owner, Matching fieldMatching, boolean populate, int recursion) {
        super(name, dataType, owner == null ? null : owner.getDocumentType());
        this.ownerDocType = owner;
        if (fieldMatching != null) {
            this.setMatching(fieldMatching);
        }
        this.populate(populate, repo, name, dataType, fieldMatching, recursion);
    }

    public SDField(SDDocumentType repo, String name, DataType dataType) {
        this(repo, name, dataType, true);
    }

    public SDField(String name, DataType dataType) {
        this(null, name, dataType);
    }

    private void populate(boolean populate, SDDocumentType repo, String name, DataType dataType) {
        this.populate(populate, repo, name, dataType, null, 0);
    }

    private void populate(boolean populate, SDDocumentType repo, String name, DataType dataType, Matching fieldMatching, int recursion) {
        if (dataType instanceof TensorDataType) {
            TensorType type = ((TensorDataType)dataType).getTensorType();
            if (type.dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
                throw new IllegalArgumentException("Illegal type in field " + name + " type " + type + ": Dense tensor dimensions must have a size");
            }
            this.addQueryCommand("type " + type);
        } else {
            this.addQueryCommand("type " + dataType.getName());
        }
        if (populate || dataType instanceof MapDataType) {
            this.populateWithStructFields(repo, name, dataType, recursion);
            this.populateWithStructMatching(repo, name, dataType, fieldMatching);
        }
    }

    public void setIsExtraField(boolean isExtra) {
        this.isExtraField = isExtra;
    }

    @Override
    public boolean isExtraField() {
        return this.isExtraField;
    }

    @Override
    public boolean isImportedField() {
        return false;
    }

    @Override
    public boolean doesAttributing() {
        return this.containsExpression(AttributeExpression.class);
    }

    @Override
    public boolean doesIndexing() {
        return this.containsExpression(IndexExpression.class);
    }

    public boolean doesSummarying() {
        if (this.usesStruct()) {
            for (SDField structField : this.getStructFields()) {
                if (!structField.doesSummarying()) continue;
                return true;
            }
        }
        return this.containsExpression(SummaryExpression.class);
    }

    @Override
    public boolean doesLowerCasing() {
        return this.containsExpression(LowerCaseExpression.class);
    }

    @Override
    public <T extends Expression> boolean containsExpression(Class<T> searchFor) {
        return this.findExpression(searchFor) != null;
    }

    private <T extends Expression> T findExpression(Class<T> searchFor) {
        return (T)new ExpressionSearcher(searchFor).searchIn((Expression)this.indexingScript);
    }

    public void addSummaryFieldSources(SummaryField summaryField) {
        if (this.usesStruct()) {
            for (SDField structField : this.getStructFields()) {
                for (SummaryField sumF : structField.getSummaryFields().values()) {
                    for (String dest : sumF.getDestinations()) {
                        summaryField.addDestination(dest);
                    }
                }
                structField.addSummaryFieldSources(summaryField);
            }
        } else if (this.doesSummarying()) {
            summaryField.addSource(this.getName());
        }
    }

    public void populateWithStructFields(SDDocumentType sdoc, String name, DataType dataType, int recursion) {
        DataType dt = this.getFirstStructOrMapRecursive();
        if (dt == null) {
            return;
        }
        if (dataType instanceof MapDataType) {
            MapDataType mdt = (MapDataType)dataType;
            SDField keyField = new SDField(sdoc, name.concat(".key"), mdt.getKeyType(), this.getOwnerDocType(), new Matching(), true, recursion + 1);
            this.structFields.put("key", keyField);
            SDField valueField = new SDField(sdoc, name.concat(".value"), mdt.getValueType(), this.getOwnerDocType(), new Matching(), true, recursion + 1);
            this.structFields.put("value", valueField);
        } else {
            if (recursion >= 10) {
                return;
            }
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getNestedType();
            }
            if (dataType instanceof StructDataType) {
                SDDocumentType subType;
                SDDocumentType sDDocumentType = subType = sdoc != null ? sdoc.getType(dataType.getName()) : null;
                if (subType == null) {
                    throw new IllegalArgumentException("Could not find struct '" + dataType.getName() + "'.");
                }
                for (Field field : subType.fieldSet()) {
                    SDField subField = new SDField(sdoc, name.concat(".").concat(field.getName()), field.getDataType(), subType, new Matching(), true, recursion + 1);
                    this.structFields.put(field.getName(), subField);
                }
            }
        }
    }

    public void populateWithStructMatching(SDDocumentType sdoc, String name, DataType dataType, Matching superFieldMatching) {
        DataType dt = this.getFirstStructOrMapRecursive();
        if (dt == null) {
            return;
        }
        if (dataType instanceof MapDataType) {
            SDField valueField;
            SDField keyField;
            MapDataType mdt = (MapDataType)dataType;
            Matching keyFieldMatching = new Matching();
            if (superFieldMatching != null) {
                keyFieldMatching.merge(superFieldMatching);
            }
            if ((keyField = this.structFields.get(name.concat(".key"))) != null) {
                keyField.populateWithStructMatching(sdoc, name.concat(".key"), mdt.getKeyType(), keyFieldMatching);
                keyField.setMatching(keyFieldMatching);
            }
            Matching valueFieldMatching = new Matching();
            if (superFieldMatching != null) {
                valueFieldMatching.merge(superFieldMatching);
            }
            if ((valueField = this.structFields.get(name.concat(".value"))) != null) {
                valueField.populateWithStructMatching(sdoc, name.concat(".value"), mdt.getValueType(), valueFieldMatching);
                valueField.setMatching(valueFieldMatching);
            }
        } else {
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getNestedType();
            }
            if (dataType instanceof StructDataType) {
                SDDocumentType subType;
                SDDocumentType sDDocumentType = subType = sdoc != null ? sdoc.getType(dataType.getName()) : null;
                if (subType != null) {
                    for (Field f : subType.fieldSet()) {
                        if (f instanceof SDField) {
                            SDField field = (SDField)f;
                            Matching subFieldMatching = new Matching();
                            if (superFieldMatching != null) {
                                subFieldMatching.merge(superFieldMatching);
                            }
                            subFieldMatching.merge(field.getMatching());
                            SDField subField = this.structFields.get(field.getName());
                            if (subField == null) continue;
                            subField.populateWithStructMatching(sdoc, name.concat(".").concat(field.getName()), field.getDataType(), subFieldMatching);
                            subField.setMatching(subFieldMatching);
                            continue;
                        }
                        throw new IllegalArgumentException("Field in struct is not SDField " + f.getName());
                    }
                } else {
                    throw new IllegalArgumentException("Could not find struct " + dataType.getName());
                }
            }
        }
    }

    @Override
    public void addOperation(FieldOperation op) {
        this.pendingOperations.add(op);
    }

    @Override
    public void applyOperations(SDField field) {
        if (this.pendingOperations.isEmpty()) {
            return;
        }
        Collections.sort(this.pendingOperations);
        ListIterator<FieldOperation> ops = this.pendingOperations.listIterator();
        while (ops.hasNext()) {
            FieldOperation op = ops.next();
            ops.remove();
            op.apply(field);
        }
    }

    public void applyOperations() {
        this.applyOperations(this);
    }

    public void setId(int fieldId, DocumentType owner) {
        super.setId(fieldId, owner);
        this.idOverride = true;
    }

    public StructDataType getFirstStructRecursive() {
        DataType dataType = this.getDataType();
        while (true) {
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getNestedType();
                continue;
            }
            if (!(dataType instanceof MapDataType)) break;
            dataType = ((MapDataType)dataType).getValueType();
        }
        return dataType instanceof StructDataType ? (StructDataType)dataType : null;
    }

    private DataType getFirstStructOrMapRecursive() {
        DataType dataType = this.getDataType();
        while (dataType instanceof CollectionDataType) {
            dataType = ((CollectionDataType)dataType).getNestedType();
        }
        return dataType instanceof StructDataType || dataType instanceof MapDataType ? dataType : null;
    }

    private boolean usesStruct() {
        StructDataType dt = this.getFirstStructRecursive();
        return dt != null;
    }

    @Override
    public boolean usesStructOrMap() {
        DataType dt = this.getFirstStructOrMapRecursive();
        return dt != null;
    }

    @Override
    public boolean wasConfiguredToDoAttributing() {
        return this.wasConfiguredToDoAttributing;
    }

    public void parseIndexingScript(String script) {
        this.parseIndexingScript(script, (Linguistics)new SimpleLinguistics());
    }

    public void parseIndexingScript(String script, Linguistics linguistics) {
        try {
            ScriptParserContext config = new ScriptParserContext(linguistics);
            config.setInputStream((CharStream)new IndexingInput(script));
            this.setIndexingScript(ScriptExpression.newInstance((ScriptParserContext)config));
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parser script '" + script + "'.", e);
        }
    }

    public void setIndexingScript(ScriptExpression exp) {
        if (exp == null) {
            exp = new ScriptExpression();
        }
        this.indexingScript = exp;
        if (this.indexingScript.isEmpty()) {
            return;
        }
        if (!this.wasConfiguredToDoAttributing()) {
            this.wasConfiguredToDoAttributing = this.doesAttributing();
        }
        if (!this.usesStructOrMap()) {
            new ExpressionVisitor(){

                protected void doVisit(Expression exp) {
                    Attribute attribute;
                    if (!(exp instanceof AttributeExpression)) {
                        return;
                    }
                    String fieldName = ((AttributeExpression)exp).getFieldName();
                    if (fieldName == null) {
                        fieldName = SDField.this.getName();
                    }
                    if ((attribute = SDField.this.attributes.get(fieldName)) == null) {
                        SDField.this.addAttribute(new Attribute(fieldName, SDField.this.getDataType()));
                    }
                }
            }.visit((Expression)this.indexingScript);
        }
        for (SDField structField : this.getStructFields()) {
            structField.setIndexingScript(exp);
        }
    }

    @Override
    public ScriptExpression getIndexingScript() {
        return this.indexingScript;
    }

    @Override
    public void setDataType(DataType type) {
        if (type.equals((Object)DataType.URI)) {
            this.normalizing.inferLowercase();
            this.stemming = Stemming.NONE;
        }
        this.dataType = type;
        if (!this.idOverride) {
            this.fieldId = this.calculateIdV7(null);
        }
    }

    @Override
    public boolean isIndexStructureField() {
        return this.indexStructureField;
    }

    public void setIndexStructureField(boolean indexStructureField) {
        this.indexStructureField = indexStructureField;
    }

    @Override
    public boolean hasIndex() {
        return this.getIndexingScript() != null && this.doesIndexing();
    }

    public void setLiteralBoost(int literalBoost) {
        this.literalBoost = literalBoost;
    }

    @Override
    public int getLiteralBoost() {
        return this.literalBoost;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Matching getMatching() {
        return this.matching;
    }

    public void setMatching(Matching matching) {
        this.matching = matching;
    }

    public void setMatchingType(Matching.Type type) {
        this.getMatching().setType(type);
        for (SDField structField : this.getStructFields()) {
            structField.setMatchingType(type);
        }
    }

    public void setMatchingAlgorithm(Matching.Algorithm algorithm) {
        this.getMatching().setAlgorithm(algorithm);
        for (SDField structField : this.getStructFields()) {
            structField.getMatching().setAlgorithm(algorithm);
        }
    }

    public void addIndex(Index index) {
        this.indices.put(index.getName(), index);
    }

    @Override
    public Index getIndex(String name) {
        return this.indices.get(name);
    }

    @Override
    public boolean existsIndex(String name) {
        if (this.indices.get(name) != null) {
            return true;
        }
        return name.equals(this.getName()) && this.doesIndexing();
    }

    @Override
    public Map<String, Index> getIndices() {
        return this.indices;
    }

    public void setRankType(RankType rankType) {
        this.rankType = rankType;
        for (Index index : this.getIndices().values()) {
            if (index.getRankType() != null) continue;
            index.setRankType(rankType);
        }
    }

    @Override
    public Ranking getRanking() {
        return this.ranking;
    }

    @Override
    public RankType getRankType() {
        return this.rankType;
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Attribute getAttribute() {
        return this.attributes.get(this.getName());
    }

    public void addAttribute(Attribute attribute) {
        String name = attribute.getName();
        if (name == null || "".equals(name)) {
            name = this.getName();
            attribute.setName(name);
        }
        this.attributes.put(attribute.getName(), attribute);
    }

    @Override
    public Stemming getStemming() {
        return this.stemming;
    }

    @Override
    public Stemming getStemming(Search search) {
        if (this.stemming != null) {
            return this.stemming;
        }
        return search.getStemming();
    }

    @Override
    public Field asField() {
        return this;
    }

    public void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    @Override
    public Map<String, SummaryField> getSummaryFields() {
        return Collections.unmodifiableMap(this.summaryFields);
    }

    public void removeSummaryFields() {
        this.summaryFields.clear();
    }

    public void addSummaryField(SummaryField summaryField) {
        this.summaryFields.put(summaryField.getName(), summaryField);
    }

    @Override
    public SummaryField getSummaryField(String name) {
        return this.summaryFields.get(name);
    }

    public SummaryField getSummaryField(String name, boolean create) {
        SummaryField summaryField = this.summaryFields.get(name);
        if (summaryField == null && create) {
            summaryField = new SummaryField(name, this.getDataType());
            this.addSummaryField(summaryField);
        }
        return this.summaryFields.get(name);
    }

    public Collection<SDField> getStructFields() {
        return this.structFields.values();
    }

    @Override
    public SDField getStructField(String name) {
        if (name.contains(".")) {
            String superFieldName = name.substring(0, name.indexOf("."));
            String subFieldName = name.substring(name.indexOf(".") + 1);
            SDField superField = this.structFields.get(superFieldName);
            if (superField != null) {
                return superField.getStructField(subFieldName);
            }
            return null;
        }
        return this.structFields.get(name);
    }

    @Override
    public NormalizeLevel getNormalizing() {
        return this.normalizing;
    }

    public void setNormalizing(NormalizeLevel level) {
        this.normalizing = level;
    }

    public void addQueryCommand(String name) {
        this.queryCommands.add(name);
    }

    public boolean hasQueryCommand(String name) {
        return this.queryCommands.contains(name);
    }

    @Override
    public List<String> getQueryCommands() {
        return this.queryCommands;
    }

    private SDDocumentType getOwnerDocType() {
        return this.ownerDocType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SDField)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "field '" + this.getName() + "'";
    }

    @Override
    public Map<String, String> getAliasToName() {
        return this.aliasToName;
    }

    @Override
    public boolean hasFullIndexingDocprocRights() {
        Attribute self = this.getAttributes().get(this.getName());
        return !this.isExtraField() || self != null && self.isMutable();
    }
}

