/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.IndexSchema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.HnswIndexParams;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AttributeChangeValidator {
    private final ClusterSpec.Id id;
    private final AttributeFields currentFields;
    private final IndexSchema currentIndexSchema;
    private final NewDocumentType currentDocType;
    private final AttributeFields nextFields;
    private final IndexSchema nextIndexSchema;
    private final NewDocumentType nextDocType;

    public AttributeChangeValidator(ClusterSpec.Id id, AttributeFields currentFields, IndexSchema currentIndexSchema, NewDocumentType currentDocType, AttributeFields nextFields, IndexSchema nextIndexSchema, NewDocumentType nextDocType) {
        this.id = id;
        this.currentFields = currentFields;
        this.currentIndexSchema = currentIndexSchema;
        this.currentDocType = currentDocType;
        this.nextFields = nextFields;
        this.nextIndexSchema = nextIndexSchema;
        this.nextDocType = nextDocType;
    }

    public List<VespaConfigChangeAction> validate() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAddAttributeAspect());
        result.addAll(this.validateRemoveAttributeAspect());
        result.addAll(this.validateAttributeSettings());
        return result;
    }

    private List<VespaConfigChangeAction> validateAddAttributeAspect() {
        return this.nextFields.attributes().stream().map(attr -> attr.getName()).filter(attrName -> !this.currentFields.containsAttribute((String)attrName) && this.currentDocType.containsField((String)attrName)).map(attrName -> new VespaRestartAction(this.id, new ChangeMessageBuilder((String)attrName).addChange("add attribute aspect").build())).collect(Collectors.toList());
    }

    private List<VespaConfigChangeAction> validateRemoveAttributeAspect() {
        return this.currentFields.attributes().stream().map(attr -> attr.getName()).filter(attrName -> !this.nextFields.containsAttribute((String)attrName) && this.nextDocType.containsField((String)attrName) && !this.isIndexField((String)attrName)).map(attrName -> new VespaRestartAction(this.id, new ChangeMessageBuilder((String)attrName).addChange("remove attribute aspect").build())).collect(Collectors.toList());
    }

    private boolean isIndexField(String fieldName) {
        return this.currentIndexSchema.containsField(fieldName) && this.nextIndexSchema.containsField(fieldName);
    }

    private static boolean hasHnswIndex(Attribute attribute) {
        return attribute.hnswIndexParams().isPresent();
    }

    private List<VespaConfigChangeAction> validateAttributeSettings() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Attribute nextAttr : this.nextFields.attributes()) {
            Attribute currAttr = this.currentFields.getAttribute(nextAttr.getName());
            if (currAttr == null) continue;
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::isFastSearch, "fast-search", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::isFastAccess, "fast-access", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::isHuge, "huge", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::densePostingListThreshold, "dense-posting-list-threshold", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::isEnabledOnlyBitVector, "rank: filter", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, AttributeChangeValidator::hasHnswIndex, "indexing: index", result);
            AttributeChangeValidator.validateAttributeSetting(this.id, currAttr, nextAttr, Attribute::distanceMetric, "distance-metric", result);
            if (!AttributeChangeValidator.hasHnswIndex(currAttr) || !AttributeChangeValidator.hasHnswIndex(nextAttr)) continue;
            AttributeChangeValidator.validateAttributeHnswIndexSetting(this.id, currAttr, nextAttr, HnswIndexParams::maxLinksPerNode, "max-links-per-node", result);
            AttributeChangeValidator.validateAttributeHnswIndexSetting(this.id, currAttr, nextAttr, HnswIndexParams::neighborsToExploreAtInsert, "neighbors-to-explore-at-insert", result);
        }
        return result;
    }

    private static void validateAttributeSetting(ClusterSpec.Id id, Attribute currentAttr, Attribute nextAttr, Predicate<Attribute> predicate, String setting, List<VespaConfigChangeAction> result) {
        boolean nextValue = predicate.test(nextAttr);
        if (predicate.test(currentAttr) != nextValue) {
            String change = nextValue ? "add" : "remove";
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(nextAttr.getName()).addChange(change + " attribute '" + setting + "'").build()));
        }
    }

    private static <T> void validateAttributeSetting(ClusterSpec.Id id, Attribute currentAttr, Attribute nextAttr, Function<Attribute, T> settingValueProvider, String setting, List<VespaConfigChangeAction> result) {
        T nextValue;
        T currentValue = settingValueProvider.apply(currentAttr);
        if (!Objects.equals(currentValue, nextValue = settingValueProvider.apply(nextAttr))) {
            String message = String.format("change property '%s' from '%s' to '%s'", setting, currentValue, nextValue);
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(nextAttr.getName()).addChange(message).build()));
        }
    }

    private static <T> void validateAttributeHnswIndexSetting(ClusterSpec.Id id, Attribute currentAttr, Attribute nextAttr, Function<HnswIndexParams, T> settingValueProvider, String setting, List<VespaConfigChangeAction> result) {
        T nextValue;
        T currentValue = settingValueProvider.apply(currentAttr.hnswIndexParams().get());
        if (!Objects.equals(currentValue, nextValue = settingValueProvider.apply(nextAttr.hnswIndexParams().get()))) {
            String message = String.format("change hnsw index property '%s' from '%s' to '%s'", setting, currentValue, nextValue);
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(nextAttr.getName()).addChange(message).build()));
        }
    }
}

