/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JettyHttpServer
extends SimpleComponent
implements ServerConfig.Producer {
    private final ContainerCluster<?> cluster;
    private volatile boolean isHostedVespa;
    private final List<ConnectorFactory> connectorFactories = new ArrayList<ConnectorFactory>();

    public JettyHttpServer(ComponentId id, ContainerCluster<?> cluster, boolean isHostedVespa) {
        super(new ComponentModel(new BundleInstantiationSpecification(id, ComponentSpecification.fromString((String)"com.yahoo.jdisc.http.server.jetty.JettyHttpServer"), ComponentSpecification.fromString((String)"jdisc_http_service"))));
        this.isHostedVespa = isHostedVespa;
        this.cluster = cluster;
        FilterBindingsProviderComponent filterBindingsProviderComponent = new FilterBindingsProviderComponent(id);
        this.addChild(filterBindingsProviderComponent);
        this.inject(filterBindingsProviderComponent);
    }

    public void setHostedVespa(boolean isHostedVespa) {
        this.isHostedVespa = isHostedVespa;
    }

    public void addConnector(ConnectorFactory connectorFactory) {
        this.connectorFactories.add(connectorFactory);
        this.addChild(connectorFactory);
    }

    public List<ConnectorFactory> getConnectorFactories() {
        return Collections.unmodifiableList(this.connectorFactories);
    }

    public void getConfig(ServerConfig.Builder builder) {
        builder.metric(new ServerConfig.Metric.Builder().monitoringHandlerPaths(List.of("/state/v1", "/status.html")).searchHandlerPaths(List.of("/search")));
        if (this.isHostedVespa) {
            builder.accessLog(new ServerConfig.AccessLog.Builder().remoteAddressHeaders(List.of()).remotePortHeaders(List.of()));
            builder.connectionLog(new ServerConfig.ConnectionLog.Builder().enabled(true));
        } else {
            builder.accessLog(new ServerConfig.AccessLog.Builder().remoteAddressHeaders(List.of("x-forwarded-for", "y-ra", "yahooremoteip", "client-ip")).remotePortHeaders(List.of("X-Forwarded-Port", "y-rp")));
        }
        this.configureJettyThreadpool(builder);
    }

    private void configureJettyThreadpool(ServerConfig.Builder builder) {
        if (this.cluster == null) {
            return;
        }
        if (this.cluster instanceof ApplicationContainerCluster) {
            this.configureApplicationClusterJettyThreadPool(builder);
        } else {
            builder.minWorkerThreads(2).maxWorkerThreads(4);
        }
    }

    private void configureApplicationClusterJettyThreadPool(ServerConfig.Builder builder) {
        double vcpu = this.cluster.vcpu().orElse(0.0);
        if (vcpu > 0.0) {
            int threads = 16 + (int)Math.ceil(vcpu);
            builder.minWorkerThreads(threads).maxWorkerThreads(threads);
        }
    }

    static ComponentModel providerComponentModel(ComponentId parentId, String className) {
        ComponentSpecification classNameSpec = new ComponentSpecification(className);
        return new ComponentModel(new BundleInstantiationSpecification(classNameSpec.nestInNamespace(parentId), classNameSpec, null));
    }

    public static final class FilterBindingsProviderComponent
    extends SimpleComponent {
        public FilterBindingsProviderComponent(ComponentId parentId) {
            super(JettyHttpServer.providerComponentModel(parentId, "com.yahoo.container.jdisc.FilterBindingsProvider"));
        }
    }
}

