/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class BuiltInFieldSets
extends Processor {
    private static final String DOC_FIELDSET_NAME = "[document]";
    public static final String SEARCH_FIELDSET_NAME = "[search]";
    public static final String INTERNAL_FIELDSET_NAME = "[internal]";

    public BuiltInFieldSets(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.addDocumentFieldSet();
        this.addSearchFieldSet();
        this.search.getDocument().setFieldSets(this.search.fieldSets());
    }

    private void addSearchFieldSet() {
        for (SDField searchField : this.search.extraFieldList()) {
            this.search.fieldSets().addBuiltInFieldSetItem(SEARCH_FIELDSET_NAME, searchField.getName());
        }
    }

    private void addDocumentFieldSet() {
        for (Field docField : this.search.getDocument().fieldSet()) {
            if (docField instanceof SDField && ((SDField)docField).isExtraField()) continue;
            this.search.fieldSets().addBuiltInFieldSetItem(DOC_FIELDSET_NAME, docField.getName());
        }
    }
}

