/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.vespa.model.NetworkPortRequestor;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.PortFinder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class HostPorts {
    final String hostname;
    public static final int BASE_PORT = 19100;
    static final int MAX_PORTS = 799;
    private DeployLogger deployLogger = new DeployLogger(){

        public void log(Level level, String message) {
            System.err.println("deploy log[" + level + "]: " + message);
        }
    };
    private final Map<Integer, NetworkPortRequestor> portDB = new LinkedHashMap<Integer, NetworkPortRequestor>();
    private int allocatedPorts = 0;
    private PortFinder portFinder = new PortFinder(Collections.emptyList());
    private Optional<NetworkPorts> networkPortsList = Optional.empty();

    public HostPorts(String hostname) {
        this.hostname = hostname;
    }

    public Optional<NetworkPorts> networkPorts() {
        return this.networkPortsList;
    }

    public void addNetworkPorts(NetworkPorts ports) {
        this.networkPortsList = Optional.of(ports);
        this.portFinder = new PortFinder(ports.allocations());
    }

    public void useLogger(DeployLogger logger) {
        this.deployLogger = logger;
    }

    int nextAvailableBaseport(int numPorts) {
        int port;
        int range = 0;
        for (port = 19100; port < 19899 && range < numPorts; ++port) {
            if (!this.isFree(port)) {
                range = 0;
                continue;
            }
            ++range;
        }
        return range == numPorts ? port - range : 0;
    }

    private int nextAvailableNetworkPort() {
        for (int port = 19100; port < 19899; ++port) {
            if (!this.isFree(port)) continue;
            return port;
        }
        return 0;
    }

    private boolean isFree(int port) {
        return this.portFinder.isFree(port) && !this.portDB.containsKey(port);
    }

    public int requireNetworkPort(int port, NetworkPortRequestor service, String suffix) {
        this.reservePort(service, port, suffix);
        String servType = service.getServiceType();
        String configId = service.getConfigId();
        this.portFinder.use(new NetworkPorts.Allocation(port, servType, configId, suffix));
        return port;
    }

    public int wantNetworkPort(int port, NetworkPortRequestor service, String suffix) {
        if (this.portDB.containsKey(port)) {
            int fallback = this.nextAvailableNetworkPort();
            NetworkPortRequestor s = this.portDB.get(port);
            this.deployLogger.log(Level.WARNING, service.getServiceName() + " cannot reserve port " + port + " on " + this.hostname + ": Already reserved for " + s.getServiceName() + ". Using default port range from " + fallback);
            return this.allocateNetworkPort(service, suffix);
        }
        return this.requireNetworkPort(port, service, suffix);
    }

    public int wantNetworkPort(int port, NetworkPortRequestor service, String suffix, boolean forceRequired) {
        return forceRequired ? this.requireNetworkPort(port, service, suffix) : this.wantNetworkPort(port, service, suffix);
    }

    public int allocateNetworkPort(NetworkPortRequestor service, String suffix) {
        String servType = service.getServiceType();
        String configId = service.getConfigId();
        int fallback = this.nextAvailableNetworkPort();
        int port = this.portFinder.findPort(new NetworkPorts.Allocation(fallback, servType, configId, suffix), this.hostname);
        this.reservePort(service, port, suffix);
        this.portFinder.use(new NetworkPorts.Allocation(port, servType, configId, suffix));
        return port;
    }

    List<Integer> allocatePorts(NetworkPortRequestor service, int wantedPort) {
        PortAllocBridge allocator = new PortAllocBridge(this, service);
        service.allocatePorts(wantedPort, allocator);
        return allocator.result();
    }

    public void flushPortReservations() {
        this.networkPortsList = Optional.of(new NetworkPorts(this.portFinder.allocations()));
    }

    void reservePort(NetworkPortRequestor service, int port, String suffix) {
        if (this.portDB.containsKey(port)) {
            this.portAlreadyReserved(service, port);
        }
        if (this.inVespasPortRange(port)) {
            ++this.allocatedPorts;
            if (this.allocatedPorts > 799) {
                this.noMoreAvailablePorts();
            }
        }
        this.portDB.put(port, service);
    }

    private boolean inVespasPortRange(int port) {
        return port >= 19100 && port < 19899;
    }

    private void portAlreadyReserved(NetworkPortRequestor service, int port) {
        NetworkPortRequestor otherService = this.portDB.get(port);
        int nextAvailablePort = this.nextAvailableBaseport(service.getPortCount());
        if (nextAvailablePort == 0) {
            this.noMoreAvailablePorts();
        }
        String msg = service.getClass().equals(otherService.getClass()) && service.requiresWantedPort() ? "You must set port explicitly for all instances of this service type, except the first one. " : "";
        throw new RuntimeException(service.getServiceName() + " cannot reserve port " + port + " on " + this.hostname + ": Already reserved for " + otherService.getServiceName() + ". " + msg + "Next available port is: " + nextAvailablePort + " ports used: " + this.portDB);
    }

    private void noMoreAvailablePorts() {
        throw new RuntimeException("Too many ports are reserved in Vespa's port range (19100..19899) on " + this.hostname + ". Move one or more services to another host, or outside this port range.");
    }

    public String toString() {
        return "HostPorts{" + this.hostname + "}";
    }
}

