/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminBuilderBase;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DomAdminV2Builder
extends DomAdminBuilderBase {
    private static final String ATTRIBUTE_CLUSTER_CONTROLLER_STANDALONE_ZK = "standalone-zookeeper";

    public DomAdminV2Builder(ConfigModelContext.ApplicationType applicationType, FileRegistry fileRegistry, boolean multitenant, List<ConfigServerSpec> configServerSpecs) {
        super(applicationType, fileRegistry, multitenant, configServerSpecs);
    }

    @Override
    protected void doBuildAdmin(DeployState deployState, Admin admin, Element adminE) {
        List<Configserver> configservers = this.parseConfigservers(deployState, admin, adminE);
        admin.setLogserver(this.parseLogserver(deployState, admin, adminE));
        admin.addConfigservers(configservers);
        admin.addSlobroks(this.getSlobroks(deployState, admin, XML.getChild((Element)adminE, (String)"slobroks")));
        if (!admin.multitenant()) {
            admin.setClusterControllers(this.addConfiguredClusterControllers(deployState, admin, adminE));
        }
        ModelElement adminElement = new ModelElement(adminE);
        this.addLogForwarders(adminElement.child("logforwarding"), admin);
        if (adminElement.child("filedistribution") != null) {
            deployState.getDeployLogger().log(Level.WARNING, "'filedistribution' element is deprecated and ignored");
        }
    }

    private List<Configserver> parseConfigservers(DeployState deployState, Admin admin, Element adminE) {
        List<Configserver> configservers = this.multitenant ? this.getConfigServersFromSpec(deployState.getDeployLogger(), admin) : this.getConfigServers(deployState, admin, adminE);
        int count = configservers.size();
        if (count % 2 == 0) {
            deployState.getDeployLogger().log(Level.WARNING, "An even number (" + count + ") of config servers have been configured. This is discouraged, see doc for configuration server ");
        }
        return configservers;
    }

    private Logserver parseLogserver(DeployState deployState, Admin admin, Element adminE) {
        Element logserverE = XML.getChild((Element)adminE, (String)"logserver");
        if (logserverE == null) {
            logserverE = XML.getChild((Element)adminE, (String)"adminserver");
        }
        return (Logserver)new LogserverBuilder().build(deployState, admin, logserverE);
    }

    private ClusterControllerContainerCluster addConfiguredClusterControllers(DeployState deployState, AbstractConfigProducer parent, Element admin) {
        boolean standaloneZooKeeper;
        Element controllersElements = XML.getChild((Element)admin, (String)"cluster-controllers");
        if (controllersElements == null) {
            return null;
        }
        List controllers = XML.getChildren((Element)controllersElements, (String)"cluster-controller");
        if (controllers.isEmpty()) {
            return null;
        }
        boolean bl = standaloneZooKeeper = "true".equals(controllersElements.getAttribute(ATTRIBUTE_CLUSTER_CONTROLLER_STANDALONE_ZK)) || this.multitenant;
        if (standaloneZooKeeper) {
            parent = new ClusterControllerCluster(parent, "standalone");
        }
        ClusterControllerContainerCluster cluster = new ClusterControllerContainerCluster(parent, "cluster-controllers", "cluster-controllers", deployState);
        ArrayList<ClusterControllerContainer> containers = new ArrayList<ClusterControllerContainer>();
        for (Element controller : controllers) {
            ClusterControllerContainer clusterController = (ClusterControllerContainer)new ClusterControllerBuilder(containers.size(), standaloneZooKeeper).build(deployState, cluster, controller);
            containers.add(clusterController);
        }
        cluster.addContainers(containers);
        return cluster;
    }

    private List<Configserver> getConfigServers(DeployState deployState, AbstractConfigProducer parent, Element adminE) {
        SimpleConfigProducer configServers = new SimpleConfigProducer(parent, "configservers");
        ArrayList<Configserver> cfgs = new ArrayList<Configserver>();
        Element configserversE = XML.getChild((Element)adminE, (String)"configservers");
        if (configserversE == null) {
            Element configserverE = XML.getChild((Element)adminE, (String)"configserver");
            if (configserverE == null) {
                configserverE = XML.getChild((Element)adminE, (String)"adminserver");
            } else {
                deployState.getDeployLogger().log(Level.INFO, "Specifying configserver without parent element configservers in services.xml is deprecated");
            }
            Configserver cfgs0 = (Configserver)new ConfigserverBuilder(0, this.configServerSpecs).build(deployState, configServers, configserverE);
            cfgs0.setProp("index", 0);
            cfgs.add(cfgs0);
            return cfgs;
        }
        int i = 0;
        for (Element configserverE : XML.getChildren((Element)configserversE, (String)"configserver")) {
            Configserver cfgsrv = (Configserver)new ConfigserverBuilder(i, this.configServerSpecs).build(deployState, configServers, configserverE);
            cfgsrv.setProp("index", i);
            cfgs.add(cfgsrv);
            ++i;
        }
        return cfgs;
    }

    private List<Slobrok> getSlobroks(DeployState deployState, AbstractConfigProducer parent, Element slobroksE) {
        List<Slobrok> slobs = new ArrayList<Slobrok>();
        if (slobroksE != null) {
            slobs = this.getExplicitSlobrokSetup(deployState, parent, slobroksE);
        }
        return slobs;
    }

    private List<Slobrok> getExplicitSlobrokSetup(DeployState deployState, AbstractConfigProducer parent, Element slobroksE) {
        ArrayList<Slobrok> slobs = new ArrayList<Slobrok>();
        List slobsE = XML.getChildren((Element)slobroksE, (String)"slobrok");
        int i = 0;
        for (Element e : slobsE) {
            Slobrok slob = (Slobrok)new SlobrokBuilder(i).build(deployState, parent, e);
            slobs.add(slob);
            ++i;
        }
        return slobs;
    }

    private static class ClusterControllerBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<ClusterControllerContainer> {
        int i;
        boolean runStandaloneZooKeeper;

        public ClusterControllerBuilder(int i, boolean runStandaloneZooKeeper) {
            this.i = i;
            this.runStandaloneZooKeeper = runStandaloneZooKeeper;
        }

        @Override
        protected ClusterControllerContainer doBuild(DeployState deployState, AbstractConfigProducer parent, Element spec) {
            return new ClusterControllerContainer(parent, this.i, this.runStandaloneZooKeeper, deployState.isHosted(), null);
        }
    }

    private static class SlobrokBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<Slobrok> {
        int i;

        public SlobrokBuilder(int i) {
            this.i = i;
        }

        @Override
        protected Slobrok doBuild(DeployState deployState, AbstractConfigProducer parent, Element spec) {
            return new Slobrok(parent, this.i);
        }
    }

    private static class ConfigserverBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<Configserver> {
        private final int i;
        private final int rpcPort;

        public ConfigserverBuilder(int i, List<ConfigServerSpec> configServerSpec) {
            this.i = i;
            Objects.requireNonNull(configServerSpec);
            this.rpcPort = configServerSpec.size() > 0 ? configServerSpec.get(0).getConfigServerPort() : 19070;
        }

        @Override
        protected Configserver doBuild(DeployState deployState, AbstractConfigProducer parent, Element spec) {
            return new Configserver(parent, "configserver." + this.i, this.rpcPort);
        }
    }

    private static class LogserverBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<Logserver> {
        @Override
        protected Logserver doBuild(DeployState deployState, AbstractConfigProducer parent, Element producerSpec) {
            return new Logserver(parent);
        }
    }
}

