/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeReindexAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class VespaReindexAction
extends VespaConfigChangeAction
implements ConfigChangeReindexAction {
    private final String name;
    private final String documentType;
    private final boolean allowed;

    private VespaReindexAction(ClusterSpec.Id id, String name, String message, List<ServiceInfo> services, String documentType, boolean allowed) {
        super(id, message, services);
        this.name = name;
        this.documentType = documentType;
        this.allowed = allowed;
    }

    public static VespaReindexAction of(ClusterSpec.Id id, String name, ValidationOverrides overrides, String message, Instant now) {
        return new VespaReindexAction(id, name, message, List.of(), null, overrides.allows(name, now));
    }

    public static VespaReindexAction of(ClusterSpec.Id id, String name, ValidationOverrides overrides, String message, List<ServiceInfo> services, String documentType, Instant now) {
        return new VespaReindexAction(id, name, message, services, documentType, overrides.allows(name, now));
    }

    @Override
    public VespaConfigChangeAction modifyAction(String newMessage, List<ServiceInfo> newServices, String documentType) {
        return new VespaReindexAction(this.clusterId(), this.name, newMessage, newServices, documentType, this.allowed);
    }

    public String name() {
        return this.name;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean allowed() {
        return this.allowed;
    }

    public boolean ignoreForInternalRedeploy() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", documentType='" + this.documentType + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VespaReindexAction that = (VespaReindexAction)o;
        return this.allowed == that.allowed && Objects.equals(this.name, that.name) && Objects.equals(this.documentType, that.documentType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.documentType, this.allowed);
    }
}

