/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeRefeedAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import java.time.Instant;
import java.util.List;

public class VespaRefeedAction
extends VespaConfigChangeAction
implements ConfigChangeRefeedAction {
    private final String name;
    private final String documentType;
    private final boolean allowed;

    private VespaRefeedAction(ClusterSpec.Id id, String name, String message, List<ServiceInfo> services, String documentType, boolean allowed) {
        super(id, message, services);
        this.name = name;
        this.documentType = documentType;
        this.allowed = allowed;
    }

    public static VespaRefeedAction of(ClusterSpec.Id id, String name, ValidationOverrides overrides, String message, Instant now) {
        return new VespaRefeedAction(id, name, message, List.of(), "", overrides.allows(name, now));
    }

    public static VespaRefeedAction of(ClusterSpec.Id id, String name, ValidationOverrides overrides, String message, List<ServiceInfo> services, String documentType, Instant now) {
        return new VespaRefeedAction(id, name, message, services, documentType, overrides.allows(name, now));
    }

    @Override
    public VespaConfigChangeAction modifyAction(String newMessage, List<ServiceInfo> newServices, String documentType) {
        return new VespaRefeedAction(this.clusterId(), this.name, newMessage, newServices, documentType, this.allowed);
    }

    public String name() {
        return this.name;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean allowed() {
        return this.allowed;
    }

    public boolean ignoreForInternalRedeploy() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", documentType='" + this.documentType + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof VespaRefeedAction)) {
            return false;
        }
        VespaRefeedAction other = (VespaRefeedAction)o;
        if (!this.documentType.equals(other.documentType)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return !this.allowed != other.allowed;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + 11 * this.name.hashCode() + this.documentType.hashCode();
    }
}

