/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class QuotaValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        Quota quota = deployState.getProperties().quota();
        quota.maxClusterSize().ifPresent(maxClusterSize -> this.validateMaxClusterSize((int)maxClusterSize, model));
        quota.budgetAsDecimal().ifPresent(budget -> this.validateBudget((BigDecimal)budget, model));
    }

    private void validateBudget(BigDecimal budget, VespaModel model) {
        double spend = model.provisioned().all().values().stream().filter(Objects::nonNull).map(Capacity::maxResources).mapToDouble(clusterCapacity -> clusterCapacity.nodeResources().cost() * (double)clusterCapacity.nodes()).sum();
        if (budget.doubleValue() < spend) {
            this.throwBudgetExceeded(spend, budget);
        }
    }

    private void validateMaxClusterSize(int maxClusterSize, VespaModel model) {
        List invalidClusters = model.provisioned().all().entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> {
            Capacity cluster = (Capacity)entry.getValue();
            int clusterSize = cluster.maxResources().nodes();
            return clusterSize > maxClusterSize;
        }).map(Map.Entry::getKey).map(ClusterSpec.Id::value).collect(Collectors.toList());
        if (!invalidClusters.isEmpty()) {
            String clusterNames = String.join((CharSequence)", ", invalidClusters);
            throw new IllegalArgumentException("Clusters " + clusterNames + " exceeded max cluster size of " + maxClusterSize);
        }
    }

    private void throwBudgetExceeded(double spend, BigDecimal budget) {
        String message = String.format(Locale.US, "Hourly spend for maximum specified resources ($%.2f) exceeds budget from quota ($%.2f)!", spend, budget);
        throw new IllegalArgumentException(message);
    }
}

