/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.model.AbstractService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class FileSender
implements Serializable {
    public static FileReference sendFileToServices(String relativePath, Collection<? extends AbstractService> services) {
        if (services.isEmpty()) {
            throw new IllegalStateException("No service instances. Probably a standalone cluster setting up <nodes> using 'count' instead of <node> tags.");
        }
        FileReference fileref = null;
        for (AbstractService abstractService : services) {
            fileref = abstractService.sendFile(relativePath);
        }
        return fileref;
    }

    public static FileReference sendUriToServices(String uri, Collection<? extends AbstractService> services) {
        if (services.isEmpty()) {
            throw new IllegalStateException("No service instances. Probably a standalone cluster setting up <nodes> using 'count' instead of <node> tags.");
        }
        FileReference fileref = null;
        for (AbstractService abstractService : services) {
            fileref = abstractService.sendUri(uri);
        }
        return fileref;
    }

    public static <PRODUCER extends AbstractConfigProducer<?>> void sendUserConfiguredFiles(PRODUCER producer, Collection<? extends AbstractService> services, DeployLogger logger) {
        if (services.isEmpty()) {
            return;
        }
        UserConfigRepo userConfigs = producer.getUserConfigs();
        HashMap<String, FileReference> sentFiles = new HashMap<String, FileReference>();
        for (ConfigDefinitionKey key : userConfigs.configsProduced()) {
            ConfigPayloadBuilder builder = userConfigs.get(key);
            try {
                FileSender.sendUserConfiguredFiles(builder, sentFiles, services, key, logger);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to send files for " + key, e);
            }
        }
    }

    private static void sendUserConfiguredFiles(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles, Collection<? extends AbstractService> services, ConfigDefinitionKey key, DeployLogger logger) {
        ConfigPayloadBuilder.MapBuilder map;
        ConfigPayloadBuilder.Array array;
        ConfigDefinition configDefinition = builder.getConfigDefinition();
        if (configDefinition == null) {
            logger.log(Level.WARNING, "Not able to find config definition for " + key + ". Will not send files for this config");
            return;
        }
        FileSender.sendEntries(builder, sentFiles, services, configDefinition.getFileDefs());
        FileSender.sendEntries(builder, sentFiles, services, configDefinition.getPathDefs());
        for (Map.Entry<String, ConfigDefinition.ArrayDef> entry : configDefinition.getArrayDefs().entrySet()) {
            if (!FileSender.isFileOrPathArray(entry)) continue;
            array = builder.getArray(entry.getKey());
            FileSender.sendFileEntries(array.getElements(), sentFiles, services);
        }
        for (Map.Entry<String, ConfigDefinition.LeafMapDef> entry : configDefinition.getLeafMapDefs().entrySet()) {
            if (!FileSender.isFileOrPathMap(entry)) continue;
            map = builder.getMap(entry.getKey());
            FileSender.sendFileEntries(map.getElements(), sentFiles, services);
        }
        for (String string : configDefinition.getStructDefs().keySet()) {
            FileSender.sendUserConfiguredFiles(builder.getObject(string), sentFiles, services, key, logger);
        }
        for (String string : configDefinition.getInnerArrayDefs().keySet()) {
            array = builder.getArray(string);
            for (ConfigPayloadBuilder element : array.getElements()) {
                FileSender.sendUserConfiguredFiles(element, sentFiles, services, key, logger);
            }
        }
        for (String string : configDefinition.getStructMapDefs().keySet()) {
            map = builder.getMap(string);
            for (ConfigPayloadBuilder element : map.getElements()) {
                FileSender.sendUserConfiguredFiles(element, sentFiles, services, key, logger);
            }
        }
    }

    private static boolean isFileOrPathMap(Map.Entry<String, ConfigDefinition.LeafMapDef> entry) {
        String mapType = entry.getValue().getTypeSpec().getType();
        return "file".equals(mapType) || "path".equals(mapType);
    }

    private static boolean isFileOrPathArray(Map.Entry<String, ConfigDefinition.ArrayDef> entry) {
        String arrayType = entry.getValue().getTypeSpec().getType();
        return "file".equals(arrayType) || "path".equals(arrayType);
    }

    private static void sendEntries(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles, Collection<? extends AbstractService> services, Map<String, ? extends ConfigDefinition.DefaultValued<String>> entries) {
        for (String name : entries.keySet()) {
            ConfigPayloadBuilder fileEntry = builder.getObject(name);
            if (fileEntry.getValue() == null) {
                throw new IllegalArgumentException("Unable to send file for field '" + name + "'. Invalid config value " + fileEntry.getValue());
            }
            FileSender.sendFileEntry(fileEntry, sentFiles, services);
        }
    }

    private static void sendFileEntries(Collection<ConfigPayloadBuilder> builders, Map<String, FileReference> sentFiles, Collection<? extends AbstractService> services) {
        for (ConfigPayloadBuilder builder : builders) {
            FileSender.sendFileEntry(builder, sentFiles, services);
        }
    }

    private static void sendFileEntry(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles, Collection<? extends AbstractService> services) {
        String path = builder.getValue();
        FileReference reference = sentFiles.get(path);
        if (reference == null) {
            reference = FileSender.sendFileToServices(path, services);
            sentFiles.put(path, reference);
        }
        builder.setValue(reference.value());
    }
}

