/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.config.model.api.Reindexing;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.config.content.reindexing.ReindexingConfig;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.Collection;

class ReindexingController
extends SimpleComponent
implements ReindexingConfig.Producer {
    static final String REINDEXING_CONTROLLER_BUNDLE = "clustercontroller-reindexer";
    private final Reindexing reindexing;
    private final String contentClusterName;
    private final Collection<NewDocumentType> documentTypes;

    ReindexingController(ReindexingContext context) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)"reindexing-maintainer", (String)"ai.vespa.reindexing.ReindexingMaintainer", (String)REINDEXING_CONTROLLER_BUNDLE)));
        this.reindexing = context.reindexing();
        this.contentClusterName = context.contentClusterName();
        this.documentTypes = context.documentTypes();
    }

    public void getConfig(ReindexingConfig.Builder builder) {
        builder.clusterName(this.contentClusterName);
        builder.enabled(this.reindexing.enabled());
        for (NewDocumentType type : this.documentTypes) {
            String typeName = type.getFullName().getName();
            this.reindexing.status(this.contentClusterName, typeName).ifPresent(status -> builder.status(typeName, new ReindexingConfig.Status.Builder().readyAtMillis(status.ready().toEpochMilli())));
        }
    }
}

