/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.path.Path;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import com.yahoo.vespa.model.ml.ConvertedModel;
import com.yahoo.vespa.model.ml.FeatureArguments;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class OnnxFeatureConverter
extends ExpressionTransformer<RankProfileTransformContext> {
    private final Map<Path, ConvertedModel> convertedOnnxModels = new HashMap<Path, ConvertedModel>();

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return super.transformChildren((CompositeNode)node, (TransformContext)context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode feature, RankProfileTransformContext context) {
        if (!feature.getName().equals("onnx") && !feature.getName().equals("onnx_vespa")) {
            return feature;
        }
        try {
            FeatureArguments arguments = this.asFeatureArguments(feature.getArguments());
            ConvertedModel convertedModel = this.convertedOnnxModels.computeIfAbsent(arguments.path(), path -> ConvertedModel.fromSourceOrStore(path, true, context));
            return convertedModel.expression(arguments, context);
        }
        catch (UncheckedIOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not use Onnx model from " + feature, e);
        }
    }

    private FeatureArguments asFeatureArguments(Arguments arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("An ONNX node must take an argument pointing to the ONNX model file under [application]/models");
        }
        if (arguments.expressions().size() > 3) {
            throw new IllegalArgumentException("An onnx feature can have at most 3 arguments");
        }
        return new FeatureArguments(arguments);
    }
}

