/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class FileStorProducer
implements StorFilestorConfig.Producer {
    private final Integer numThreads;
    private final ContentCluster cluster;
    private final int reponseNumThreads;
    private final StorFilestorConfig.Response_sequencer_type.Enum responseSequencerType;

    private static StorFilestorConfig.Response_sequencer_type.Enum convertResponseSequencerType(String sequencerType) {
        try {
            return StorFilestorConfig.Response_sequencer_type.Enum.valueOf((String)sequencerType);
        }
        catch (Throwable t) {
            return StorFilestorConfig.Response_sequencer_type.Enum.ADAPTIVE;
        }
    }

    public FileStorProducer(ModelContext.Properties properties, ContentCluster parent, Integer numThreads) {
        this.numThreads = numThreads;
        this.cluster = parent;
        this.reponseNumThreads = properties.defaultNumResponseThreads();
        this.responseSequencerType = FileStorProducer.convertResponseSequencerType(properties.responseSequencerType());
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        if (this.numThreads != null) {
            builder.num_threads(this.numThreads.intValue());
        }
        builder.enable_multibit_split_optimalization(this.cluster.getPersistence().enableMultiLevelSplitting());
        builder.num_response_threads(this.reponseNumThreads);
        builder.response_sequencer_type(this.responseSequencerType);
    }

    public static class Builder {
        protected FileStorProducer build(ModelContext.Properties properties, ContentCluster parent, ModelElement clusterElem) {
            return new FileStorProducer(properties, parent, this.getThreads(clusterElem));
        }

        private Integer getThreads(ModelElement clusterElem) {
            ModelElement tuning = clusterElem.child("tuning");
            if (tuning == null) {
                return null;
            }
            ModelElement threads = tuning.child("persistence-threads");
            if (threads == null) {
                return null;
            }
            Integer count = threads.integerAttribute("count");
            if (count != null) {
                return count;
            }
            int numThreads = 0;
            for (ModelElement thread : threads.subElements("thread")) {
                count = thread.integerAttribute("count");
                numThreads += count == null ? 1 : count;
            }
            return numThreads;
        }
    }
}

