/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRefeedAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentTypeChangeValidator {
    private final ClusterSpec.Id id;
    private final NewDocumentType currentDocType;
    private final NewDocumentType nextDocType;

    public DocumentTypeChangeValidator(ClusterSpec.Id id, NewDocumentType currentDocType, NewDocumentType nextDocType) {
        this.id = id;
        this.currentDocType = currentDocType;
        this.nextDocType = nextDocType;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        return this.currentDocType.getAllFields().stream().map(field -> DocumentTypeChangeValidator.createFieldChange(field, this.nextDocType)).filter(fieldChange -> fieldChange.valid() && fieldChange.changedType()).map(fieldChange -> VespaRefeedAction.of(this.id, "field-type-change", overrides, new ChangeMessageBuilder(fieldChange.fieldName()).addChange("data type", fieldChange.currentTypeName(), fieldChange.nextTypeName()).build(), now)).collect(Collectors.toList());
    }

    private static FieldChange createFieldChange(Field currentField, NewDocumentType nextDocType) {
        Field nextField = nextDocType.getField(currentField.getName());
        if (nextField != null && DocumentTypeChangeValidator.areStructFields(currentField, nextField)) {
            return new StructFieldChange(currentField, nextField);
        }
        return new SimpleFieldChange(currentField, nextField);
    }

    private static boolean areStructFields(Field currentField, Field nextField) {
        return currentField.getDataType() instanceof StructDataType && nextField.getDataType() instanceof StructDataType;
    }

    private static class StructFieldChange
    extends FieldChange {
        private final StructDataType currentType;
        private final StructDataType nextType;

        public StructFieldChange(Field currentField, Field nextField) {
            super(currentField, nextField);
            this.currentType = (StructDataType)currentField.getDataType();
            this.nextType = (StructDataType)nextField.getDataType();
        }

        @Override
        public boolean changedType() {
            return StructFieldChange.changedType(this.currentType, this.nextType);
        }

        @Override
        public String currentTypeName() {
            return StructFieldChange.toString(this.currentType);
        }

        @Override
        public String nextTypeName() {
            return StructFieldChange.toString(this.nextType);
        }

        private static boolean changedType(StructDataType currentType, StructDataType nextType) {
            for (Field currentField : currentType.getFields()) {
                Field nextField = nextType.getField(currentField.getName());
                if (nextField == null || !(DocumentTypeChangeValidator.areStructFields(currentField, nextField) ? StructFieldChange.changedType((StructDataType)currentField.getDataType(), (StructDataType)nextField.getDataType()) : !currentField.getDataType().equals((Object)nextField.getDataType()))) continue;
                return true;
            }
            return false;
        }

        private static String toString(StructDataType dataType) {
            StringBuilder builder = new StringBuilder();
            builder.append(dataType.getName()).append(":{");
            boolean first = true;
            for (Field field : dataType.getFields()) {
                if (!first) {
                    builder.append(",");
                }
                if (field.getDataType() instanceof StructDataType) {
                    builder.append(StructFieldChange.toString((StructDataType)field.getDataType()));
                } else {
                    builder.append(field.getName() + ":" + field.getDataType().getName());
                }
                first = false;
            }
            builder.append("}");
            return builder.toString();
        }
    }

    private static class SimpleFieldChange
    extends FieldChange {
        public SimpleFieldChange(Field currentField, Field nextField) {
            super(currentField, nextField);
        }

        @Override
        public boolean changedType() {
            return !this.currentField.getDataType().equals((Object)this.nextField.getDataType());
        }

        @Override
        public String currentTypeName() {
            return this.currentField.getDataType().getName();
        }

        @Override
        public String nextTypeName() {
            return this.nextField.getDataType().getName();
        }
    }

    private static abstract class FieldChange {
        protected final Field currentField;
        protected final Field nextField;

        public FieldChange(Field currentField, Field nextField) {
            this.currentField = currentField;
            this.nextField = nextField;
        }

        public String fieldName() {
            return this.currentField.getName();
        }

        public boolean valid() {
            return this.nextField != null;
        }

        public abstract boolean changedType();

        public abstract String currentTypeName();

        public abstract String nextTypeName();
    }
}

